/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean;

import java.util.List;

import jp.mosp.framework.base.MospException;

/**
 * エクスポートテーブル参照インターフェース。
 */
public interface ExportTableReferenceBeanInterface {
	
	/**
	 * テーブル内容表示欄を取得する。
	 * @param table テーブル
	 * @param selectSelectedArray テーブル内容選択欄配列
	 * @return テーブル内容表示欄
	 */
	String[][] getSelectTable(String table, String[][] selectSelectedArray);
	
	/**
	 * テーブル内容選択欄を取得する。
	 * @param exportCode エクスポートコード
	 * @return テーブル内容選択欄
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	String[][] getSelectSelected(String exportCode) throws MospException;
	
	/**
	 * エクスポートを行う。<br>
	 * @return エクスポートリスト
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	List<String[]> export() throws MospException;
	
	/**
	 * @param exportCode セットする exportCode
	 */
	void setExportCode(String exportCode);
	
	/**
	 * @param startYear セットする startYear
	 */
	void setStartYear(int startYear);
	
	/**
	 * @param startMonth セットする startMonth
	 */
	void setStartMonth(int startMonth);
	
	/**
	 * @param endYear セットする endYear
	 */
	void setEndYear(int endYear);
	
	/**
	 * @param endMonth セットする endMonth
	 */
	void setEndMonth(int endMonth);
	
	/**
	 * @param cutoffCode セットする cutoffCode
	 */
	void setCutoffCode(String cutoffCode);
	
	/**
	 * @param workPlaceCode セットする workPlaceCode
	 */
	void setWorkPlaceCode(String workPlaceCode);
	
	/**
	 * @param employmentCode セットする employmentCode
	 */
	void setEmploymentCode(String employmentCode);
	
	/**
	 * @param sectionCode セットする sectionCode
	 */
	void setSectionCode(String sectionCode);
	
	/**
	 * @param positionCode セットする positionCode
	 */
	void setPositionCode(String positionCode);
	
}
