/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.human.constant;

/**
 * MosPプラットフォーム人事管理機能で用いる定数を宣言する。<br>
 */
public class PlatformHumanConst {
	
	/**
	 * 他クラスからのインスタンス化を防止する。<br>
	 */
	private PlatformHumanConst() {
		// 処理無し
	}
	

	/**
	 * ファイルパス(MosPプラットフォーム人事管理共通JSP)。
	 */
	public static final String	PATH_HUMAN_COMMON_INFO_JSP	= "/jsp/platform/human/humanCommonInfo.jsp";
	
	/**
	 * 人事管理共通情報表示モード(全て表示)。
	 */
	public static final String	MODE_HUMAN_SHOW_ALL			= "all";
	
	/**
	 * 人事管理共通情報表示モード(社員コード、氏名のみ表示)。
	 */
	public static final String	MODE_HUMAN_CODE_AND_NAME	= "codeAndName";
	
	/**
	 * 人事管理共通情報表示モード(再表示なし)。
	 */
	public static final String	MODE_HUMAN_NO_ACTIVATE_DATE	= "noActiveDate";
	
	/**
	 * 検索モード(社員コード)。
	 */
	public static final String	SEARCH_EMPLOYEE_CODE		= "searchEmployeeCode";
	
	/**
	 * 検索モード(対象日)。
	 */
	public static final String	SEARCH_TARGET_DATE			= "searchTargetDate";
	
	/**
	 * 検索モード(個人ID[前])。
	 */
	public static final String	SEARCH_BACK					= "searchBack";
	
	/**
	 * 検索モード(個人ID[後])。
	 */
	public static final String	SEARCH_NEXT					= "searchNext";
	
	/**
	 * 検索モード。
	 */
	public static final String	PRM_TRANSFER_SEARCH_MODE	= "transferSearch";
	
	/**
	 * パラメータID(再表示有効日(年))。<br>
	 */
	public static final String	PRM_TXT_ACTIVATE_YEAR		= "txtSearchActivateYear";
	
	/**
	 * パラメータID(再表示有効日(月))。<br>
	 */
	public static final String	PRM_TXT_ACTIVATE_MONTH		= "txtSearchActivateMonth";
	
	/**
	 * パラメータID(再表示有効日(日))。<br>
	 */
	public static final String	PRM_TXT_ACTIVATE_DAY		= "txtSearchActivateDay";
	
	/**
	 * パラメータID(検索社員コード)。<br>
	 */
	public static final String	PRM_TXT_EMPLOYEE_CODE		= "txtSearchEmployeeCode";
	
}
