/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.BaseBean;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.human.EmployeeReferenceBeanInterface;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.entity.EmployeeEntity;
import jp.mosp.platform.entity.EmployeeEntityInterface;

/**
 * 社員情報参照クラス。
 */
public class EmployeeReferenceBean extends BaseBean implements EmployeeReferenceBeanInterface {
	
	private HumanReferenceBeanInterface					human;
	
	private EntranceReferenceBeanInterface				entrance;
	
	private SuspensionReferenceBeanInterface			suspension;
	
	private RetirementReferenceBeanInterface			retirement;
	
	private ConcurrentReferenceBeanInterface			concurrent;
	
	private EmploymentContractReferenceBeanInterface	empContract;
	
	private SectionReferenceBeanInterface				section;
	
	private PositionReferenceBeanInterface				position;
	

	/**
	 * コンストラクタ。
	 */
	public EmployeeReferenceBean() {
		super();
	}
	
	/**
	 * コンストラクタ。
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	protected EmployeeReferenceBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		human = (HumanReferenceBeanInterface)createBean(HumanReferenceBeanInterface.class);
		entrance = (EntranceReferenceBeanInterface)createBean(EntranceReferenceBeanInterface.class);
		suspension = (SuspensionReferenceBeanInterface)createBean(SuspensionReferenceBeanInterface.class);
		retirement = (RetirementReferenceBeanInterface)createBean(RetirementReferenceBeanInterface.class);
		concurrent = (ConcurrentReferenceBeanInterface)createBean(ConcurrentReferenceBeanInterface.class);
		empContract = (EmploymentContractReferenceBeanInterface)createBean(EmploymentContractReferenceBeanInterface.class);
		section = (SectionReferenceBeanInterface)createBean(SectionReferenceBeanInterface.class);
		position = (PositionReferenceBeanInterface)createBean(PositionReferenceBeanInterface.class);
	}
	
	@Override
	public EmployeeEntityInterface getEntity(HumanDtoInterface dto, Date targetDate) throws Exception {
		EmployeeEntityInterface entity = new EmployeeEntity();
		if (dto != null) {
			entity.setEmployeeCode(dto.getEmployeeCode());
			entity.setActivateDate(targetDate);
			entity.setHumanDto(dto);
			entity.setEntranceDto(entrance.getEntranceInfo(dto.getPersonalId()));
			entity.setSuspensionDto(suspension.getSuspentionInfo(dto.getPersonalId(), targetDate));
			entity.setRetirementDto(retirement.getRetireInfo(dto.getPersonalId(), targetDate));
			entity.setConcurrentList(concurrent.getConcurrentList(dto.getPersonalId(), targetDate));
			entity.setEmploymentContractDto(empContract.getContractInfo(dto.getEmploymentContractCode(),
					targetDate));
			entity.setSectionDto(section.getSectionInfo(dto.getSectionCode(), targetDate));
			entity.setPositionDto(position.getPositionInfo(dto.getPositionCode(), targetDate));
			
		}
		return entity;
	}
	
	@Override
	public EmployeeEntityInterface getEntity(String personalId, Date targetDate) throws Exception {
		return getEntity(human.getHumanInfo(personalId, targetDate), targetDate);
	}
	
	@Override
	public List<EmployeeEntityInterface> getEntityList(List<HumanDtoInterface> humanlist, Date targetDate)
			throws Exception {
		List<EmployeeEntityInterface> list = new ArrayList<EmployeeEntityInterface>();
		for (HumanDtoInterface dto : humanlist) {
			list.add(getEntity(dto, targetDate));
		}
		return list;
	}
	
}
