/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * Vo̊{@\񋟂B<br>
 * <br>
 * MosPt[[Nł́AHTTPNGXgɂđꂽp[^
 * VoCX^Xɐݒ肵ArWlXWbNsAUIɕ\
 * eVoɐݒ肵ViewɏϏ邱Ƃz肵ĂB<br>
 * ܂AUIƃrWlXWbNƂ̋n̂Vo̖ƂȂB<br>
 * <br>
 * eAvP[VɂāANXgVoNX
 * 쐬邱ƂŁAMosPt[[NLɗpłB<br>
 * <br>
 * VóA{IɃtB[hyуANZT\bhLlێp
 * NXƂĒ`B<br>
 * <br>
 * BaseVóAMosPt[[NɂċʂŗptB[hy
 * ̃ANZT\bhB<br>
 * 
 */
public class BaseVo implements VoInterface, Serializable {

	private static final long serialVersionUID = -5856596970807014781L;
	
	// tB[h
	private String title;
	private String version;
	private String copy;
	private String aspUserId;
	private String aspName;
	private String userId;
	private String userName;
	private String commonCss;
	private String message;
	private String procSeq;
	private boolean isDialog;
	private List<String> extraJs;
	private List<String> extraCss;
	
	/**
	 * NGXgꂽR}hB<br>
	 */
	protected String cmd;
	
	/**
	 * ÓmFptOB<br>
	 */
	protected boolean isValid;
	
	/**
	 * MosPAvP[Vݒ(/WEB-INF/mosp.properties)B<br>
	 */
	protected Properties cfg;
	
	/**
	 * bZ[Wݒ(/WEB-INF/message.properties)B<br>
	 */
	protected Properties msg;
	
	/**
	 * ݒ(/WEB-INF/naming.properties)B<br>
	 */
	protected Properties nam;
	
	
	/**
	 * G[bZ[WB
	 */
	protected List<String> errMessage;
	
	/**
	 * G[tB[hB
	 */
	protected ArrayList<String> errFields;
	
	/**
	 * G[tB[h()B
	 */
	protected ArrayList<DetailsVo> errDetails;
	
	/**
	 * javascripto͗vۃtOB<br>
	 * {@link #getDirectJs(Class, Object)}javascripto͗v۔ƂȂB<br>
	 */
	protected boolean needDirectJs;
	
	/**
	 * tH[hURLB<br>
	 * eVoɑΉjspt@CURLݒ肷B
	 */
	protected String retUrl;
	
	/**
	 * X|XƂXMLԂꍇɗpB<br>
	 */
	protected transient Document docXml;
	
	/**
	 * X|XƕԂXMLɕt郊^[R[hB<br>
	 */
	protected String xmlRetCode;
	
	/**
	 * Tu^CgB<br><br>
	 * {@link HtmlUtility#getSubTitle(BaseVo)}ŁApB<br>
	 */
	protected String subTitle;
	
	/**
	 * j[zB<br><br>
	 * {@link HtmlUtility#getSubTitle(BaseVo)}ŁApB<br>
	 */
	protected String[][] aryMenu;
	
	/**
	 * VȌݒsB<br><br>
	 * <ul><li>
	 * {@link #needDirectJs}ݒ(false)<br>
	 * </li></ul>
	 */
	public BaseVo() {
		needDirectJs = false;
	}
	
	/**
	 * VȌݒsB<br><br>
	 * <ul><li>
	 * {@link #BaseVo()}
	 * </li><li>
	 * {@link #initVo(Properties, Properties, Properties, String, CmAspUserDto, CmUserDto)}
	 * </li><li>
	 * {@link #setSubTitle()}
	 * </li></ul>
	 * @param cfg     ݒt@C
	 * @param msg     bZ[Wt@C
	 * @param nam     t@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 */
	public BaseVo(
			Properties   cfg,
			Properties   msg,
			Properties   nam,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user
	) {
		this();
		initVo(cfg, msg, nam, cmd, aspUser, user);
		setFieldsName();
		setSubTitle();
	}
	
	/**
	 * VOB<br><br>
	 * ȉ̐ݒt@Cݒ肷B<br>
	 * <ul><li>
	 * {@link #cfg}
	 * </li><li>
	 * {@link #msg}
	 * </li><li>
	 * {@link #nam}
	 * </li></ul><br><br>
	 * ܂A[U[񓙂̏sB<br>
	 * @param cfg     ݒt@C
	 * @param msg     bZ[Wt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 */
	public void initVo(
			Properties   cfg,
			Properties   msg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user
	) {
		this.cfg = cfg;
		this.msg = msg;
		this.cmd = cmd;
		this.title = cfg.getProperty(MospConst.PPT_APP_TITLE);
		this.version = cfg.getProperty(MospConst.PPT_APP_VERSION);
		this.copy = cfg.getProperty(MospConst.PPT_APP_COPY);
		if (aspUser != null) {
			this.aspUserId = aspUser.getAspUserId();
			this.aspName = aspUser.getAspName();
		}
		if (user != null) {
			this.userId = user.getUserId();
			this.userName = user.getUserName();
			this.commonCss = user.getCommonCss();
		}
		this.commonCss = this.commonCss == null || this.commonCss.equals("") ? MospConst.CSS_DEFAULT : this.commonCss;
		this.xmlRetCode = MospConst.XML_RETCODE_OK;
		this.isDialog = false;
	}
	
	/**
	 * VOB<br><br>
	 * {@link #initVo(Properties, Properties, String, CmAspUserDto, CmUserDto)}
	 * ɉA{@link #nam}ݒ肷B
	 * @param cfg     ݒt@C
	 * @param msg     bZ[Wt@C
	 * @param nam     t@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 */
	public void initVo(
			Properties   cfg,
			Properties   msg,
			Properties   nam,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user
	) {
		initVo(cfg, msg, cmd, aspUser, user);
		this.nam = nam;
		setFieldsName();
		setSubTitle();
	}
	
	/**
	 * ږ̂ݒ肷B<br><br>
	 * {@link #nam}當擾Aږ̂ݒ肷B<br>
	 * {@link BaseVo}gNXŃI[o[ChėpB<br>
	 */
	protected void setFieldsName() {
		// 
	}
	
	/**
	 * Tu^Cgݒ肷B<br><br>
	 * {@link #nam}當擾Aȉ̃tB[hݒ肷B<br>
	 * <ul><li>
	 * {@link #subTitle}
	 * </li><li>
	 * {@link #aryMenu}
	 * </li></ul><br><br>
	 * {@link BaseVo}gNXŃI[o[ChėpB<br>
	 */
	protected void setSubTitle() {
		subTitle = "";
		aryMenu = null;
	}
	
	/**
	 * AvP[V^Cg擾B<br>
	 * AvP[V^CǵA
	 * {@link #initVo(Properties, Properties, String, CmAspUserDto, CmUserDto)}
	 * mosp.propertiesl擾Aݒ肳B<br>
	 * @return AvP[V^Cg
	 */
	public String getTitle() { return title; }
	
	/**
	 * AvP[V^Cg擾B<br>
	 * AvP[V^Cgmosp.propertiesŐݒ肷B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return AvP[V^Cg
	 */
	public String getEscTitle() { return escapeHTML(title); }
	
	/**
	 * AvP[V^Cgݒ肷B<br>
	 * @param title AvP[V^Cg<br>
	 */
	public void setTitle(String title) { this.title = title; }
	
	/**
	 * AvP[Vo[W擾B<br>
	 * AvP[Vo[Wmosp.propertiesŐݒ肷B<br>
	 * @return AvP[Vo[W
	 */
	public String getVersion() { return version; }
	
	/**
	 * AvP[Vo[W擾B<br>
	 * AvP[Vo[Wmosp.propertiesŐݒ肷B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return AvP[Vo[W
	 */
	public String getEscVersion() { return escapeHTML(version); }
	
	/**
	 * AvP[Vo[Wݒ肷B
	 * @param version AvP[Vo[W
	 */
	public void setVersion(String version) { this.version = version; }
	
	/**
	 * AvP[V쌠\擾B<br>
	 * AvP[V쌠\mosp.propertiesŐݒ肷B<br>
	 * @return AvP[V쌠\
	 */
	public String getCopy() { return copy; }
	
	/**
	 * AvP[V쌠\擾B<br>
	 * AvP[V쌠\mosp.propertiesŐݒ肷B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return AvP[V쌠\
	 */
	public String getEscCopy() { return escapeHTML(copy); }
	
	/**
	 * AvP[V쌠\ݒ肷B<br>
	 * @param copy AvP[V쌠\
	 */
	public void setCopy(String copy) { this.copy = copy; }
	
	/**
	 * ASP[U[ID擾B<br>
	 * @return ASP[U[ID
	 */
	public String getAspUserId() { return aspUserId; }
	
	/**
	 * ASP[U[ID擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return ASP[U[ID
	 */
	public String getEscAspUserId() { return escapeHTML(aspUserId); }
	
	/**
	 * ASP[U[IDݒ肷B<br>
	 * @param aspUserId ASP[U[ID
	 */
	public void setAspUserId(String aspUserId) { this.aspUserId = aspUserId; }
	
	/**
	 * ASP[U[擾B<br>
	 * @return ASP[U[
	 */
	public String getAspName() { return aspName; }
	
	/**
	 * ASP[U[擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return ASP[U[
	 */
	public String getEscAspName() { return escapeHTML(aspName); }
	
	/**
	 * ASP[U[ݒ肷B<br>
	 * @param aspName ASP[U[
	 */
	public void setAspName(String aspName) { this.aspName = aspName; }
	
	/**
	 * [U[ID擾B<br>
	 * @return [U[ID
	 */
	public String getUserId() { return userId; }
	
	/**
	 * [U[ID擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return [U[ID
	 */
	public String getEscUserId() { return escapeHTML(userId); }
	
	/**
	 * [U[IDݒ肷B<br>
	 * @param userId [U[ID
	 */
	public void setUserId(String userId) { this.userId = userId; }
	
	/**
	 * [U[擾B<br>
	 * @return [U[
	 */
	public String getUserName() { return userName; }
	
	/**
	 * [U[擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return [U[
	 */
	public String getEscUserName() { return escapeHTML(userName); }
	
	/**
	 * [U[ݒ肷B<br>
	 * @param userName [U[
	 */
	public void setUserName(String userName) { this.userName = userName; }
	
	/**
	 * csst@CURL擾B<br>
	 * @return csst@CURL
	 */
	public String getCommonCss() { return commonCss; }
	
	/**
	 * csst@CURL擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return csst@CURL
	 */
	public String getEscCommonCss() { return escapeHTML(commonCss); }
	
	/**
	 * csst@CURLݒ肷B<br>
	 * @param commonCss csst@CURL
	 */
	public void setCommonCss(String commonCss) { this.commonCss = commonCss; }
	
	/**
	 * javascriptt@CURL擾B<br>
	 * @return javascriptt@CURL
	 */
	public List<String> getExtraJs() { return extraJs; }
	
	/**
	 * javascriptt@CURLݒ肷B<br>
	 * @param extraJs javascriptt@CURL
	 */
	public void setExtraJs(String extraJs) {
		this.extraJs = new ArrayList<String>();
		this.extraJs.add(extraJs);
	}
	
	/**
	 * javascriptt@CURLǉB<br>
	 * @param extraJs javascriptt@CURL
	 */
	public void addExtraJs(String extraJs) {
		this.extraJs = this.extraJs != null ? this.extraJs : new ArrayList<String>();
		this.extraJs.add(extraJs);
	}
	
	/**
	 * csst@CURL擾B<br>
	 * @return csst@CURL
	 */
	public List<String> getExtraCss() { return extraCss; }
	
	/**
	 * csst@CURLݒ肷B<br>
	 * @param extraCss csst@CURL
	 */
	public void setExtraCss(String extraCss) {
		this.extraCss = new ArrayList<String>();
		this.extraCss.add(extraCss);
	}
	
	/**
	 * csst@CURLǉB<br>
	 * @param extraCss csst@CURL
	 */
	public void addExtraCss(String extraCss) {
		this.extraCss = this.extraCss != null ? this.extraCss : new ArrayList<String>();
		this.extraCss.add(extraCss);
	}
	
	/**
	 * bZ[W擾B<br>
	 * @return bZ[W
	 */
	public String getMessage() { return message; }
	
	/**
	 * bZ[W擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return bZ[W
	 */
	public String getEscMessage() { return escapeHTML(message); }
	
	/**
	 * bZ[Wݒ肷B<br>
	 * @param message
	 */
	public void setMessage(String message) { this.message = message; }
	
	/**
	 * V[PX擾B<br>
	 * @return V[PX
	 */
	public String getProcSeq() { return procSeq; }
	
	/**
	 * V[PX擾B<br>
	 * 擾HTMLGXP[vB<br>
	 * @return V[PX
	 */
	public String getEscProcSeq() { return escapeHTML(procSeq); }
	
	/**
	 * V[PXݒ肷B<br>
	 * @param procSeq V[PX
	 */
	public void setProcSeq(String procSeq) { this.procSeq = procSeq; }
	
	/**
	 * G[bZ[Wݒ肷B<br>
	 * @param errMessage G[bZ[WXg
	 */
	public void setErrMessage(List<String> errMessage) { this.errMessage = errMessage; }
	
	/**
	 * G[bZ[W擾B<br>
	 * @return G[bZ[W
	 */
	public List<String> getErrMessage() { return errMessage; }
	
	/**
	 * tH[hURL擾B<br>
	 * @return tH[hURL
	 */
	public String getRetUrl() { return retUrl; }
	
	/**
	 * tH[hURLݒ肷B<br>
	 * @param retUrl tH[hURL
	 */
	public void setRetUrl(String retUrl) { this.retUrl = retUrl; }
	
	/**
	 * XML^[R[h擾B<br>
	 * @return XML^[R[h
	 */
	public String getXmlRetCode() { return xmlRetCode; }
	
	/**
	 * XML^[R[hݒ肷B<br>
	 * @param xmlRetCode XML^[R[h
	 */
	public void setXmlRetCode(String xmlRetCode) { this.xmlRetCode = xmlRetCode; }
	
	/**
	 * XMLhLg擾B<br>
	 * @return XMLhLg
	 */
	public Document getDocXml() { return docXml; }
	
	/**
	 * _CAOtO擾B<br>
	 * @return _CAOtO
	 */
	public boolean getIsDialog() { return isDialog; }
	
	/**
	 * _CAOtOݒ肷B<br>
	 * @param isDialog _CAOtO
	 */
	public void setIsDialog(boolean isDialog) { this.isDialog = isDialog; }
	
	/**
	 * NX擾B<br>
	 * @return NX
	 */
	public String getClassName() {
		return getClass().getName();
	}
	
	/**
	 * {@link #subTitle}擾B<br>
	 * @return Tu^Cg
	 */
	public String getSubTitle() {
		return subTitle;
	}
	
	/**
	 * j[z擾B<br>
	 * @return j[z
	 */
	public String[][] getAryMenu() {
		return getAryField(aryMenu);
	}
	
	/**
	 * G[bZ[WǉB<br>
	 * @param errorMessage G[bZ[W
	 */
	public void addErrMessage(String errorMessage) {
		this.errMessage = this.errMessage != null ? this.errMessage : new ArrayList<String>();
		this.errMessage.add(errorMessage);
	}
	
	/**
	 * G[tB[hǉB<br>
	 * @param errorFieldId G[tB[h
	 */
	public void addErrField(String errorFieldId) {
		this.errFields = this.errFields != null ? this.errFields : new ArrayList<String>();
		this.errFields.add(errorFieldId);
	}
	
	/**
	 * G[tB[h()ǉB<br>
	 * @param rowNo   sԍ
	 * @param fieldId G[tB[h
	 */
	public void addErrDetails(int rowNo, String fieldId) {
		this.errDetails = this.errDetails != null ? this.errDetails : new ArrayList<DetailsVo>();
		this.errDetails.add(new DetailsVo(rowNo, fieldId));
	}
	
	/**
	 * bZ[WB<br>
	 */
	public void clearMessage() {
		if (errMessage != null) {
			errMessage.clear();
		}
		message = "";
	}
	
	/**
	 * G[tB[hB<br>
	 */
	public void clearErrField() {
		this.errFields = this.errFields != null ? this.errFields : new ArrayList<String>();
		this.errFields.clear();
		this.errDetails = this.errDetails != null ? this.errDetails : new ArrayList<DetailsVo>();
		this.errDetails.clear();
	}
	
	/**
	 * ÓmFJnB<br>
	 */
	protected void startValidation() {
		isValid = true;
		errMessage = new ArrayList<String>();
		errFields = new ArrayList<String>();
		errDetails = new ArrayList<DetailsVo>();
	}
	
	/**
	 * ÓmFIB<br>
	 * @throws MospException
	 */
	protected void endValidation() throws MospException {
		if (!isValid) {
			errMessage.add(0, MospUtility.getMessage(msg, "WC1007", ""));
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * K{mFB<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkRequired(String value, String name, String id) throws MospException {
		if (!ValidateUtility.chkRequired(value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0001", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * K{mF()B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param rowNo sԍ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkRequired(String value, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkRequired(value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0001", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(pp)B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkCode(String value, String name, String id) throws MospException {
		if (!ValidateUtility.chkRegex("\\w*", value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0002", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(pp)()B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param rowNo sԍ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkCode(String value, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkRegex("\\w*", value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0002", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF()B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkNumber(String value, String name, String id) throws MospException {
		if (!ValidateUtility.chkRegex("\\d*", value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0003", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF()()B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param rowNo sԍ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkNumber(String value, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkRegex("\\d*", value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0003", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(C)B<br>
	 * @param value mFΏە
	 * @param regex K\
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkRegex(String value, String regex, String name, String id) throws MospException {
		if (!ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0005", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(C)()B<br>
	 * @param value mFΏە
	 * @param regex K\
	 * @param name  mFΏۖ
	 * @param rowNo sԍ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkRegex(String value, String regex, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0005", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(lFdouble)B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkNumeric(String value, String name, String id) throws MospException {
		if (!ValidateUtility.chkNumeric(value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0003", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(lFdouble)()B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param rowNo sԍ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkNumeric(String value, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkNumeric(value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0003", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * 񒷊mF(ő啶)B<br>
	 * @param value     mFΏە
	 * @param maxLength ő啶
	 * @param name      mFΏۖ
	 * @param id        mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkLength(String value, int maxLength, String name, String id) throws MospException {
		String regex = ".{0," + String.valueOf(maxLength) + "}";
		if (!ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0004", name + MospConst.DATA_SEPARATOR + String.valueOf(maxLength));
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * 񒷊mF(ő啶)()B<br>
	 * @param value     mFΏە
	 * @param maxLength ő啶
	 * @param name      mFΏۖ
	 * @param rowNo     sԍ
	 * @param id        mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkLength(String value, int maxLength, String name, int rowNo, String id) throws MospException {
		String regex = ".{0," + String.valueOf(maxLength) + "}";
		if (!ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0004", name + MospConst.DATA_SEPARATOR + String.valueOf(maxLength));
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + value + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * tÓmFB<br>
	 * @param year  N
	 * @param month (1`12)
	 * @param day   
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkDate(int year, int month, int day, String name, String id) throws MospException {
		if (!ValidateUtility.chkDate(year, month - 1, day)) {
			String errMsg = MospUtility.getMessage(msg, "WC0006", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + String.valueOf(year) + "/" + String.valueOf(month) + "/" + String.valueOf(day) + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * tÓmF()B<br>
	 * @param year  N
	 * @param month (1`12)
	 * @param day   
	 * @param name  mFΏۖ
	 * @param rowNo sԍ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkDate(int year, int month, int day, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkDate(year, month - 1, day)) {
			String errMsg = MospUtility.getMessage(msg, "WC0006", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + String.valueOf(year) + "/" + String.valueOf(month) + "/" + String.valueOf(day) + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * tԑÓmFB<br>
	 * @param date      mFΏۓ
	 * @param startDate Jn
	 * @param endDate   I
	 * @param name      mFΏۖ
	 * @param id        mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkTerm(
			Date date,
			Date startDate,
			Date endDate,
			String name,
			String id
	) throws MospException {
		if (startDate.compareTo(date) > 0 || endDate.compareTo(date) < 0) {
			String errMsg = MospUtility.getMessage(msg, "WC0006", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + name + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * tԑÓmF()B<br>
	 * @param date      mFΏۓ
	 * @param startDate Jn
	 * @param endDate   I
	 * @param name      mFΏۖ
	 * @param rowNo     sԍ
	 * @param id        mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkTerm(
			Date date,
			Date startDate,
			Date endDate,
			String name,
			int rowNo,
			String id
	) throws MospException {
		if (!ValidateUtility.chkTerm(date, startDate, endDate)) {
			String errMsg = MospUtility.getMessage(msg, "WC0006", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + name + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ԑÓmFB<br>
	 * @param hour   
	 * @param minute 
	 * @param second b
	 * @param name   mFΏۖ
	 * @param id     mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkTime(int hour, int minute, int second, String name, String id) throws MospException {
		if (!ValidateUtility.chkTime(hour, minute, second)) {
			String errMsg = MospUtility.getMessage(msg, "WC0007", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			errMsg = errMsg + "(" + String.valueOf(hour) + ":" + String.valueOf(minute) + ":" + String.valueOf(second) + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * ԑÓmF()B<br>
	 * @param hour   
	 * @param minute 
	 * @param second b
	 * @param name   mFΏۖ
	 * @param rowNo  sԍ
	 * @param id     mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkTime(int hour, int minute, int second, String name, int rowNo, String id) throws MospException {
		if (!ValidateUtility.chkTime(hour, minute, second)) {
			String errMsg = MospUtility.getMessage(msg, "WC0007", name);
			addErrMessage(errMsg);
			addErrDetails(rowNo, id);
			isValid = false;
			errMsg = errMsg + "(" + String.valueOf(hour) + ":" + String.valueOf(minute) + ":" + String.valueOf(second) + ")";
			logValid(errMsg);
		}
	}
	
	/**
	 * lrB<br>
	 * @param value1      rl1
	 * @param value2      rl2
	 * @param compareFlag mFtO(0:ltrueA1Flfalse)
	 * @param name        mFΏۖ
	 * @param id1         mFΏۃtB[hID1
	 * @param id2         mFΏۃtB[hID2
	 */
	protected void checkCompare(String value1, String value2, int compareFlag, String name, String id1, String id2) throws MospException {
		String messageCode = "";
		switch (compareFlag) {
			case 0:
				if (!value1.equals(value2)) {
					messageCode = "WC0008";
				}
				break;
			case 1:
				if (value1.equals(value2)) {
					messageCode = "WC0009";
				}
				break;
			default:
		}
		if (!messageCode.equals("")) {
			String errMsg = MospUtility.getMessage(msg, messageCode, name);
			addErrMessage(errMsg);
			addErrField(id1);
			addErrField(id2);
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * t召mFB<br>
	 * @param beforeDate  t(O)
	 * @param afterDate   t()
	 * @param isSameValid LtO(trueFLAfalseFs)
	 */
	public void checkDateBeforeAfter(
			Date     beforeDate , 
			Date     afterDate  ,
			boolean isSameValid,
			String    beforeName,
			String    afterName ,
			String    idYear    ,
			String    idMonth   ,
			String    idDay
	) throws MospException {
		if (beforeDate.compareTo(afterDate) > 0) {
			if (isSameValid) {
				if (beforeDate.compareTo(afterDate) == 0) {
					return;
				}
			}
			String errMsg = MospUtility.getMessage(msg, "WC0023", afterName + "," + beforeName);
			addErrMessage(errMsg);
			addErrField(idYear );
			addErrField(idMonth);
			addErrField(idDay  );
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF(pp)B<br>
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkPhone(String value, String name, String id) throws MospException {
		if (!ValidateUtility.chkRegex(MospConst.REG_PHONE, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0005", name);
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * ^CvmF()B<br>
	 * @param value   mFΏە
	 * @param integer 
	 * @param decimal 
	 * @param name    mFΏۖ
	 * @param id      mFΏۃtB[hID
	 * @param isDetails ׃tO
	 * @param rowNo     sԍ
	 * @throws MospException
	 */
	protected void checkDecimal(
			String  value,
			int     integer,
			int     decimal,
			String  name,
			String  id,
			boolean isDetails,
			int     rowNo
	) throws MospException {
		// K\쐬
		String regex =
			MospConst.REG_DECIMAL_PRE + String.valueOf(integer - 1) +
			MospConst.REG_DECIMAL_MID + String.valueOf(decimal    ) +
			MospConst.REG_DECIMAL_AFT
		;
		if (value != null && !value.equals("") && !ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(
					msg, "WC0011",
					name +
					MospConst.DATA_SEPARATOR + String.valueOf(integer) +
					MospConst.DATA_SEPARATOR + String.valueOf(decimal)
			);
			addErrMessage(errMsg);
			if (isDetails) {
				addErrDetails(rowNo, id);
			} else {
				addErrField(id);
			}
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * pX[hmFB<br>
	 * @param oldPassword pX[h
	 * @param currentPass ݂̃pX[h
	 * @param id         mFΏۃtB[hID
	 */
	protected void checkPassword(String oldPassword, String currentPass, String id) throws MospException {
		if (!oldPassword.equals(currentPass)) {
			String errMsg = MospUtility.getMessage(msg, "WC1004", "");
			addErrMessage(errMsg);
			addErrField(id);
			isValid = false;
			logValid(errMsg);
		}
	}
	
	/**
	 * intNGXgp[^擾B<br>
	 * @param value intNGXgp[^l
	 * @return ϊintNGXgp[^l
	 */
	public int getIntParam(String value) {
		if (value == null || value.equals("")) {
			return 0;
		}
		return Integer.parseInt(value);
	}

	/**
	 * longNGXgp[^擾B<br>
	 * @param value longNGXgp[^l
	 * @return ϊlongNGXgp[^l
	 */
	public long getLongParam(String value) {
		if (value == null || value.equals("")) {
			return 0;
		}
		return Long.parseLong(value);
	}
	
	/**
	 * floatNGXgp[^擾B<br>
	 * @param value intNGXgp[^l
	 * @return ϊintNGXgp[^l
	 */
	public float getFloatParam(String value) {
		if (value == null || value.equals("")) {
			return 0;
		}
		return Float.parseFloat(value);
	}
	
	/**
	 * doubleNGXgp[^擾B<br>
	 * @param value doubleNGXgp[^l
	 * @return ϊdoubleNGXgp[^l
	 */
	public double getDoubleParam(String value) {
		if (value == null || value.equals("")) {
			return 0;
		}
		return Double.parseDouble(value);
	}
	
	/**
	 * t擾B<br>
	 * @param time (hh:MM)
	 * @return t
	 * @throws MospException 
	 */
	public Date getTime(String time) throws MospException {
		try{
			if (time == null) {
				return null;
			}
			DateFormat df = DateFormat.getTimeInstance();
			return df.parse(time + ":00");
		} catch(ParseException e) {
			throw new MospException(MospConst.EX_DATE_INVALID);
		}
	}
	
	/**
	 * t擾B<br>
	 * @param year  N
	 * @param month 
	 * @param day   
	 * @return t
	 * @throws MospException 
	 */
	public Date getDate(String year, String month, String day) throws MospException {
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(year + "/" + month + "/" + day));
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
	
	/**
	 * ztB[h擾B<br>
	 * @param aryField Ώ۔z
	 * @return z
	 */
	protected String[] getAryField(String[] aryField) {
		return aryField == null ? null : aryField.clone();
	}
	
	/**
	 * ztB[h擾B<br>
	 * @param aryField Ώ۔z
	 * @return z
	 */
	protected String[][] getAryField(String[][] aryField) {
		return aryField == null ? null : aryField.clone();
	}
	
	/**
	 * ztB[h擾B<br>
	 * @param aryField Ώ۔z
	 * @return z
	 */
	protected Date[] getAryField(Date[] aryField) {
		return aryField == null ? null : aryField.clone();
	}
	
	/**
	 * ttB[h擾B<br>
	 * @param dateField Ώۓt
	 * @return t
	 */
	protected Date getDateField(Date dateField) {
		return dateField == null ? null : (Date)dateField.clone();
	}

	/**
	 * ttB[h擾B<br>
	 * @param dateField Ώۓt
	 * @return N
	 */
	protected String getStrYear(Date dateField) {
		return dateField == null ? "" : String.valueOf(MospUtility.getYear (dateField));
	}
	
	/**
	 * ttB[h擾B<br>
	 * @param dateField Ώۓt
	 * @return 
	 */
	protected String getStrMonth(Date dateField) {
		return dateField == null ? "" : String.valueOf(MospUtility.getMonth(dateField));
	}
	
	/**
	 * ttB[h擾B<br>
	 * @param dateField Ώۓt
	 * @return 
	 */
	protected String getStrDay(Date dateField) {
		return dateField == null ? "" : String.valueOf(MospUtility.getDay  (dateField));
	}
	
	/**
	 * `l擾B<br>
	 * @param value  Ώےl
	 * @param format tH[}bg
	 * @return l
	 */
	protected String getFormatNumber(double value, String format) {
		DecimalFormat df = new DecimalFormat(format);
		return df.format(value);
	}
	
	/**
	 * HTMLGXP[vB<br>
	 * JSPŕϐl()\ꍇɗpB<br>
	 * @param aStr GXP[vΏە
	 * @return GXP[v㕶
	 */
	public static String escapeHTML(String aStr) {
		return HtmlUtility.escapeHTML(aStr);
	}
	
	/**
	 * XMLDocumentB<br>
	 * X|XƂXMLo͂ꍇA
	 * o͓ei[{@link #docXml}̏sB<br>
	 * @throws ParserConfigurationException
	 */
	protected Element initXmlDoc() throws ParserConfigurationException {
		// Document̍쐬
		DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
		docXml = documentBuilder.newDocument();
		// MospDatavf([gvf)̐yDocumentւ̒ǉ
		Element elmMospData = createElement(MospConst.XML_ROOT_NODE);
		docXml.appendChild(elmMospData);
		// tB[hvf̍쐬
		Element elmFields = createElement(MospConst.XML_FIELD_NODE);
		// tB[hvf̐ݒ
		appendElement(elmMospData, elmFields);
		return elmFields;
	}
	
	/**
	 * Element쐬B<br>
	 * @param tagName ^O
	 */
	protected Element createElement(String tagName) {
		return docXml.createElement(tagName);
	}
	
	/**
	 * ElementǉB<br>
	 * @param parentElement ǉGg
	 * @param childElement  ǉGg
	 */
	protected void appendElement(Element parentElement, Element childElement) {
		parentElement.appendChild(childElement);
	}
	
	/**
	 * TextElementǉB<br>
	 * @param parentElement ǉGg
	 * @param tagName       ǉ^O
	 * @param data          ǉf[^
	 */
	protected void appendTextElement(Element parentElement, String tagName, String data) {
		Element childElement = createElement(tagName);
		Text    textNode     = docXml.createTextNode(data);
		childElement.appendChild(textNode);
		appendElement(parentElement, childElement);
	}
	
	/**
	 * XML擾B<br>
	 * {@link #docXml}𕶎ɕϊB<br>
	 * @throws TransformerException
	 */
	public String getStrDocXml() throws TransformerException {
		// [gvf̎擾
		Element elmMospData = docXml.getDocumentElement();
		// XmlRetCodevf̐yђǉ
		Element elmXmlRetCode = docXml.createElement(MospConst.XML_RETCODE_NODE);
		Text txnXmlRetCode = docXml.createTextNode(escapeHTML(getXmlRetCode()));
		elmXmlRetCode.appendChild(txnXmlRetCode);
		elmMospData.appendChild(elmXmlRetCode);
		// ErrorMessagevf̐yђǉ
		if (errMessage != null) {
			for (int i = 0; i < errMessage.size(); i++) {
				Element elmErrorMessage = docXml.createElement(MospConst.XML_ERR_MSG_NODE);
				Text txnErrMessage = docXml.createTextNode(escapeHTML(String.valueOf(errMessage.get(i))));
				elmErrorMessage.appendChild(txnErrMessage);
				elmMospData.appendChild(elmErrorMessage);
			}
		}
		// ErrorFieldsvf̐yђǉ
		if (errFields != null) {
			for (int i = 0; i < errFields.size(); i++) {
				Element elmErrorFields = docXml.createElement(MospConst.XML_ERR_FIELD_NODE);
				Text txnErrFields = docXml.createTextNode(escapeHTML(String.valueOf(errFields.get(i))));
				elmErrorFields.appendChild(txnErrFields);
				elmMospData.appendChild(elmErrorFields);
			}
		}
		// ErrorDetailsvf̐yђǉ
		if (errDetails != null) {
			for (int i = 0; i < errDetails.size(); i++) {
				DetailsVo vo = errDetails.get(i);
				Element elmErrorFields = docXml.createElement(MospConst.XML_ERR_DETAIL_NODE);
				elmErrorFields.setAttribute(MospConst.XML_ATT_ROW_NO, String.valueOf(vo.rowNo));
				Text txnErrFields = docXml.createTextNode(escapeHTML(String.valueOf(vo.fieldId)));
				elmErrorFields.appendChild(txnErrFields);
				elmMospData.appendChild(elmErrorFields);
			}
		}
		// Messagevf̐yђǉ
		Element elmMessage = docXml.createElement(MospConst.XML_MESSAGE_NODE);
		Text txnMessage = docXml.createTextNode(escapeHTML(message));
		elmMessage.appendChild(txnMessage);
		elmMospData.appendChild(elmMessage);
		// ProcSeqvf̐yђǉ
		Element elmProcSeq = docXml.createElement(MospConst.XML_PROC_SEQ);
		Text txnProcSeq = docXml.createTextNode(getEscProcSeq());
		elmProcSeq.appendChild(txnProcSeq);
		elmMospData.appendChild(elmProcSeq);
		// XML𕶎ɕϊ
		TransformerFactory transformerFactory = TransformerFactory.newInstance(); 
		Transformer transformer = transformerFactory.newTransformer(); 
		StringWriter sw = new StringWriter();
		transformer.setOutputProperty(OutputKeys.ENCODING, MospConst.XML_CHAR_ENC);
		transformer.transform(new DOMSource(docXml), new StreamResult(sw));
		return sw.toString();
	}
	
	/**
	 * ÓmFOóB<br>
	 * @param errMsg
	 */
	private void logValid(String errMsg) {
		LogUtility.log(cfg, aspUserId, userId, cmd, 4, MospConst.LOG_VALID, errMsg);
	}
	
	/**
	 * javascript擾B<br>
	 * NX̃tB[h̓ApublicŕϐuPRM_vuNAM_vA
	 * uREG_vAuLEN_v̂̂ɂAϐœl錾
	 * javascript񓙂o͂B<br>
	 * @param cls NX
	 * @param obj IuWFNg
	 * @return javascript
	 * @throws IllegalAccessException
	 */
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		if (needDirectJs) {
			sb.append(getJsFieldsInfo(cls, obj));
			sb.append(getJsErrFieldsId());
		}
		return sb.toString();
	}

	/**
	 * javascript擾B<br>
	 * NX̃tB[h̓Apublic staticŕϐuPRM_vuNAM_vA
	 * uREG_vAuLEN_v̂̂ɂAϐœl錾
	 * javascript񓙂o͂B<br>
	 * @param cls NX
	 * @return javascript
	 * @throws IllegalAccessException
	 */
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		if (needDirectJs) {
			sb.append(getJsFieldsInfo(cls, null));
			sb.append(getJsErrFieldsId());
		}
		return sb.toString();
	}
	
	/**
	 * JavaScript(IDAږAڒ)擾B<br>
	 * @param cls dtoNX
	 * @return JavaScript(IDAږAڒ)
	 * @throws IllegalAccessException
	 */
	private String getJsFieldsInfo(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		Field[] fields = cls.getFields();
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("PRM_") == 0 || name.indexOf("NAM_") == 0 || name.indexOf("REG_") == 0) {
				sb.append("var " + name + " = \"");
				sb.append(field.get(obj));
				sb.append("\";");
			} else if (name.indexOf("LEN_") == 0) {
				sb.append("var " + name + " = ");
				sb.append(field.get(obj));
				sb.append(";");
			}
		}
		sb.append("var ARY_FIELDS_ID = new Array(");
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String name = field.getName();
			if (name.indexOf("PRM_") == 0) {
				sb.append(name + ", ");
			}
		}
		if (sb.charAt(sb.length() - 2) == ',' && sb.charAt(sb.length() - 1) == ' ') {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		return sb.toString();
	}
	
	/**
	 * JavaScript(G[)擾B<br>
	 * @return JavaScript(G[)
	 */
	private String getJsErrFieldsId() {
		StringBuffer sb = new StringBuffer();
		sb.append("var ARY_ERR_FIELDS_ID = new Array(");
		if (errFields != null) {
			for (int i = 0; i < errFields.size(); i++) {
				sb.append("\"" + errFields.get(i) + "\", ");
			}
			if (errFields.size() > 0) {
				sb.delete(sb.length() - 2, sb.length());
			}
		}
		sb.append(");");
		sb.append("var ARY_ERR_DETAILS = new Array(");
		if (errDetails != null) {
			for (int i = 0; i < errDetails.size(); i++) {
				DetailsVo vo = errDetails.get(i);
				sb.append("new Array(\"" + vo.fieldId + "\", \"" +  vo.rowNo + "\"), ");
			}
			if (errDetails.size() > 0) {
				sb.delete(sb.length() - 2, sb.length());
			}
		}
		sb.append(");");
		return sb.toString();
	}
	
	/**
	 * ׏i[B<br><br>
	 */
	private static class DetailsVo implements Serializable {
		private static final long serialVersionUID = 8052715720150027371L;
		protected int rowNo;
		protected String fieldId;
		protected DetailsVo(int rowNo, String fieldId) {
			this.rowNo = rowNo;
			this.fieldId = fieldId;
		}
	}
	
	/**
	 * St@C̃pX擾B<br><br>
	 * {@link #cfg}ɃSt@CpXݒ̏ꍇA
	 * ͋󔒂̏ꍇ́ANULLԂB
	 * @return St@CpX
	 */
	public String getLogoPath() {
		String pass = cfg.getProperty(MospConst.PPT_APP_LOGO);
		if (pass == null || pass.equals("")) {
			return null;
		}
		return pass;
	}
	
	/**
	 * 擾B<br>
	 * {@link #nam}當擾B
	 * @param key ݒL[
	 * @return 
	 */
	public String getName(String key) {
		if (nam == null) {
			return "";
		}
		return nam.getProperty(key, "");
	}
	
	/**
	 * MosPt[[N\pt@CpXݒ
	 * @param className		ΏVONX
	 * <p>{@link BaseVo}pĂΏVO̕\pt@CpXݒ肷郁\bhB</p>
	 * <p>{@link BaseVo#BaseVo()}ĂяoA{@link BaseVo#getClassName()}p[^ɃZbg邱ƂŁA<br>
	 * ΏVOɒjspAcssAjs̃t@CpXn[hR[hȂĂĂяoƂłB<br>
	 * ̑At@C̏ꏊ͕KKʂ̏ꏊɂȂ΂ȂȂB<br>
	 * Ã\bh𗘗pA]̕@𗘗p邱Ƃ\łB
	 * </p>
	 * <p>
	 * t@C̏ꏊ̋K{@link ViewFileLocationUtility#ViewFileLocationUtility(String)}QƂ邱ƁB
	 * </p>
	 */
	protected void setViewPath(String className) {
		ViewFileLocationUtility location = new ViewFileLocationUtility(className);
		setRetUrl(location.getRetUrl());
		addExtraCss(location.getExtraCss());
		addExtraJs(location.getExtraJs());
	}

}
