/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.bean;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.CmUserDao;
import jp.mosp.common.dao.CtAccountDao;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.dto.CtAccountDto;

public class AuthBean {
    private Map<String, Object> authMap = new HashMap<String, Object>();
    private Properties cfg;
    private String cmd;
    private CmAspUserDto aspUser;
    private Connection conn;
    private boolean hasMospSeJar = false;
    private CmUserDto user;
    private CtAccountDto dto;
    public static final String KEY_MESSAGE_CODE = "msgCode";
    public static final String KEY_EXCEPTION_CODE = "exCode";
    public static final String KEY_USER = "user";

    public AuthBean() {
    }

    public AuthBean(Properties cfg, String cmd, CmAspUserDto aspUser, Connection conn, boolean hasMospSeJar) {
        this.init(cfg, cmd, aspUser, conn, hasMospSeJar);
    }

    public AuthBean(String userId, String password, Properties cfg, String cmd, CmAspUserDto aspUser, Connection conn, boolean hasMospSeJar) throws Exception {
        this.init(cfg, cmd, aspUser, conn, hasMospSeJar);
        this.login(userId, password);
    }

    public void init(Properties cfg, String cmd, CmAspUserDto aspUser, Connection conn, boolean hasMospSeJar) {
        this.cfg = cfg;
        this.cmd = cmd;
        this.aspUser = aspUser;
        this.conn = conn;
        this.hasMospSeJar = hasMospSeJar;
    }

    public void login(String userId, String password) throws Exception {
        CmUserDao userDao = new CmUserDao();
        userDao.initDao(this.cfg, this.cmd, this.aspUser, this.user, this.conn);
        this.user = userDao.findForKey(userId);
        if (this.user != null) {
            if (this.user.getDeleteFlag() == 1) {
                this.setAuthFailedMessage("WC1002", 1004);
            }
            CtAccountDao dao = new CtAccountDao(this.cfg, this.cmd, this.aspUser, this.user, this.conn);
            this.dto = dao.findCtAccountForUserId(this.user.getUserId());
            if (this.dto == null) {
                this.dto = new CtAccountDto();
                this.dto.setUserId(this.user.getUserId());
                this.dto.setAttempt(1);
                dao.insert(this.dto);
            } else {
                Date date;
                int maxAttempt = Integer.parseInt(this.cfg.getProperty("acc.attempt"));
                if (this.dto.getAttempt() >= maxAttempt && (date = new Date(this.dto.getUpdateDate().getTime() + Long.parseLong(this.cfg.getProperty("acc.interval")) * 1000L)).compareTo(new Date()) > 0) {
                    this.dto.incrementAttempt();
                    dao.update(this.dto);
                    this.setAuthFailedMessage("WC1003", 1003);
                }
            }
            this.checkPassWord(password);
        } else {
            this.setAuthFailedMessage("WC1002", 1005);
        }
        this.authMap.put(KEY_USER, this.user);
    }

    private void checkPassWord(String password) throws Exception {
        CtAccountDao ctAccountDao = new CtAccountDao(this.cfg, this.cmd, this.aspUser, this.user, this.conn);
        boolean passwordFailed = true;
        if (this.user.getPassword().equals(MospUtility.encrypt(password, this.hasMospSeJar))) {
            this.user.setPassword("");
            this.dto.setAttempt(0);
            ctAccountDao.update(this.dto);
            this.user.setCommonCss("");
            this.user.setMospAuthority(this.user.getAuthority());
            this.user.setPayrollAuthority("");
            this.user.setZaimuAuthority("");
            this.user.setSalesAuthority("");
            this.user.setExpenseAuthority("");
            this.user.setExt1Authority("");
            this.user.setExt2Authority("");
            this.user.setExt3Authority("");
            this.user.setExt4Authority("");
            this.user.setExt5Authority("");
            passwordFailed = false;
        } else {
            this.dto.incrementAttempt();
            ctAccountDao.update(this.dto);
        }
        if (passwordFailed) {
            this.setAuthFailedMessage("WC1002", 1002);
        }
    }

    public void setAuthFailedMessage(String msgCode, int exCode) {
        this.authMap.put(KEY_MESSAGE_CODE, msgCode);
        this.authMap.put(KEY_EXCEPTION_CODE, new Integer(exCode));
    }

    public boolean isErrMessage() {
        return this.authMap.get(KEY_MESSAGE_CODE) != null;
    }

    public CmUserDto getCmUserDto() {
        Object obj = this.authMap.get(KEY_USER);
        return obj != null ? (CmUserDto)obj : null;
    }

    public String getErrMessageCode() {
        Object obj = this.authMap.get(KEY_MESSAGE_CODE);
        return obj != null ? obj.toString() : "";
    }

    public int getMosPExceptionCode() {
        Object obj = this.authMap.get(KEY_EXCEPTION_CODE);
        return obj != null ? (Integer)obj : 0;
    }
}

