/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import monalipse.server.AbstractBBSServer;
import monalipse.server.IBoardListContentProvider;
import monalipse.server.IThreadContentProvider;
import monalipse.server.IThreadListContentProvider;
import monalipse.server.giko.Board;
import monalipse.server.giko.BoardListContentProvider;
import monalipse.server.giko.ThreadContentProvider;
import monalipse.server.giko.ThreadListContentProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;

public class GikoServer
extends AbstractBBSServer {
    private static WebConversation wc;
    private IWorkbenchWindow workbenchWindow;
    private BoardListContentProvider boardListContentProvider;
    private ThreadListContentProvider threadListContentProvider;
    static /* synthetic */ Class class$0;

    static {
        HttpUnitOptions.setDefaultCharacterSet("Windows-31J");
        HttpUnitOptions.setAutoRedirect(false);
        HttpUnitOptions.setLoggingHttpHeaders(true);
        wc = new WebConversation();
    }

    public IBoardListContentProvider getBoardListContentProvider() {
        return this.boardListContentProvider;
    }

    public void initialize(IWorkbenchWindow workbenchWindow, IProject project) {
        super.initialize(workbenchWindow, project);
        this.workbenchWindow = workbenchWindow;
        this.boardListContentProvider = new BoardListContentProvider(this.getWorkbenchWindow());
        this.threadListContentProvider = new ThreadListContentProvider(this.getWorkbenchWindow());
    }

    public String getTargetName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.server.giko.GikoServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public IFolder getLogFolderOf(Object board) {
        if (board instanceof Board) {
            return ((Board)board).getLogFolder();
        }
        return null;
    }

    public IThreadListContentProvider getThreadListContentProvider() {
        return this.threadListContentProvider;
    }

    public boolean isSupported(URL url) {
        if (url.getProtocol().equals("http")) {
            String[] domains = BoardListContentProvider.BBS_DOMAINS;
            int i = 0;
            while (i < domains.length) {
                if (url.getHost().endsWith(domains[i])) {
                    return url.getFile().startsWith("/test/read.cgi");
                }
                ++i;
            }
        }
        return false;
    }

    public IThreadContentProvider getThreadContentProviderOf(String baseURL, IFolder logFolder, String id, String name) {
        return new ThreadContentProvider(this.workbenchWindow, baseURL, logFolder, id, 0, name, 0);
    }

    public IThreadContentProvider getThreadContentProviderOf(IProject project, URL url) {
        int s;
        String readCgi = "/test/read.cgi";
        String dir = url.getFile();
        if (dir.startsWith(readCgi) && (s = (dir = dir.substring(readCgi.length(), dir.length())).indexOf(47, 1)) != -1) {
            String baseURL = "http://" + url.getHost() + dir.substring(0, s + 1);
            IFolder logFolder = BoardListContentProvider.getLogFolderOf(project, baseURL);
            if (logFolder == null) {
                return null;
            }
            int t = dir.indexOf(47, s + 1);
            if (t == -1) {
                t = dir.length();
            }
            String id = String.valueOf(dir.substring(s + 1, t)) + ".dat";
            return this.getThreadContentProviderOf(baseURL, logFolder, id, "?");
        }
        return null;
    }

    public static WebConversation getWebConversation() {
        return wc;
    }

    public static void asyncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run) {
        workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    workbenchWindow.run(false, false, run);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void syncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run) {
        workbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    workbenchWindow.run(false, false, run);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

