/*
 * Decompiled with CFR 0.152.
 */
package monalipse.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

class StatusLineProgressMonitorPart
extends ProgressMonitorPart {
    private SubStatusLineManager manager;
    private Display display;
    private IAction cancelAction;
    private ThreadGroup threads = new ThreadGroup(((Object)((Object)this)).getClass().getName());
    private int runCount;

    public StatusLineProgressMonitorPart(Composite parent, SubStatusLineManager manager, IAction cancelAction) {
        super(parent, StatusLineProgressMonitorPart.getFillGrid());
        this.manager = manager;
        this.cancelAction = cancelAction;
        this.display = parent.getShell().getDisplay();
    }

    public void dispose() {
        super.dispose();
    }

    private static Layout getFillGrid() {
        GridLayout grid = new GridLayout(2, false);
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        grid.horizontalSpacing = 0;
        grid.verticalSpacing = 0;
        return grid;
    }

    public SubStatusLineManager getStatusLineManager() {
        return this.manager;
    }

    protected void initialize(Layout layout, int progressIndicatorHeight) {
        super.initialize(layout, progressIndicatorHeight);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.fProgressIndicator.setLayoutData((Object)gd);
    }

    public Thread run(final Object serializeKey, final IRunnableWithProgress run) {
        this.setCancelEnabled(true);
        return this.run(new Runnable(){

            public void run() {
                if (serializeKey == null) {
                    this.runInternal();
                } else {
                    Object object = serializeKey;
                    synchronized (object) {
                        this.runInternal();
                    }
                }
            }

            public void runInternal() {
                StatusLineProgressMonitorPart statusLineProgressMonitorPart = StatusLineProgressMonitorPart.this;
                statusLineProgressMonitorPart.runCount = statusLineProgressMonitorPart.runCount + 1;
                try {
                    try {
                        run.run((IProgressMonitor)StatusLineProgressMonitorPart.this);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    StatusLineProgressMonitorPart statusLineProgressMonitorPart2 = StatusLineProgressMonitorPart.this;
                    statusLineProgressMonitorPart2.runCount = statusLineProgressMonitorPart2.runCount - 1;
                    StatusLineProgressMonitorPart.this.setCancelEnabled(StatusLineProgressMonitorPart.this.runCount != 0);
                    throw throwable;
                }
                Object var2_5 = null;
                StatusLineProgressMonitorPart statusLineProgressMonitorPart3 = StatusLineProgressMonitorPart.this;
                statusLineProgressMonitorPart3.runCount = statusLineProgressMonitorPart3.runCount - 1;
                StatusLineProgressMonitorPart.this.setCancelEnabled(StatusLineProgressMonitorPart.this.runCount != 0);
            }
        });
    }

    private Thread run(Runnable run) {
        Thread thread = new Thread(this.threads, run, ((Object)((Object)this)).getClass().getName());
        thread.start();
        return thread;
    }

    private void setCancelEnabled(final boolean enabled) {
        this.display.syncExec(new Runnable(){

            public void run() {
                if (enabled) {
                    StatusLineProgressMonitorPart.this.cancelAction.setEnabled(true);
                    StatusLineProgressMonitorPart.this.manager.setVisible(true);
                } else {
                    StatusLineProgressMonitorPart.this.manager.setVisible(false);
                    StatusLineProgressMonitorPart.this.cancelAction.setEnabled(false);
                }
                StatusLineProgressMonitorPart.this.manager.update(true);
            }
        });
    }

    public void interruptAll() {
        ThreadGroup threadGroup = this.threads;
        synchronized (threadGroup) {
            this.threads.interrupt();
        }
    }

    public void setTaskName(final String name) {
        this.display.syncExec(new Runnable(){

            public void run() {
                if (!StatusLineProgressMonitorPart.this.isDisposed()) {
                    StatusLineProgressMonitorPart.this.manager.setMessage(name);
                }
            }
        });
    }

    public void beginTask(final String name, final int totalWork) {
        this.display.syncExec(new Runnable(){

            public void run() {
                if (!StatusLineProgressMonitorPart.this.isDisposed()) {
                    StatusLineProgressMonitorPart.this.manager.setMessage(name);
                    StatusLineProgressMonitorPart.super.beginTask("", totalWork);
                }
            }
        });
    }

    public void worked(final int work) {
        this.display.syncExec(new Runnable(){

            public void run() {
                if (!StatusLineProgressMonitorPart.this.isDisposed()) {
                    StatusLineProgressMonitorPart.super.worked(work);
                }
            }
        });
    }

    public void done() {
        this.display.syncExec(new Runnable(){

            public void run() {
                if (!StatusLineProgressMonitorPart.this.isDisposed()) {
                    StatusLineProgressMonitorPart.super.done();
                }
            }
        });
    }
}

