/*
 * Decompiled with CFR 0.152.
 */
package monalipse.editors;

import java.net.MalformedURLException;
import java.net.URL;
import monalipse.editors.IThreadViewerEditor;
import monalipse.editors.ThreadEditorInput;
import monalipse.part.CancelableRunner;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorActionBarContributor;

public class ThreadViewerEditorActionBarContributor
extends EditorActionBarContributor {
    private CancelableRunner cancelable;
    private SubStatusLineManager statusLineManager;
    private IAction browserAction;
    private IAction reloadAction;
    private IAction abortAction;
    private IContributionItem urlContribution;

    public ThreadViewerEditorActionBarContributor() {
        this.makeActions();
    }

    public void contributeToContextMenu(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add(this.browserAction);
    }

    public void contributeToStatusLine(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, null, this.abortAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add(this.browserAction);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.browserAction = new Action(){

            public void run() {
                IEditorInput input = ThreadViewerEditorActionBarContributor.this.getPage().getActiveEditor().getEditorInput();
                if (input instanceof ThreadEditorInput) {
                    Program.launch((String)((ThreadEditorInput)input).getURLHint());
                }
            }
        };
        this.browserAction.setText("Open By Web Browser");
        this.browserAction.setToolTipText("Open By Web Browser");
        try {
            this.browserAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "webbrowser_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.reloadAction = new Action(){

            public void run() {
                IEditorPart part = ThreadViewerEditorActionBarContributor.this.getPage().getActiveEditor();
                part.getEditorInput();
                if (part instanceof IThreadViewerEditor) {
                    ((IThreadViewerEditor)part).updateThread();
                }
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload thread");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(){

            public void run() {
                ThreadViewerEditorActionBarContributor.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort all downloading thread");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public CancelableRunner getCancelable() {
        return this.cancelable;
    }
}

