﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MikuMikuDance.Core.Stages;
using NiVE2.Plugin.Interface;
using NiVE2.Plugin.Property;
using SlimDX;
using MikuMikuDance.SlimDX;

namespace MikuMikuDance.NiVE2
{
    class MMDNiVELight : MMDXDefaultLight
    {
        public void Update(double time, IComposition composition)
        {
            foreach (var it in composition.GetLayer())
            {
                if (it.SpecialItemType == global::NiVE2.Plugin.Utils.SpecialItemType.Light)
                {
                    var prop = it.GetLayerProperty(time);
                    var propl = it.GetLightProperty(time);
                    ColorProperty color = (ColorProperty)propl["カラー"];
                    VertexProperty position = (VertexProperty)prop["位置"];
                    VertexProperty target = (VertexProperty)prop["目標点"];
                    Vector3 p = new Vector3((float)position.X, (float)position.Y, (float)position.Z);
                    Vector3 t = new Vector3((float)target.X, (float)target.Y, (float)target.Z);
                    Vector3 cv;
                    Vector3.Subtract(ref t, ref p, out cv);
                    SlimMMDXCore.Instance.Light.LightDirection = cv;
                    SlimMMDXCore.Instance.Light.LightColor = new Vector3((float)color.Color.R / 255.0f, (float)color.Color.G / 255.0f, (float)color.Color.B / 255.0f);
                    break;
                }
            }
        }
    }
}
