﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// カメラインターフェイス
    /// </summary>
    public interface IMMDCamera
    {
        /// <summary>
        /// カメラのポジション
        /// </summary>
        Vector3 CameraPos { get; set; }
        /// <summary>
        /// カメラの視点
        /// </summary>
        Vector3 CameraTarget { get; set; }
        /// <summary>
        /// カメラの上方向を表すベクトル
        /// </summary>
        Vector3 CameraUpVector { get; set; }
        /// <summary>
        /// カメラに適応するワールド座標系
        /// </summary>
        Matrix CameraMatrix { get; set; }
        /// <summary>
        /// 視野角
        /// </summary>
        float FieldOfView { get; set; }
        /// <summary>
        /// Nearプレーン距離
        /// </summary>
        float Near { get; set; }
        /// <summary>
        /// Farプレーン距離
        /// </summary>
        float Far { get; set; }
        /// <summary>
        /// アニメーションプレイヤー
        /// </summary>
        CameraAnimationPlayer Player { get; }
        /// <summary>
        /// ビューマトリックス取得
        /// </summary>
        /// <returns>ビューマトリックス</returns>
        Matrix GetViewMatrix();
        /// <summary>
        /// プロジェクションマトリックス取得
        /// </summary>
        /// <param name="graphics">グラフィックデバイスオブジェクト</param>
        /// <returns>プロジェクションマトリックス</returns>
        Matrix GetProjectionMatrix(GraphicsDevice graphics);
        /// <summary>
        /// 視錐台のコーナー情報取得
        /// </summary>
        /// <param name="graphics">グラフィックスデバイス</param>
        /// <param name="shadowDist">シャドウ距離</param>
        /// <param name="frustumCorners">視錐台のコーナー</param>
        void GetFrustumCorners(GraphicsDevice graphics, float shadowDist, Vector3[] frustumCorners);
    }
}
