﻿using System;

namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// 表情用の頂点データ(内部用)
    /// </summary>
    public struct MMDSkinVertData
    {
        /// <summary>
        /// 対象頂点番号
        /// </summary>
        public UInt32 VertIndex;//インポータ内ではbase内の配列番号になってる。Processorで修正
        /// <summary>
        /// 表情用の頂点座標(base), 表情用の頂点オフセット(それ以外)
        /// </summary>
        public float[] Pos;
    }
    /// <summary>
    /// 表情データ
    /// </summary>
    public struct MMDSkinData
    {
        /// <summary>
        /// 表情名
        /// </summary>
        public string Name;
        /// <summary>
        /// 表情種別
        /// </summary>
        public MMDSkinType SkinType;
        /// <summary>
        /// 表情で使用する頂点リスト
        /// </summary>
        public MMDSkinVertData[] SkinVerts;
    }
}
