using System.ComponentModel;
using System.IO;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;


namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// /// RegEpCvC̒ԃf[^łNodeContent
    /// Aj[Vf[^܂ModelContent֕ϊvZbT(Reachp)
    /// </summary>
    [ContentProcessor]
    internal class SkinnedModelProcessorReach : ModelProcessor
    {
        
        /// <summary>
        /// RegEpCvC̒ԃf[^łNodeContent
        /// Aj[Vf[^܂ModelContent֕ϊProcess\bhB
        /// CMMDProcessorɔCāAł̓GtFNg̃vZXs
        /// </summary>
        public override ModelContent Process(NodeContent input, ContentProcessorContext context)
        {
            // x[XNXProcess\bhĂяoăff[^ϊ
            return base.Process(input, context);
        }

        /// <summary>
        /// SẴ}eAXLfp̃GtFNgg悤ɕύX
        /// </summary>
        protected override MaterialContent ConvertMaterial(MaterialContent material,
                                                        ContentProcessorContext context)
        {
            BasicMaterialContent basicMaterial = material as BasicMaterialContent;
            EffectMaterialContent effectMaterial;
            // XLbVGtFNgQƂ
            
            ExternalReference<EffectContent> effect;
            //\[Xt@C쐬ēǂݍނƂZRC@cc
            if (!Directory.Exists("ext"))
                Directory.CreateDirectory("ext");
            FileStream fs = new FileStream(Path.Combine("ext", "MMDModelReach.fx"), FileMode.Create);
            BinaryWriter bw = new BinaryWriter(fs);
            bw.Write(Resource1.MMDModelReach);
            bw.Close();
            effect = new ExternalReference<EffectContent>(Path.Combine("ext", "MMDModelReach.fx"));
            
            if (basicMaterial == null)
            {
                effectMaterial = material as EffectMaterialContent;
                if (effectMaterial == null)
                    throw new InvalidContentException(string.Format(
                    "MMDProcessorEffectMaterialContent݂̂T|[g܂" +
                    "̓bV{0}gpĂ܂B", material.GetType()));
                // XLbVGtFNg𖄂ߍ
                effectMaterial.Effect = effect;
                //@ModelProcessorConvertMaterialĂ
                return base.ConvertMaterial(effectMaterial, context);
            }
            else
            {
                
                effectMaterial = new EffectMaterialContent();

                // XLbVGtFNg𖄂ߍ
                effectMaterial.Effect = effect;
                //f[^̃Rs[
                foreach (var i in basicMaterial.OpaqueData)
                {
                    effectMaterial.OpaqueData.Add(i.Key, i.Value);
                }
                
                effectMaterial.Name = basicMaterial.Name;
                effectMaterial.Identity = basicMaterial.Identity;
                // BasicMaterialContent̃eNX`V}eAɐݒ肷
                foreach (var i in basicMaterial.Textures)
                {
                    effectMaterial.Textures.Add(i.Key, i.Value);
                }
                //@ModelProcessorConvertMaterialĂ
                return base.ConvertMaterial(effectMaterial, context);
            }
        }
        protected override void ProcessGeometryUsingMaterial(MaterialContent material, System.Collections.Generic.IEnumerable<GeometryContent> geometryCollection, ContentProcessorContext context)
        {
            //ǂ̃GtFNgĝ̎ʔ
            foreach (var i in geometryCollection)
            {
                bool Color = false;
                bool UseTexture = false;
                bool Normal = false;
                foreach (var channel in i.Vertices.Channels)
                {
                    if (channel.Name == VertexChannelNames.TextureCoordinate(0)
                        && i.Material.Textures.Count > 0)
                    {
                        UseTexture = true;
                    }
                    else if (channel.Name == VertexChannelNames.Color(0))
                        Color = true;
                    else if (channel.Name == VertexChannelNames.Normal(0))
                    {
                        Normal = true;
                        
                    }
                }
                //VF[_ԍ̔
                int ShaderIndex = 0;
                if (Color)
                    ShaderIndex += 1;
                if (UseTexture)
                    ShaderIndex += 2;
                if (Normal)
                    ShaderIndex += 4;
                i.Material.OpaqueData.Add("ShaderIndex", ShaderIndex);
            }
            base.ProcessGeometryUsingMaterial(material, geometryCollection, context);
        }
    }
}