using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;

using TInput = Microsoft.Xna.Framework.Content.Pipeline.Graphics.NodeContent;
using TOutput = MikuMikuDance.XNA.Model.MMDModelContent;
using MikuMikuDance.XNA.Model.ModelData;
using MikuMikuDance.XNA.Model;
using System.ComponentModel;
using MikuMikuDance.XNA.Motion.MotionData;
using System.Diagnostics;

namespace MikuMikuDance.XNA.ModelReach
{

    /// <summary>
    /// MikuMikuDancẽff[^XNAɃC|[g邽߂̃vZbT(Reachp)
    /// </summary>
    [ContentProcessor(DisplayName = "MikuMikuDancef(Reach) : MikuMikuDance for XNA")]
    public class MMDReachProcessor : ContentProcessor<TInput, TOutput>
    {
        const int MaxBones = 100;
        
        
        bool generateMipmaps = true;
        /// <summary>
        /// ~bv}bv̐
        /// </summary>
        [DefaultValue(true)]
        [DisplayName("~bv}bv̐")]
        [Description("LȏꍇAf̃eNX`[ɑ΂ĊSȃ~bv}bv `F[܂B̃~bv}bv͒u܂B")]
        public virtual bool GenerateMipmaps { get { return generateMipmaps; } set { generateMipmaps = value; } }

        bool resizeTexturesToPowerOfTwo = true;
        /// <summary>
        /// eNX`TCY2̗ݏɃTCY
        /// </summary>
        [DefaultValue(true)]
        [DisplayName("eNX`[ TCY2̗ݏɃTCY")]
        [Description("LȏꍇAf̃eNX`[͎ɑ傫2̗ݏ̃TCYɕύXA\Ȍ̌݊ۂ܂B̃OtBbN J[h́ATCY2̗ݏłȂeNX`[ɑΉĂ܂B")]
        public virtual bool ResizeTexturesToPowerOfTwo { get { return resizeTexturesToPowerOfTwo; } set { resizeTexturesToPowerOfTwo = value; } }

        TextureProcessorOutputFormat textureFormat = TextureProcessorOutputFormat.DxtCompressed;
        /// <summary>
        /// eNX`[tH[}bg
        /// </summary>
        [DefaultValue(TextureProcessorOutputFormat.DxtCompressed)]
        [DisplayName("eNX`[ tH[}bg")]
        [Description("eNX`[ SurfaceFormat ^w肵܂BeNX`[̃tH[}bǵAϊAColor (32 rbg RGBA)A܂DXTk`ɕϊ܂B")]
        public virtual TextureProcessorOutputFormat TextureFormat { get { return textureFormat; } set { textureFormat = value; } }

        bool m_UsePartCenterZSort = false;
        /// <summary>
        /// p[cS𗘗pfZ\[g@
        /// </summary>
        [DefaultValue(false)]
        [DisplayName("p[cSZ\[g@")]
        [Description("LȏꍇAf̊eގ͊eގ̒SʒuƂZ\[g@ŕ`悳܂BގeNX`f肭\ȂƂtrueɂƉ邩܂")]
        public bool UsePartCenterZSort { get { return m_UsePartCenterZSort; } set { m_UsePartCenterZSort = value; } }

        bool m_UseMaterialPalette = true;
        /// <summary>
        /// }eApbggptO
        /// </summary>
        [DefaultValue(true)]
        [DisplayName("}eApbg̎gp")]
        [Description("LȏꍇAf̊eގ͐AGPUߔs}邱Ƃł܂BAAȍގꍇ͏肭\Ȃ\܂")]
        public bool UseMaterialPalette { get { return m_UseMaterialPalette; } set { m_UseMaterialPalette = value; } }
        /// <summary>
        /// Recϊ
        /// </summary>
        /// <param name="input">NodeContentNX</param>
        /// <param name="context">RegvZbT</param>
        /// <returns>MMDf for XNARec</returns>
        public override TOutput Process(TInput input, ContentProcessorContext context)
        {
            //ԋp
            TOutput result = new MMDModelContent();
            //MMDfp̃^OT
            MMDModelIntermediateTag tag = null;
            foreach (var i in input.OpaqueData)
            {
                if (i.Key == "mmdtag")
                {
                    //̂MMDfp̃^Oɕϊ݂
                    tag = i.Value as MMDModelIntermediateTag;
                    break;
                }
            }
            //^O̓f珜Ă
            if (tag != null)
                input.OpaqueData.Remove("mmdtag");
            
            //Ô߃XLAj[VɌ̂ǂ`FbN
            ValidateMesh(input, context, null);
            //XPgT
            BoneContent skeleton = MeshHelper.FindSkeleton(input);
            if (skeleton == null)
                throw new InvalidContentException("XPg܂");
            // f̃bVꂼႤ[JWĂƈ
            // ʓ|Ȃ̂ŁASĂႤ(bV̕ϊW炩ߒ_
            // f[^ɓKp邱)
            FlattenTransforms(input, skeleton);

            // oChE|[YƃXPg\ǂݍ
            IList<BoneContent> bones = MeshHelper.FlattenSkeleton(skeleton);

            if (bones.Count > MaxBones)
            {
                throw new InvalidContentException(string.Format(
                    "̃XPgɂ{0}̃{[܂Bő{[{1}łB",
                    bones.Count, MaxBones));
            }

            //bVAj[V擾
            result.Motions = ProcessAnimations(skeleton.Animations, bones);

            //{[
            MMDBoneData[] BoneDataProcessed = new MMDBoneData[bones.Count];
            Dictionary<string, int> NamePosDictionary = new Dictionary<string, int>();
            int Pos = 0;
            foreach (BoneContent bone in bones)
            {
                //XLAj[Vpf[^擾
                MMDBoneData mmdbone = new MMDBoneData();
                mmdbone.BindPose = QuatTransform.FromMatrix(bone.Transform);
                mmdbone.InverseBindPose = QuatTransform.FromMatrix(Matrix.Invert(bone.AbsoluteTransform));
                mmdbone.SkeletonHierarchy = bones.IndexOf(bone.Parent as BoneContent);//eo^(ꍇ-1)
                if (!NamePosDictionary.ContainsKey(bone.Name) && bone.Name != "")
                    NamePosDictionary.Add(bone.Name, Pos);
                mmdbone.Name = bone.Name;
                BoneDataProcessed[Pos] = mmdbone;
                Pos++;
            }
            
            //̃{[𓝍
            if (tag != null)
            {
                foreach (var i in tag.Bones)
                {
                    //{[̐VȈʒu擾
                    Pos = NamePosDictionary[i.Name];
                    //XLAj[Vf[^Ɠ
                    BoneDataProcessed[Pos].BoneType = i.BoneType;
                    if (i.IKParentBoneIndex == 0)
                        BoneDataProcessed[Pos].IKParentBoneIndex = 0;
                    else
                        BoneDataProcessed[Pos].IKParentBoneIndex = (ushort)NamePosDictionary[tag.Bones[i.IKParentBoneIndex].Name];
                    BoneDataProcessed[Pos].Name = i.Name;
                    if (i.HasIK)
                    {//IKf[^Ȃ炻Rs[
                        BoneDataProcessed[Pos].HasIK = true;
                        BoneDataProcessed[Pos].IK = new List<MMDIKData>();
                        for (int iknum = 0; iknum < i.IK.Count; iknum++)
                        {
                            MMDIKData IK = new MMDIKData();
                            IK.ControlWeight = i.IK[iknum].ControlWeight;
                            IK.IKBoneIndex = (ushort)NamePosDictionary[tag.Bones[i.IK[iknum].IKBoneIndex].Name];
                            IK.IKChildBones = new ushort[i.IK[iknum].IKChildBones.Length];
                            for (int j = 0; j < i.IK[iknum].IKChildBones.Length; j++)
                                IK.IKChildBones[j] = (ushort)NamePosDictionary[tag.Bones[i.IK[iknum].IKChildBones[j]].Name];

                            IK.IKTargetBoneIndex = (ushort)NamePosDictionary[tag.Bones[i.IK[iknum].IKTargetBoneIndex].Name];
                            IK.Iteration = i.IK[iknum].Iteration;
                            BoneDataProcessed[Pos].IK.Add(IK);
                        }
                    }
                }
                //x[X{[ݒ
                BoneDataProcessed[0].Name = "base";
                BoneDataProcessed[0].BoneType = MMDBoneType.RotateAndMove;
                BoneDataProcessed[0].IKParentBoneIndex = 0;
            }
            else
            {//^OȂf
                for (int i = 0; i < BoneDataProcessed.Length;i++ )
                {
                    //^OȂfIK
                    BoneDataProcessed[i].HasIK = false;
                    BoneDataProcessed[i].IK = null;
                    //{[^Cv͉]ړ
                    BoneDataProcessed[i].BoneType = MMDBoneType.RotateAndMove;
                    //eIK{[͖
                    BoneDataProcessed[i].IKParentBoneIndex = 0;
                }
            }

            //IKChildf[^MMDXŏ₷悤ɏC
            for (int i = 0; i < BoneDataProcessed.Length; i++)
            {
                if (BoneDataProcessed[i].HasIK)
                {
                    for (int iknum = 0; iknum < BoneDataProcessed[i].IK.Count; iknum++)
                    {
                        List<ushort> childList = new List<ushort>();
                        ushort j = BoneDataProcessed[i].IK[iknum].IKTargetBoneIndex;
                        while (true)
                        {
                            childList.Add(j);
                            //e{[擾
                            if (BoneDataProcessed[j].SkeletonHierarchy == -1)
                                break;//HeH
                            j = (ushort)BoneDataProcessed[j].SkeletonHierarchy;//boneindexWORD
                            //IKeȂ{[܂ŒT(Œ_߂悤iKȂ{[Ă)
                            bool flag = false;
                            foreach (var k in BoneDataProcessed[i].IK[iknum].IKChildBones)
                            {
                                if (k == j)
                                {
                                    flag = true;
                                    break;
                                }
                            }
                            if (!flag)
                                break;
                        }
                        BoneDataProcessed[i].IK[iknum].IKChildBones = childList.ToArray();
                    }
                }
            }
            // MMDModelDataɃvZXς݂̃{[i[
            result.Bones = BoneDataProcessed;
            //fvZbT[ɂ
            SkinnedModelProcessorReach skinnedProcessor = new SkinnedModelProcessorReach();
            //p[^ݒ
            skinnedProcessor.GenerateMipmaps = GenerateMipmaps;
            skinnedProcessor.ResizeTexturesToPowerOfTwo = ResizeTexturesToPowerOfTwo;
            skinnedProcessor.TextureFormat = TextureFormat;
            skinnedProcessor.ColorKeyEnabled = false;
            //vZX
            result.ModelData = skinnedProcessor.Process(input, context);
            //\Ȃ
            result.FaceData = null;
            result.FaceDataTextureSizeX = 0;
            result.FaceDataTextureSizeY = 0;
            result.FaceVertTextureSizeX = 0;
            result.FaceVertTextureSizeY = 0;

            //̃fRs[
            if (tag != null)
            {
                //\Ȃ
                result.Skins = null;
                result.NumVertexForFace = 0;
                result.Rigids = tag.Rigids;
                result.Joints = tag.Joints;
                //̂̏C
                for (int i = 0; i < result.Rigids.Length; i++)
                {
                    if (result.Rigids[i].RelatedBoneIndex != 0xffff)
                        result.Rigids[i].RelatedBoneIndex = (ushort)NamePosDictionary[tag.Bones[result.Rigids[i].RelatedBoneIndex].Name];
                }
            }
            else
            {
                //^OȂf͍̖
                result.Skins = null;
                result.NumVertexForFace = 0;
                result.Rigids = new MMDRigid[0];
                result.Joints = new MMDJoint[0];
            }
            //ZI[_[pIuWFNg
            result.PartCenters = null;
            result.UsePartCenterZSort = false;
            //Reach[h
            result.IsReach = true;
            //ԋp
            return result;
        }

        private void Factorization(int Number, out int dataspace, out int x, out int y)
        {
            if (Number == 0)
            {
                dataspace = 0;
                x = 0;
                y = 0;
                return;
            }
            int i = (int)Math.Floor(Math.Sqrt((double)Number));
            int end = (int)Math.Max(Math.Floor(Math.Sqrt((double)Number) / 1.5), Math.Ceiling((float)Number / 1024.0f));
            dataspace = int.MaxValue;
            x = i;
            for (; i >= end; i--)
            {
                y = (int)Math.Ceiling((double)Number / (double)i);
                if (y * i - Number < dataspace)
                {
                    dataspace = y * i - Number;
                    x = i;
                }
                if (dataspace == 0)
                    break;
            }
            if (dataspace == int.MaxValue)
            {
                if (Number > 1000 * 1000)
                    throw new InvalidContentException("\_f[^̉HɎs܂B\̒_܂");
                else
                    throw new ApplicationException("\_f[^̉HɎs܂");
            }
            y = (Number + dataspace) / x;
        }

        /// <summary>
        /// ̃bV̓XLAj[VɌ̂`FbN
        /// </summary>
        static void ValidateMesh(NodeContent node, ContentProcessorContext context,
                                 string parentBoneName)
        {
            MeshContent mesh = node as MeshContent;

            if (mesh != null)
            {
                // bV̐𒲂ׂ
                if (parentBoneName != null)
                {
                    context.Logger.LogWarning(null, null,
                        "{0}bV{1}{[̎qłB" +
                        "SkinnedModelProcessor̓bV{[̎qłP[X" +
                        "ΉĂ܂B",
                        mesh.Name, parentBoneName);
                }

                if (!MeshHasSkinning(mesh))
                {
                    context.Logger.LogWarning(null, null,
                        "{0}bV̓XLjO񂪂Ȃ̂ŕϊ܂",
                        mesh.Name);

                    mesh.Parent.Children.Remove(mesh);
                    return;
                }
            }
            else if (node is BoneContent)
            {
                // ̃m[h{[ȂA{[𒲍ł邱ƂoĂ
                parentBoneName = node.Name;
            }

            // ċAI(Ƀm[ĥŁA
            // qB̃Rs[𑖍)
            foreach (NodeContent child in new List<NodeContent>(node.Children))
                ValidateMesh(child, context, parentBoneName);
        }
        /// <summary>
        /// bVXLjOĂ邩ׂ
        /// </summary>
        static bool MeshHasSkinning(MeshContent mesh)
        {
            foreach (GeometryContent geometry in mesh.Geometry)
            {
                if (!geometry.Vertices.Channels.Contains(VertexChannelNames.Weights()))
                    return false;
            }

            return true;
        }
        /// <summary>
        /// SĂWԂɂȂ悤ɁAsKvȕϊs
        /// fEWIgɏĂt
        /// </summary>
        static void FlattenTransforms(NodeContent node, BoneContent skeleton)
        {
            foreach (NodeContent child in node.Children)
            {
                // XPg͏Ȃ
                if (child == skeleton)
                    continue;

                // [JϊsWIgɏĂ
                MeshHelper.TransformScene(child, child.Transform);

                // Ăt̂ŁA[JWϊs
                // Pʍs(Matrix.Identity)ɂȂ
                child.Transform = Matrix.Identity;

                // ċAĂяo
                FlattenTransforms(child, skeleton);
            }
        }
        /// <summary>
        /// Aj[VMMDpɕϊ
        /// </summary>
        static Dictionary<string, MMDMotionData> ProcessAnimations(AnimationContentDictionary animations, IList<BoneContent> bones)
        {
            if (animations.Count == 0)
                return new Dictionary<string, MMDMotionData>();//Ԃ
            // {[CfbNXɕϊ鎫e[u
            Dictionary<string, int> boneMap = new Dictionary<string, int>();
            for (int i = 0; i < bones.Count; i++)
            {
                string boneName = bones[i].Name;
                if (!string.IsNullOrEmpty(boneName))
                    boneMap.Add(boneName, i);
            }

            Dictionary<string, MMDMotionData> result = new Dictionary<string, MMDMotionData>();
            foreach (var animation in animations)
            {
                MMDMotionData motion = ProcessAnimation(animation.Value, boneMap, bones);
                result.Add(animation.Key, motion);
            }
            return result;
        }

        static MMDMotionData ProcessAnimation(AnimationContent animation, Dictionary<string, int> boneMap, IList<BoneContent> bones)
        {
            List<MMDBoneMotion> keyframes = new List<MMDBoneMotion>();

            //Aj[V`l
            foreach (var channel in animation.Channels)
            {
                if (!boneMap.ContainsKey(channel.Key))
                    continue;
                // L[t[̕ϊ
                foreach (AnimationKeyframe keyframe in channel.Value)
                {
                    //MMD̃[Vl*oCh|[Yf̃[VlȂ̂ŁAoCh|[Y̋t
                    Matrix InvBind = Matrix.Invert(bones[boneMap[channel.Key]].Transform);
                    Matrix transform = keyframe.Transform * InvBind;

                    // s̕
                    Quaternion rotation;
                    Vector3 translation;
                    Vector3 scale;
                    transform.Decompose(out scale, out rotation, out translation);
                    rotation.Normalize();

                    keyframes.Add(new MMDBoneMotion()
                    {
                        BoneName = channel.Key,
                        FrameNo = (uint)Math.Round((double)keyframe.Time.Ticks * 60.0 / (double)Stopwatch.Frequency),
                        Location = translation,
                        Quatanion = rotation,
                        Curve = CreateIdentityCurve()
                    });
                }
            }
            //\[g
            keyframes.Sort((x, y) => (int)((long)x.FrameNo - (long)y.FrameNo));
            //G[`FbN
            if (keyframes.Count == 0)
                throw new InvalidContentException(
                    "L[t[̖Aj[VłB");
            //MMDMotionDataɗ
            MMDMotionData result = new MMDMotionData();
            //L[t[Xgzɕϊ
            result.BoneMotions = keyframes.ToArray();
            //̑̂̂͂zɂ
            result.FaceMotions = new MMDFaceMotion[0];
            result.CameraMotions = new MMDCameraMotion[0];
            result.LightMotions = new MMDLightMotion[0];
            return result;

        }

        private static BezierCurve[] CreateIdentityCurve()
        {
            BezierCurve[] result = new BezierCurve[4];
            for (int i = 0; i < result.Length; i++)
            {
                result[i].v1 = new Vector2(0.25f, 0.25f);
                result[i].v2 = new Vector2(0.75f, 0.75f);
            }
            return result;
        }


    }
}