using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using MikuMikuDance.XNA.Model.ModelData;
using MMD = MikuMikuDance.Model.Ver1;

using TImport = MikuMikuDance.XNA.Model.MMDModelIntermediate;

// TODO: GbW̏
// TODO: gD[̏

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// C|[^[ŃrhĂB
    /// C|[^[ŃrhĂvZbTɎʂɂ̂܂܂ɂ
    /// </summary>
    class MMDBuilder
    {
        public bool UseMaterialPalette;
        /// <summary>
        /// rh
        /// </summary>
        /// <param name="filename">t@C</param>
        /// <param name="model">MMDff[^</param>
        /// <returns>MMDf for XNAԃNX</returns>
        /// <remarks>XNÃC|[^Ăяo</remarks>
        public TImport Build(string filename, MMD.MMDModel1 model)//, ContentImporterContext context)
        {
            //Identityݒ(Rec̃[h̔ʓɕKv)
            ContentIdentity Identity = new ContentIdentity(filename);
            
            //ԃf
            MMDModelIntermediate result = new MMDModelIntermediate();

            //_ԍ\p̒_ԍ̎쐬
            Dictionary<long, long> VertToFaceVert = new Dictionary<long, long>();
            for (int i = 0; i < model.Skins.Length; i++)
            {//baseT
                if (model.Skins[i].SkinType == 0)
                {
                    if (model.Skins[i].SkinVertDatas.LongLength > int.MaxValue)
                        throw new InvalidContentException("base\̒_܂BMikuMikuDanceXNAbase̒_32bitt̍ől܂łT|[gĂ܂", Identity);
                    for (long j = 0; j < model.Skins[i].SkinVertDatas.LongLength; j++)
                    {
                        VertToFaceVert.Add(model.Skins[i].SkinVertDatas[j].SkinVertIndex, j);
                    }
                    break;//łbase
                }
            }
            //XNÃbVf[^쐬
            //MMDfXNAœKς݃bVf[^擾
            MMDMeshData mmdMesh = MeshConverter.ConvertForXNA(model, Path.GetDirectoryName(filename), UseMaterialPalette);
            //Z^[
            long FaceVertCount = 0;
            result.PartCenters = new PartCenter[mmdMesh.Materials.Length];
            for (int i = 0; i < mmdMesh.Materials.Length; i++)
            {
                decimal[] center=new decimal[3];
                for (int j = 0; j < 3; j++)
                    center[j] = 0m;
                for (long FaceVert = FaceVertCount; FaceVert < FaceVertCount + mmdMesh.Materials[i].FaceVertCount; FaceVert++)
                {
                    center[0] += (decimal)mmdMesh.Vertexes[mmdMesh.FaceVertexes[FaceVert]].Pos.X;
                    center[1] += (decimal)mmdMesh.Vertexes[mmdMesh.FaceVertexes[FaceVert]].Pos.Y;
                    center[2] += (decimal)mmdMesh.Vertexes[mmdMesh.FaceVertexes[FaceVert]].Pos.Z;
                }
                for (int j = 0; j < 3; j++)
                    center[j] /= mmdMesh.Materials[i].FaceVertCount;
                result.PartCenters[i] = new PartCenter();
                result.PartCenters[i].DefaultCenterPos = new Vector3((float)center[0], (float)center[1], (float)center[2]);
                result.PartCenters[i].IsTranslucent = mmdMesh.Materials[i].IsTranslucent;
                FaceVertCount += mmdMesh.Materials[i].FaceVertCount;
            }
            
            //pbV̍쐬
            long[] VertMap;
            MMDMeshData mmdMeshBorder = MeshConverter.CreateBorderMesh(mmdMesh, out VertMap);
            //_}bsŐt쐬
            long[] InvVertMap = new long[mmdMeshBorder.Vertexes.LongLength];
            for (long i = 0; i < VertMap.LongLength; i++)
            {
                if (VertMap[i] != -1)
                {
                    InvVertMap[VertMap[i]] = i;
                }
            }
            //bṼrh
            MeshContent meshNormal = MMDMeshBuilder.BuildMesh(mmdMesh, filename, Identity, VertToFaceVert);
            MeshContent meshBorder = MMDMeshBuilder.BuildBorderMesh(mmdMeshBorder, filename, Identity, VertToFaceVert, InvVertMap);

            //{[̐
            List<MMDBoneData> mmdBone;
            BoneContent bone = CreateSkeleton(model, Identity, out mmdBone);
            result.Bones = mmdBone.ToArray();

            //[gm[h𐶐āAbVƃ{[i[
            NodeContent nodeContent = new NodeContent();
            nodeContent.Identity = Identity;
            if (meshNormal != null)
            {
                nodeContent.Children.Add(meshNormal);//bV
                if (meshBorder != null)//GbWbV΍
                    nodeContent.Children.Add(meshBorder);//E
            }
            nodeContent.Children.Add(bone);//{[

            //MMDԃfɃ[gm[hi[
            result.RootNode = nodeContent;
            result.Identity = Identity;

            //̑AMMDŗL̃f[^̊i[
            //IK̊i[
            //result.IKs = new List<MMDIKData>();
            for (UInt16 i = 0; i < model.IKs.Length; i++)
            {
                MMDIKData ik = new MMDIKData();
                ik.IKBoneIndex = model.IKs[i].IKBoneIndex;
                ik.IKTargetBoneIndex = model.IKs[i].IKTargetBoneIndex;
                ik.Iteration = model.IKs[i].Iterations;
                ik.ControlWeight = model.IKs[i].AngleLimit;
                ik.IKChildBones = new ushort[model.IKs[i].IKChildBoneIndex.Length];
                for (byte i2 = 0; i2 < model.IKs[i].IKChildBoneIndex.Length; i2++)
                {
                    ik.IKChildBones[i2] = model.IKs[i].IKChildBoneIndex[i2];
                }
                if (result.Bones[ik.IKBoneIndex].IK == null)
                {
                    result.Bones[ik.IKBoneIndex].IK = new List<MMDIKData>();
                    result.Bones[ik.IKBoneIndex].IK.Add(ik);
                    result.Bones[ik.IKBoneIndex].HasIK = true;
                }
                else
                    result.Bones[ik.IKBoneIndex].IK.Add(ik);
            }
            //\̊i[
            result.Skins = new MMDSkinData[model.Skins.Length];
            for (UInt16 i = 0; i < model.Skins.Length; i++)
            {
                MMDSkinData skin = new MMDSkinData();
                skin.Name = model.Skins[i].SkinName;
                skin.SkinType = (MMDSkinType)model.Skins[i].SkinType;
                skin.SkinVerts = new MMDSkinVertData[model.Skins[i].SkinVertDatas.LongLength];
                for (UInt32 i2 = 0; i2 < model.Skins[i].SkinVertDatas.LongLength; i2++)
                {
                    skin.SkinVerts[i2] = new MMDSkinVertData();
                    skin.SkinVerts[i2].VertIndex = model.Skins[i].SkinVertDatas[i2].SkinVertIndex;
                    skin.SkinVerts[i2].Pos = new float[model.Skins[i].SkinVertDatas[i2].SkinVertPos.Length];
                    for (int i3 = 0; i3 < 3; i3++)
                        skin.SkinVerts[i2].Pos[i3] = model.Skins[i].SkinVertDatas[i2].SkinVertPos[i3];
                }
                result.Skins[i] = skin;
            }
            //\pɗpbaseS_i[
            result.NumVertexForFace = VertToFaceVert.Count;

            //Zf[^i[
            //if (model.RigidBodies!=null && model.RigidBodies.LongLength > int.MaxValue)
            //    throw new InvalidContentException("Zp̍̐BulletX̓sɂ"
            //            + int.MaxValue.ToString() + "EłB̃f" + model.RigidBodies.LongLength + "̍̂܂܂Ă܂", Identity);
            //if (model.RigidBodies != null &&  model.Joints.LongLength > int.MaxValue)
            //    throw new InvalidContentException("ZpJointBulletX̓sɂ"
            //            + int.MaxValue.ToString() + "EłB̃f" + model.Joints.LongLength + "̍̂܂܂Ă܂", Identity);
            result.Rigids = new MMDRigid[0];
            if (model.RigidBodies != null)
            {
                result.Rigids = new MMDRigid[model.RigidBodies.LongLength];
                for (UInt32 i = 0; i < model.RigidBodies.LongLength; i++)
                {
                    MMDRigid rigid = new MMDRigid();
                    rigid.AngularDamping = model.RigidBodies[i].AngularDamping;
                    rigid.Friction = model.RigidBodies[i].Friction;
                    rigid.GroupIndex = model.RigidBodies[i].GroupIndex;
                    rigid.GroupTarget = model.RigidBodies[i].GroupTarget;
                    rigid.LinerDamping = model.RigidBodies[i].LinerDamping;
                    rigid.Name = model.RigidBodies[i].Name;
                    rigid.Position = new float[model.RigidBodies[i].Position.Length];
                    for (int j = 0; j < rigid.Position.Length; j++)
                        rigid.Position[j] = model.RigidBodies[i].Position[j];
                    rigid.RelatedBoneIndex = model.RigidBodies[i].RelatedBoneIndex;
                    rigid.Restitution = model.RigidBodies[i].Restitution;
                    rigid.Rotation = new float[model.RigidBodies[i].Rotation.Length];
                    for (int j = 0; j < rigid.Rotation.Length; j++)
                        rigid.Rotation[j] = model.RigidBodies[i].Rotation[j];
                    rigid.ShapeDepth = model.RigidBodies[i].ShapeDepth;
                    rigid.ShapeHeight = model.RigidBodies[i].ShapeHeight;
                    rigid.ShapeType = model.RigidBodies[i].ShapeType;
                    rigid.ShapeWidth = model.RigidBodies[i].ShapeWidth;
                    rigid.Type = model.RigidBodies[i].Type;
                    rigid.Weight = model.RigidBodies[i].Weight;
                    result.Rigids[i] = rigid;
                }
            }
            result.Joints = new MMDJoint[0];
            if (model.Joints != null)
            {
                result.Joints = new MMDJoint[model.Joints.LongLength];
                for (UInt32 i = 0; i < model.Joints.LongLength; i++)
                {
                    MMDJoint joint = new MMDJoint();
                    joint.ConstrainPosition1 = new float[model.Joints[i].ConstrainPosition1.Length];
                    for (int j = 0; j < joint.ConstrainPosition1.Length; j++)
                        joint.ConstrainPosition1[j] = model.Joints[i].ConstrainPosition1[j];
                    joint.ConstrainPosition2 = new float[model.Joints[i].ConstrainPosition2.Length];
                    for (int j = 0; j < joint.ConstrainPosition2.Length; j++)
                        joint.ConstrainPosition2[j] = model.Joints[i].ConstrainPosition2[j];
                    joint.ConstrainRotation1 = new float[model.Joints[i].ConstrainRotation1.Length];
                    for (int j = 0; j < joint.ConstrainRotation1.Length; j++)
                        joint.ConstrainRotation1[j] = model.Joints[i].ConstrainRotation1[j];
                    joint.ConstrainRotation2 = new float[model.Joints[i].ConstrainRotation2.Length];
                    for (int j = 0; j < joint.ConstrainRotation2.Length; j++)
                        joint.ConstrainRotation2[j] = model.Joints[i].ConstrainRotation2[j];
                    MMDMath.CheckMinMax(joint.ConstrainPosition1, joint.ConstrainPosition2);
                    MMDMath.CheckMinMax(joint.ConstrainRotation1, joint.ConstrainRotation2);

                    joint.Name = model.Joints[i].Name;
                    joint.Position = new float[model.Joints[i].Position.Length];
                    for (int j = 0; j < joint.Position.Length; j++)
                        joint.Position[j] = model.Joints[i].Position[j];
                    joint.RigidBodyA = model.Joints[i].RigidBodyA;
                    joint.RigidBodyB = model.Joints[i].RigidBodyB;
                    joint.Rotation = new float[model.Joints[i].Rotation.Length];
                    for (int j = 0; j < joint.Rotation.Length; j++)
                        joint.Rotation[j] = model.Joints[i].Rotation[j];
                    joint.SpringPosition = new float[model.Joints[i].SpringPosition.Length];
                    for (int j = 0; j < joint.SpringPosition.Length; j++)
                        joint.SpringPosition[j] = model.Joints[i].SpringPosition[j];
                    joint.SpringRotation = new float[model.Joints[i].SpringRotation.Length];
                    for (int j = 0; j < joint.SpringRotation.Length; j++)
                        joint.SpringRotation[j] = model.Joints[i].SpringRotation[j];
                    result.Joints[i] = joint;
                }
            }
            
            //[gm[hԋp
            return result;
        }

        private BoneContent CreateSkeleton(MikuMikuDance.Model.Ver1.MMDModel1 model, ContentIdentity Identity, out List<MMDBoneData> mmdBones)
        {
            //{[ꗗ
            List<MMDBoneSetIntermediate> bones = new List<MMDBoneSetIntermediate>();
            mmdBones = new List<MMDBoneData>();
            //{[ꗗ𐶐
            for (UInt16 i = 0; i < model.Bones.Length; i++)
            {
                bones.Add(new MMDBoneSetIntermediate(model.Bones[i]));
                //XNÃ{[ŏȂf[^MMDBoneNXɓ
                MMDBoneData mmdBone = new MMDBoneData();
                mmdBone.Name = model.Bones[i].BoneName;
                if (mmdBone.Name == "")
                    throw new InvalidContentException(
                    "All bones need to be named.", Identity);
                mmdBone.BoneType=(MMDBoneType)model.Bones[i].BoneType;
                mmdBone.IKParentBoneIndex = model.Bones[i].IKParentBoneIndex;
                mmdBones.Add(mmdBone);
            }
            //Ń{[gݗĂ
            //[g{[𐶐
            BoneContent rootBone = new BoneContent();
            UInt16 rootBoneIndex = UInt16.MaxValue;
            rootBone.Name = GetAliasName("root", 0, bones);
            rootBone.Identity = Identity;
            //root(0,0,0)?
            rootBone.Transform = Matrix.CreateFromYawPitchRoll(0, 0, 0) * Matrix.CreateTranslation(0, 0, 0);
            //[g{[ɑgݗĂ
            try
            {
                BuildSkelton(rootBone, rootBoneIndex, bones);
            }
            catch (StackOverflowException e)
            {
                throw new InvalidContentException("bone tree was looped", Identity, e);
            }

            //[g{[ɑgݗĂĂ̂łԋp
            return rootBone;
        }

        private string GetAliasName(string baseName, int NextNum, List<MMDBoneSetIntermediate> bones)
        {//̃{[ƔȂ悤ȃGCAX쐬
            string boneName = baseName;
            if (NextNum > 0)
                boneName += Convert.ToString(NextNum);
            foreach (var bone in bones)
            {
                if (bone.Bone.Name == boneName)
                    return GetAliasName(baseName, NextNum + 1, bones);
            }
            return boneName;
        }

        private void BuildSkelton(BoneContent ParentBone, UInt16 ParentBoneIndex, List<MMDBoneSetIntermediate> bones)
        {
            //܂͐e{[ԍɌ
            for (UInt16 i = 0; i < bones.Count; i++)
            {
                if (bones[i].BoneParent == ParentBoneIndex)
                {//q{[𔭌
                    //܂͐e{[̐΍sɎq̍sC
                    Matrix parent = ParentBone.AbsoluteTransform;
                    //Ɏq̍sݒ
                    //e̐΍s*q̍s=q̐΍sAq̍s=e̐΍sts*q̐΍s
                    bones[i].Bone.Transform = Matrix.Invert(parent) * bones[i].Bone.Transform;
                    //eɓo^
                    ParentBone.Children.Add(bones[i].Bone);
                    //ċAIɒ
                    BuildSkelton(bones[i].Bone, i, bones);
                }
            }
        }
    }
}
