using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;

// TODO: replace these with the processor input and output types.
using TInput = MikuMikuDance.XNA.Accessory.VACContent;
using TOutput = MikuMikuDance.XNA.Accessory.MMD_VAC;
using System.ComponentModel;

namespace MikuMikuDance.XNA.Accessory
{
    /// <summary>
    /// This class will be instantiated by the XNA Framework Content Pipeline
    /// to apply custom processing to content data, converting an object of
    /// type TInput to TOutput. The input and output types may be the same if
    /// the processor wishes to alter data without changing its type.
    ///
    /// This should be part of a Content Pipeline Extension Library project.
    ///
    /// TODO: change the ContentProcessor attribute to specify the correct
    /// display name for this processor.
    /// </summary>
    [ContentProcessor(DisplayName = "MikuMikuDance VAC : MikuMikuDance for XNA")]
    public class VACProcessor : ContentProcessor<TInput, TOutput>
    {
        bool leftHanded = true;
        /// <summary>
        /// WnEWnւ̕ϊ
        /// </summary>
        [DefaultValue(true)]
        [DisplayName("聨Eւ̕ϊ")]
        [Description("VACt@CMikuMikuDanceW̍WnŋLqĂꍇtruew")]
        public bool LeftHanded { get { return leftHanded; } set { leftHanded = value; } }
        /// <summary>
        /// VACProcessor
        /// </summary>
        /// <param name="input">VACContentf[^</param>
        /// <param name="context">vZbTReLXg</param>
        /// <returns>MMD_VAC</returns>
        public override TOutput Process(TInput input, ContentProcessorContext context)
        {
            if (LeftHanded)
            {
                input.Trans.Z = -input.Trans.Z;
                input.Rot.X = -input.Rot.X;
                input.Rot.Y = -input.Rot.Y;
            }
            return new TOutput
            {
                BoneName = input.BoneName,
                Shadow = input.Shadow,
                Transform = Matrix.CreateScale(input.Scale)
                * Matrix.CreateFromYawPitchRoll(input.Rot.Y, input.Rot.X, input.Rot.Z)
                * Matrix.CreateTranslation(input.Trans)
            };
        }
    }
}