//******************************************************************************
//
// Simple Base Library / YNErrCtrl
//
// G[NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef YNBASELIB_EXPORTS
#define YNBASELIB_API __declspec(dllexport)
#else
#define YNBASELIB_API __declspec(dllimport)
#endif

#include "YNErrInfo.h"

namespace YNBaseLib {

//******************************************************************************
//G[}N
//******************************************************************************
#define YN_SET_ERR(msg,info1,info2)   YNErrCtrl::SetErr(YNErrInfo::LVL_ERR,__LINE__,__FUNCTION__,msg,info1,info2)
#define YN_SET_WARN(msg,info1,info2)  YNErrCtrl::SetErr(YNErrInfo::LVL_WARN,__LINE__,__FUNCTION__,msg,info1,info2)
#define YN_SET_INFO(msg,info1,info2)  YNErrCtrl::SetErr(YNErrInfo::LVL_INFO,__LINE__,__FUNCTION__,msg,info1,info2)
#define YN_SHOW_ERR(howner)   YNErrCtrl::ShowErr(howner)


//******************************************************************************
// G[NX
//******************************************************************************
class YNBASELIB_API YNErrCtrl
{
private:

	//RXgN^^fXgN^
	//CX^XȂ
	YNErrCtrl();
	virtual ~YNErrCtrl();

public:

	//
	//  vZXA^b`Ɏs
	//  ʗp҂͗pȂ
	static int Initialize();

	//I
	//  vZXIɎs
	//  ʗp҂͗pȂ
	static int Terminate();

	//G[o^
	static int SetErr(
			YNErrInfo::ErrLevel errLevel,
			unsigned long lineNo,
			const TCHAR* pFuncName,
			const TCHAR* pMessage,
			unsigned long errInfo1,
			unsigned long errInfo2
		);

	//G[擾
	static YNErrInfo* GetErr();

	//G[_CAO\
	static int ShowErr(HWND hOwner);

private:

	//ƃRs[RXgN^̋֎~
	void operator=(const YNErrCtrl&);
	YNErrCtrl(const YNErrCtrl&);

};

} // end of namespace

