//******************************************************************************
//
// MIDITrail / DIMouseCtrl
//
// DirectInput }EXNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "DIMouseCtrl.h"

using namespace YNBaseLib;

//******************************************************************************
// }N`
//******************************************************************************
#define IS_KEYDOWN(btn)  (btn & 0x80)

//******************************************************************************
// RXgN^
//******************************************************************************
DIMouseCtrl::DIMouseCtrl(void)
{
	m_pDI = NULL;
	m_pDIDevice = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
DIMouseCtrl::~DIMouseCtrl(void)
{
	Terminate();
}

//******************************************************************************
// 
//******************************************************************************
int DIMouseCtrl::Initialize(
		HWND hWnd
	)
{
	int result = 0;
	HRESULT hresult = DI_OK;
	HINSTANCE hInstance = NULL;

	Terminate();

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)GetWindowLongPtr(hWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hWnd);
		goto EXIT;
	}

	//DirectInputIuWFNg̐
	hresult = DirectInput8Create(
				hInstance,				//AvP[VCX^Xnh
				DIRECTINPUT_VERSION,	//DirectInputo[Wԍ
				IID_IDirectInput8,		//C^[tF[Xʎq
				(void**)&m_pDI,			//쐬ꂽC^[tF[X|C^
				NULL					//IUnknownC^[tFCX|C^
			);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, (DWORD)hInstance);
		goto EXIT;
	}

	//foCXIuWFNg̐
	hresult = m_pDI->CreateDevice(
					GUID_SysMouse,		//̓foCX̃CX^XGUID
					&m_pDIDevice,		//쐬ꂽC^[tF[X|C^
					NULL				//IUnknownC^[tFCX|C^
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//foCX̃f[^tH[}bgݒF`ς݃O[oϐw
	hresult = m_pDIDevice->SetDataFormat(&c_dfDIMouse2);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//foCX̋xݒ
	hresult = m_pDIDevice->SetCooperativeLevel(
					hWnd,					//foCXɊ֘AtĂEBhEnh
					DISCL_FOREGROUND		//xFtHAOhANZX
					| DISCL_NONEXCLUSIVE	//xFrIANZX
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, (DWORD)hWnd);
		goto EXIT;
	}

	//foCX̃vpeBݒFobt@TCY
	DIPROPDWORD diprop;
	diprop.diph.dwSize       = sizeof(DIPROPDWORD);
	diprop.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diprop.diph.dwObj        = 0;			//DIPH_DEVICȄꍇ̓[
	diprop.diph.dwHow        = DIPH_DEVICE;	//dwObj̉ߕ@FfoCXS
	diprop.dwData            = 16;			//ݒ肷vpeBFobt@TCY

	hresult = m_pDIDevice->SetProperty(
					DIPROP_BUFFERSIZE,	//ݒΏۃvpeBGUID
					&diprop.diph		//ݒ肷DIPROPHEADER\
				);
	if (FAILED(hresult) && (hresult != DI_PROPNOEFFECT)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//foCX̃vpeBݒF[h
	diprop.diph.dwSize       = sizeof(DIPROPDWORD);
	diprop.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diprop.diph.dwObj        = 0;			//DIPH_DEVICȄꍇ̓[
	diprop.diph.dwHow        = DIPH_DEVICE;	//dwObj̉ߕ@FfoCXS
	diprop.dwData            = DIPROPAXISMODE_REL;	//ݒ肷vpeBFΒl[h

	hresult = m_pDIDevice->SetProperty(
					DIPROP_AXISMODE,	//ݒΏۃvpeBGUID
					&diprop.diph		//ݒ肷DIPROPHEADER\
				);
	if (FAILED(hresult) && (hresult != DI_PROPNOEFFECT)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// I
//******************************************************************************
void DIMouseCtrl::Terminate()
{
	if (m_pDIDevice != NULL) {
		m_pDIDevice->Unacquire();
		m_pDIDevice->Release();
		m_pDIDevice = NULL;
	}

	if (m_pDI != NULL) {
		m_pDI->Release();
		m_pDI = NULL;
	}

	return;
}

//******************************************************************************
// foCXANZX擾
//******************************************************************************
int DIMouseCtrl::Acquire()
{
	int result = 0;
	HRESULT hresult = DI_OK;

	if (m_pDIDevice == NULL) goto EXIT;

	//ANZX擾F//foCX擾ς(S_FALSE)͐Ƃ݂Ȃ
	hresult = m_pDIDevice->Acquire();
	if (FAILED(hresult) && (hresult != S_FALSE)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// foCXANZX
//******************************************************************************
int DIMouseCtrl::Unacquire()
{
	int result = 0;
	HRESULT hresult = DI_OK;

	if (m_pDIDevice == NULL) goto EXIT;

	//ANZX
	hresult = m_pDIDevice->Unacquire();
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// }EXԎ擾
//******************************************************************************
int DIMouseCtrl::GetMouseStatus()
{
	int result = 0;
	HRESULT hresult = DI_OK;

	if (m_pDIDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	hresult = m_pDIDevice->GetDeviceState(sizeof(DIMOUSESTATE2), &m_MouseState);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//EBhEANeBuԂłGetDeviceState()̓G[ɂȂ(0x8007000c)
	//ǂ悤EEE

EXIT:;
	return result;
}

//******************************************************************************
// }EX{^ԊmF
//******************************************************************************
bool DIMouseCtrl::IsBtnDown(
		MouseButton	target
	)
{
	bool isDown = false;
	BYTE btn = 0;

	if (m_pDIDevice == NULL) goto EXIT;

	if (target == LeftButton) {
		btn = m_MouseState.rgbButtons[0];
	}
	if (target == RightButton) {
		btn = m_MouseState.rgbButtons[1];
	}

	if (IS_KEYDOWN(btn)) {
		isDown = true;
	}

EXIT:;
	return isDown;
}

//******************************************************************************
// }EXΈړʎ擾
//******************************************************************************
int DIMouseCtrl::GetDelta(
		MouseAxis	target
	)
{
	int rel = 0;

	if (m_pDIDevice == NULL) goto EXIT;

	if (target == AxisX) {
		rel = m_MouseState.lX;
	}
	if (target == AxisY) {
		rel = m_MouseState.lY;
	}
	if (target == AxisWheel) {
		rel = m_MouseState.lZ;
	}

EXIT:;
	return rel;
}

//******************************************************************************
// obt@f[^擾
//******************************************************************************
int DIMouseCtrl::GetBuffer(
		bool* pIsExist,
		MouseEvent* pEvent,
		int* pDeltaAxis
	)
{
	int result = 0;
	HRESULT hresult = DI_OK;
	DIDEVICEOBJECTDATA devObjData;
	DWORD inOut = 1;

	if ((m_pDIDevice == NULL) || (pIsExist == NULL) || (pEvent == NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	*pIsExist = false;

	//obt@f[^擾isobt@ЂƂj
	hresult = m_pDIDevice->GetDeviceData(
						sizeof(DIDEVICEOBJECTDATA),	//DIOBJECTDATAFORMAT\̃TCY
						&devObjData,				//obt@f[^zF1
						&inOut,						//́Fobt@vf^óFf[^擾
						0							//tO
					);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectInput API error.", hresult, 0);
		goto EXIT;
	}

	//obt@ȂΏI
	if (inOut == 0) goto EXIT;

	//obt@f[^
	switch (devObjData.dwOfs) {
		case DIMOFS_BUTTON0:
			if (IS_KEYDOWN(devObjData.dwData)) {
				*pEvent = LeftButtonDown;
			}
			else {
				*pEvent = LeftButtonUp;
			}
			break;
		case DIMOFS_BUTTON1:
			if (IS_KEYDOWN(devObjData.dwData)) {
				*pEvent = RightButtonDown;
			}
			else {
				*pEvent = RightButtonUp;
			}
			break;
		case DIMOFS_BUTTON2:
			if (IS_KEYDOWN(devObjData.dwData)) {
				*pEvent = CenterButtonDown;
			}
			else {
				*pEvent = CenterButtonUp;
			}
			break;
		case DIMOFS_X:
			*pEvent = AxisXMove;
			if (pDeltaAxis!= NULL) {
				*pDeltaAxis = (int)devObjData.dwData;
			}
			break;
		case DIMOFS_Y:
			*pEvent = AxisYMove;
			if (pDeltaAxis!= NULL) {
				*pDeltaAxis = (int)devObjData.dwData;
			}
			break;
		case DIMOFS_Z:
			*pEvent = AxisWheelMove;
			if (pDeltaAxis!= NULL) {
				*pDeltaAxis = (int)devObjData.dwData;
			}
			break;
		default:
			break;
	}

	*pIsExist = true;

EXIT:;
	return result;
}

