//******************************************************************************
//
// Simple MIDI Library / SMSequencer
//
// V[PTNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ^C}[Xbh͉ts߁AMIDIo̓foCX̐ɐO
// B̃XbhŉʍXVsĂ͂ȂȂB
// Xbhւ̒ʒmPostMessageŎB
// _TimerCallBack()_OnTimer()EEE

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMSequencer.h"
#include "SMEventMIDI.h"
#include "SMEventSysEx.h"
#include "SMEventMeta.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMSequencer::SMSequencer(void)
{
	m_Status = StatusStop;
	m_PlayIndex = 0;
	m_UserRequest = RequestNone;
	m_PortNo = 0;
	m_pSeqData = NULL;
	m_TimerID = NULL;
	m_TimerResolution = 0;
	m_TimeDivision = 0;
	m_Tempo = SM_DEFAULT_TEMPO;

	m_PrevTimerTime = 0;
	m_CurPlayTime = 0;
	m_PrevEventTime = 0;
	m_NextEventTime = 0;
	m_NextNtcTime = 0;
	m_TotalTickTime = 0;
	
	m_TickTimeOfBar = 0;
	m_CurBarNo = 1;
	m_PrevBarTickTime = 0;
	
	_ClearPortInfo();
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMSequencer::~SMSequencer(void)
{
	//MIDIo̓foCX
	_CloseMIDIOutDev();

	//^C}foCX
	_ReleaseTimerDev();
}

//******************************************************************************
// 
//******************************************************************************
int SMSequencer::Initialize(
		HWND hTargetWnd,
		unsigned long msgId
	)
{
	int result = 0;

	if (m_Status != StatusStop) {
		result = YN_SET_ERR("Program error.", m_Status, 0);
		goto EXIT;
	}

	//MIDIo̓foCX
	result = m_OutDevCtrl.Initialize();
	if (result != 0) goto EXIT;

	//|[gNA
	_ClearPortInfo();

	//Cxg]IuWFNg
	result = m_MsgTrans.Initialize(hTargetWnd, msgId);

	//^C}foCX
	result = _InitializeTimerDev();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// |[gΉfoCXo^
//******************************************************************************
int SMSequencer::SetPortDev(
		unsigned char portNo,
		const char* pProductName
	)
{
	int result = 0;
	errno_t eresult = 0;

	if (portNo >= SM_MIDIOUT_PORT_NUM_MAX) {
		result = -1;
		goto EXIT;
	}

	eresult = strcpy_s(m_PortDevName[portNo], MAXPNAMELEN, pProductName);
	if (eresult != 0) {
		result = -1;
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// V[PXf[^o^
//******************************************************************************
int SMSequencer::SetSeqData(
		SMSeqData* pSeqData
	)
{
	int result = 0;
	unsigned long numerator = 0;
	unsigned long denominator = 0;

	if (m_Status != StatusStop) {
		result = YN_SET_ERR("Program error.", m_Status, 0);
		goto EXIT;
	}

	m_pSeqData = pSeqData;

	//}[Wς݃gbN擾
	result = m_pSeqData->GetMergedTrack(&m_Track);
	if (result != 0) goto EXIT;

	//\擾Fl̒l (ex. 48, 480, ...)
	m_TimeDivision = m_pSeqData->GetTimeDivision();
	if (m_TimeDivision == 0) {
		//f[^ُFSMFǂݍݎɃ`FbNĂ͂
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//e|擾
	m_Tempo = m_pSeqData->GetTempo();
	if (m_Tempo == 0) {
		//f[^ُ
		result = YN_SET_ERR("Invalid data found.", 0, 0);
		goto EXIT;
	}

	//qL1߂̃`bN^CZo
	numerator = m_pSeqData->GetBeatNumerator();
	denominator = m_pSeqData->GetBeatDenominator();
	if (denominator == 0) {
		//f[^ُ
		result = YN_SET_ERR("Invalid data found.", numerator, denominator);
		goto EXIT;
	}
	m_TickTimeOfBar = (numerator * m_TimeDivision * 4) / denominator;

EXIT:;
	return result;
}

//******************************************************************************
// tJn
//******************************************************************************
int SMSequencer::Play()
{
	int result = 0;
	unsigned long deltaTime = 0;

	if (m_pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//tȂ牽Ȃ
	if (m_Status == StatusPlay) goto EXIT;

	//擪牉tJn
	if (m_Status == StatusStop) {
		m_PlayIndex = 0;
		result = m_Track.GetDataSet(m_PlayIndex, &deltaTime, &m_Event, &m_PortNo);
		if (result != 0) goto EXIT;

		m_PrevTimerTime = timeGetTime();
		m_CurPlayTime = 0;
		m_PrevEventTime = 0;
		m_NextEventTime = _ConvTick2TimeMsec(deltaTime);
		m_NextNtcTime = 0;
		m_PrevDeltaTime = deltaTime;
		m_TotalTickTime = 0;
		
		m_CurBarNo = 1;
		m_PrevBarTickTime = 0;

		//MIDIo̓foCXJ
		result = _OpenMIDIOutDev();
		if (result != 0) goto EXIT;
	}
	//ꎞ~牉tĊJ
	if (m_Status == StatusPause) {
		m_PrevTimerTime = timeGetTime();
	}
	m_Status = StatusPlay;
	m_UserRequest = RequestNone;
	m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_PLAY);

	//^C}N
	m_TimerID = timeSetEvent(
					m_TimerResolution, //Cxgxi~bj
					m_TimerResolution, //Cxg\i~bj
					_TimerCallBack,    //R[obN֐
					(DWORD_PTR)this,   //[U[R[obNf[^
					TIME_PERIODIC      //^C}[ʁFĂяo
				);
	if (m_TimerID == NULL) {
		result = YN_SET_ERR("Timer device error.", m_TimerResolution, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// tꎞ~
//******************************************************************************
void SMSequencer::Pause()
{
	//v󂯕t邾iL[CO͂Ȃj
	//ۂ̏̓^C}[XbhɈϔC
	m_UserRequest = RequestPause;
}

//******************************************************************************
// tĊJ
//******************************************************************************
int SMSequencer::Resume()
{
	int result = 0;
	
	//݂Play()ĊJ˂Ă
	result = Play();
	
//EXIT:;
	return result;
}

//******************************************************************************
// t~
//******************************************************************************
void SMSequencer::Stop()
{

	if (m_Status == StatusPause) {
		//ꎞ~̏ꍇ̓^C}[Xbh~Ă邽
		//Iʒm
		m_Status = StatusStop;
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
	}
	else {
		//t͗v󂯕t邾iL[CO͂Ȃj
		//ۂ̏̓^C}[XbhɈϔC
		m_UserRequest = RequestStop;
	}
}

//******************************************************************************
// ^C}foCX
//******************************************************************************
int SMSequencer::_InitializeTimerDev()
{
	int result = 0;
	UINT apiresult = 0;
	TIMECAPS tc;
	
	if (m_TimerResolution != 0) goto EXIT;

	//^C}foCX̍ŏ\擾iʏ1msj
	apiresult = timeGetDevCaps(&tc, sizeof(TIMECAPS));
	if (apiresult != TIMERR_NOERROR) {
		result = YN_SET_ERR("Timer device error.", apiresult, 0);
		goto EXIT;
	}
	m_TimerResolution = tc.wPeriodMin;

	//ŏ^C}\̐ݒ
	timeBeginPeriod(m_TimerResolution);

EXIT:;
	return result;
}

//******************************************************************************
// ^C}foCX
//******************************************************************************
int SMSequencer::_ReleaseTimerDev()
{
	int result = 0;
	UINT apiresult = 0;

	if (m_TimerResolution != 0) {
		apiresult = timeEndPeriod(m_TimerResolution);
		if (apiresult != TIMERR_NOERROR) {
			result = YN_SET_ERR("Timer device error.", apiresult, 0);
			goto EXIT;
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// |[gNA
//******************************************************************************
void SMSequencer::_ClearPortInfo()
{
	unsigned char portNo = 0;

	for (portNo = 0; portNo < SM_MIDIOUT_PORT_NUM_MAX; portNo++) {
		m_PortDevName[portNo][0] = '\0';
	}
}

//******************************************************************************
// MIDIo̓foCXI[v
//******************************************************************************
int SMSequencer::_OpenMIDIOutDev()
{
	int result = 0;
	unsigned char portNo = 0;

	//|[gΉfoCXMIDIo̓foCXɓo^
	for (portNo = 0; portNo < SM_MIDIOUT_PORT_NUM_MAX; portNo++) {
		if (strlen(m_PortDevName[portNo]) > 0) {
			result = m_OutDevCtrl.SetPortDev(portNo, m_PortDevName[portNo]);
			if (result != 0) goto EXIT;
		}
	}

	//S|[g̃foCXJ
	result = m_OutDevCtrl.OpenPortDevAll();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// MIDIo̓foCXN[Y
//******************************************************************************
int SMSequencer::_CloseMIDIOutDev()
{
	int result = 0;

	result = m_OutDevCtrl.ClosePortDevAll();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ^C}[Ăяo
//******************************************************************************
int SMSequencer::_OnTimer()
{
	int result = 0;
	unsigned long deltaTime = 0;
	
	//tʒuXV
	result = _UpdatePlayPosition();
	if (result != 0) goto EXIT;

	//CxgɓBĂ瑗Ms
	if (m_NextEventTime <= m_CurPlayTime) {

		//tʒu␳
		m_CurPlayTime = m_NextEventTime;

		//`bN^Cv
		m_TotalTickTime += m_PrevDeltaTime;

		while (deltaTime == 0) {
			//CxgM
			result = _OutputMIDIEvent(m_PortNo, &m_Event);
			if (result != 0) goto EXIT;

			//f[^I[Ȃ牉tI
			m_PlayIndex++;
			if (m_PlayIndex >= m_Track.GetSize()) {
				m_MsgTrans.PostPlayTime(m_CurPlayTime/1000, m_TotalTickTime);
				m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
				m_Status = StatusStop;
				timeKillEvent(m_TimerID);
				m_TimerID = NULL;
				break;
			}

			//Cxg擾
			m_Track.GetDataSet(m_PlayIndex, &deltaTime, &m_Event, &m_PortNo);
		}
		//CxgMʒuZo
		m_PrevEventTime = m_NextEventTime;
		m_NextEventTime = m_CurPlayTime + _ConvTick2TimeMsec(deltaTime);
		m_PrevDeltaTime = deltaTime;
	}

	//[UNGXg̏
	if (m_UserRequest != RequestNone) {
		result = _ProcUserRequest();
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// tʒuXV
//******************************************************************************
int SMSequencer::_UpdatePlayPosition()
{
	int result = 0;
	unsigned long curTime = 0;
	unsigned long diffTime = 0;
	unsigned long diffTickTime = 0;
	unsigned long curTotalTickTime = 0;
	unsigned long nextBarTickTime = 0;
	unsigned long ntcSpan = 0;

	curTime = timeGetTime();

	//O^C}[̌oߎԂ𗘗pĉtԂXV
	diffTime = curTime - m_PrevTimerTime;
	if (curTime < m_PrevTimerTime) {
		diffTime = 0xFFFFFFFF - m_PrevTimerTime + 1 + curTime;
	}
	m_CurPlayTime += diffTime;
	m_PrevTimerTime = curTime;

	//OCxǧoߎԂ`bN^CɊZ
	diffTickTime = _ConvTimeMsec2Tick(m_CurPlayTime - m_PrevEventTime);

	//Ȑ擪̃`bN^Cv
	//m_TotalTickTime̓Cxgɂ̂ݍXV߂ł͏Ȃ
	curTotalTickTime = m_TotalTickTime + diffTickTime;

	//ʒmԂɓB牉tԂʒm
	if (m_NextNtcTime <= m_CurPlayTime) {
		//ʒmFԂ͕bœ`
		m_MsgTrans.PostPlayTime(m_CurPlayTime/1000, curTotalTickTime);
		//ʒmԊu60FPS\l0.01b(10msec)Ƃ
		//TODO: OԊuwł悤ɂ
		ntcSpan = 10;
		m_NextNtcTime = m_CurPlayTime - (m_CurPlayTime % ntcSpan) + ntcSpan;
	}
	
	//ߔԍXV̊mF
	nextBarTickTime = m_PrevBarTickTime + m_TickTimeOfBar;
	if (nextBarTickTime <= curTotalTickTime) {
		m_CurBarNo++;
		m_PrevBarTickTime = nextBarTickTime;
		m_MsgTrans.PostBar(m_CurBarNo);
	}

//EXIT:;
	return result;
}

//******************************************************************************
// `bN^CԂւ̕ϊi~bj
//******************************************************************************
unsigned long SMSequencer::_ConvTick2TimeMsec(
		unsigned long tickTime
	)
{
	unsigned long timeMsec = 0;
	unsigned long long a = 0;
	unsigned long long b = 0;
	unsigned long long c = 0;

	//(1) l̕\ division
	//    F48
	//(2) gbNf[^̃f^^C delta
	//    \̒lpĕ\鎞ԍ
	//    \48Ńf^^C24Ȃ甪̎ԍ
	//(3) e|ݒi}CNbj tempo
	//    l̎ԊԊu
	//
	//  f^^CɑΉԊԊui~bj
	//  = (delta / division) * tempo / 1000
	//  = (delta * tempo) / (division * 1000)

	a = (unsigned long long)tickTime * (unsigned long long)m_Tempo;
	b = (unsigned long long)1000 * (unsigned long long)m_TimeDivision;
	c = a / b;
	timeMsec = (unsigned long)c;

	return timeMsec;
}

//******************************************************************************
// ԁi~bj`bN^Cւ̕ϊ
//******************************************************************************
unsigned long SMSequencer::_ConvTimeMsec2Tick(
		unsigned long timeMsec
	)
{
	unsigned long tickTime = 0;
	unsigned long long a = 0;
	unsigned long long b = 0;

	a = (unsigned long long)timeMsec * (unsigned long long)m_TimeDivision * 1000;
	b = a / (unsigned long long)m_Tempo;
	tickTime = (unsigned long)b;

	return tickTime;
}

//******************************************************************************
// CxgM
//******************************************************************************
int SMSequencer::_OutputMIDIEvent(
		unsigned char portNo,
		SMEvent* pEvent
	)
{
	int result = 0;
	UINT apiresult = 0;
	HMIDIOUT hMidiOut = NULL;

	//MIDICxgM
	if (pEvent->GetType() == SMEvent::EventMIDI) {
		SMEventMIDI eventMIDI;
		eventMIDI.Attach(pEvent);
		result = _SendMIDIEvent(portNo, &eventMIDI);
		if (result != 0) goto EXIT;
	}
	//SysExCxgM
	else if (pEvent->GetType() == SMEvent::EventSysEx) {
		SMEventSysEx eventSysEx;
		eventSysEx.Attach(pEvent);
		result = _SendSysExEvent(portNo, &eventSysEx);
		if (result != 0) goto EXIT;
	}
	//^CxgM
	else if (pEvent->GetType() == SMEvent::EventMeta) {
		SMEventMeta eventMeta;
		eventMeta.Attach(pEvent);
		result = _SendMetaEvent(portNo, &eventMeta);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgM
//******************************************************************************
int SMSequencer::_SendMIDIEvent(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	int result = 0;
	UINT apiresult = 0;
	unsigned long msg = 0;

	//bZ[W擾
	result = pMIDIEvent->GetMIDIOutShortMsg(&msg);
	if (result != 0) goto EXIT;

	//bZ[WóFo͊܂Ő䂪߂Ȃ
	result = m_OutDevCtrl.SendShortMsg(portNo, msg);
	if (result != 0) goto EXIT;

	//m[gOFFʒm
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOff) {
		m_MsgTrans.PostNoteOff(
				portNo,
				pMIDIEvent->GetChNo(),
				pMIDIEvent->GetNoteNo()
			);
	}

	//m[gONʒm
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOn) {
		m_MsgTrans.PostNoteOn(
				portNo,
				pMIDIEvent->GetChNo(),
				pMIDIEvent->GetNoteNo(),
				pMIDIEvent->GetVelocity()
			);
	}

EXIT:;
	return result;
}

//******************************************************************************
// SysExCxgM
//******************************************************************************
int SMSequencer::_SendSysExEvent(
		unsigned char portNo,
		SMEventSysEx* pSysExEvent
	)
{
	int result = 0;
	unsigned char* pVarMsg = NULL;
	unsigned long size = 0;

	//bZ[W擾
	pSysExEvent->GetMIDIOutLongMsg(&pVarMsg, &size);

	//bZ[WóFo͊܂Ő䂪߂Ȃ
	result = m_OutDevCtrl.SendLongMsg(portNo, pVarMsg, size);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}
//******************************************************************************
// ^CxgM
//******************************************************************************
int SMSequencer::_SendMetaEvent(
		unsigned char portNo,
		SMEventMeta* pMetaEvent
	)
{
	int result = 0;

	//^CxgMIDIfoCXɑMȂ

	//e|
	if (pMetaEvent->GetType() == 0x51) {
		//f^^CvZɔf
		m_Tempo = pMetaEvent->GetTempo();
		if (m_Tempo == 0) {
			//f[^ُ
			result = YN_SET_ERR("Invalid data found.", 0, 0);
			goto EXIT;
		}

		//ʒm
		m_MsgTrans.PostTempo(m_Tempo);
	}
	
	//qL
	if (pMetaEvent->GetType() == 0x58) {
		//q擾
		unsigned long numerator = 0;
		unsigned long denominator = 0;
		pMetaEvent->GetTimeSignature(&numerator, &denominator);
		if (denominator == 0) {
			//f[^ُ
			result = YN_SET_ERR("Invalid data found.", numerator, denominator);
			goto EXIT;
		}
		
		//ʒm
		m_MsgTrans.PostBeat((unsigned short)numerator, (unsigned short)denominator);
		
		//1߂̃`bN^CXV
		m_TickTimeOfBar = (numerator * m_TimeDivision * 4) / denominator;
		
		//qLXV̂1ߖڊJnn_ƂĒʒm
		if (m_PrevBarTickTime != m_TotalTickTime) {
			m_CurBarNo++;
			m_PrevBarTickTime = m_TotalTickTime;
			m_MsgTrans.PostBar(m_CurBarNo);
		}
	}

EXIT:;
	return result;
}

//******************************************************************************
// [Uv
//******************************************************************************
int SMSequencer::_ProcUserRequest()
{
	int result = 0;

	//^C}[~
	timeKillEvent(m_TimerID);
	m_TimerID = NULL;

	//SgbNm[gIt
	result = _AllTrackNoteOff();
	if (result != 0) goto EXIT;

	//ꎞ~vꂽꍇ
	if (m_UserRequest == RequestPause) {
		m_Status = StatusPause;
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_PAUSE);
	}

	//~vꂽꍇ
	if (m_UserRequest == RequestStop) {
		m_Status = StatusStop;
		m_MsgTrans.PostPlayStatus(SM_PLAYSTATUS_STOP);
	}

	m_UserRequest = RequestNone;

EXIT:;
	return result;
}

//******************************************************************************
// SgbNm[gIt
//******************************************************************************
int SMSequencer::_AllTrackNoteOff()
{
	int result = 0;

	result = m_OutDevCtrl.NoteOffAll();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ^C}[R[obN֐
//******************************************************************************
void SMSequencer::_TimerCallBack(
		UINT uTimerID,
		UINT uMsg,
		DWORD_PTR dwUser,
		DWORD_PTR dw1,
		DWORD_PTR dw2
	)
{
	int result = 0;

	SMSequencer* pSequencer = (SMSequencer*)dwUser;
	if (pSequencer == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	result = pSequencer->_OnTimer();
	if (result != 0) goto EXIT;

EXIT:;
	if (result != 0) YN_SHOW_ERR(NULL);
	return;
}

} // end of namespace

