//******************************************************************************
//
// Simple MIDI Library / SMNoteList
//
// m[gXgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMNoteList.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMNoteList::SMNoteList(void)
 : m_List(sizeof(SMNote), 1000)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMNoteList::~SMNoteList(void)
{
	Clear();
}

//******************************************************************************
// NA
//******************************************************************************
void SMNoteList::Clear(void)
{
	m_List.Clear();
}

//******************************************************************************
// m[gǉ
//******************************************************************************
int SMNoteList::AddNote(
		SMNote note
	)
{
	return m_List.AddItem(&note);
}

//******************************************************************************
// m[g擾
//******************************************************************************
int SMNoteList::GetNote(
		unsigned long index,
		SMNote* pNote
	)
{
	return m_List.GetItem(index, pNote);
}

//******************************************************************************
// m[g擾
//******************************************************************************
unsigned long SMNoteList::GetSize()
{
	return m_List.GetSize();
}

//******************************************************************************
// XgRs[
//******************************************************************************
int SMNoteList::CopyFrom(
		SMNoteList* pSrcList
	)
{
	return m_List.CopyFrom(&(pSrcList->m_List));
}

} // end of namespace

