//******************************************************************************
//
// MIDITrail / MTWindowSizeCfgDlg
//
// EBhETCYݒ_CAONX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "MTParam.h"
#include "MTWindowSizeCfgDlg.h"
#include <string>
#include <map>


//******************************************************************************
// EBhEvV[Wpp[^ݒ
//******************************************************************************
MTWindowSizeCfgDlg* MTWindowSizeCfgDlg::m_pThis = NULL;

//******************************************************************************
// RXgN^
//******************************************************************************
MTWindowSizeCfgDlg::MTWindowSizeCfgDlg(void)
{
	m_pThis = this;
	m_isSaved = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTWindowSizeCfgDlg::~MTWindowSizeCfgDlg(void)
{
}

//******************************************************************************
// EBhEvV[W
//******************************************************************************
INT_PTR CALLBACK MTWindowSizeCfgDlg::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	return m_pThis->_WndProcImpl(hWnd, message, wParam, lParam);
}

//******************************************************************************
// EBhEvV[WF
//******************************************************************************
INT_PTR MTWindowSizeCfgDlg::_WndProcImpl(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam
	)
{
	int result = 0;
	BOOL bresult = FALSE;

	UNREFERENCED_PARAMETER(lParam);

	switch (message) {
		case WM_INITDIALOG:
			result = _OnInitDlg(hDlg);
			if (result != 0) goto EXIT;
			bresult = TRUE;
			break;
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				m_isSaved = true;
				result = _Save();
				if (result != 0) goto EXIT;
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			else if (LOWORD(wParam) == IDCANCEL) {
				EndDialog(hDlg, LOWORD(wParam));
				bresult = TRUE;
			}
			break;
	}

EXIT:;
	if (result != 0) {
		YN_SHOW_ERR(hDlg);
	}
	return (INT_PTR)bresult;
}

//******************************************************************************
// \
//******************************************************************************
int MTWindowSizeCfgDlg::Show(
		HWND hParentWnd
	)
{
	int result = 0;
	INT_PTR dresult = 0;
	HINSTANCE hInstance = NULL;

	m_isSaved = false;

	//AvP[VCX^Xnh擾
	hInstance = (HINSTANCE)GetWindowLongPtr(hParentWnd, GWLP_HINSTANCE);
	if (hInstance == NULL) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hParentWnd);
		goto EXIT;
	}

	//_CAO\
	dresult = DialogBox(
					hInstance,							//CX^Xnh
					MAKEINTRESOURCE(IDD_WINDOWSIZE_CFG),//_CAO{bNXev[g
					hParentWnd,							//eEBhEnh
					_WndProc							//_CAO{bNXvV[W
				);
	if ((dresult == 0) || (dresult == -1)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)hInstance);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// ύXmF
//******************************************************************************
bool MTWindowSizeCfgDlg::IsCahnged()
{
	//{͒l̕ωmFׂ
	return m_isSaved;
}

//******************************************************************************
// _CAO\O
//******************************************************************************
int MTWindowSizeCfgDlg::_OnInitDlg(
		HWND hDlg
	)
{
	int result = 0;

	//ݒt@C
	result = _InitConfFile();
	if (result != 0) goto EXIT;

	//EBhETCYIR{{bNX
	m_hSizeList = GetDlgItem(hDlg, IDC_WINDOWSIZE_LIST);
	result = _InitSizeList();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ݒt@C
//******************************************************************************
int MTWindowSizeCfgDlg::_InitConfFile()
{
	int result = 0;
	TCHAR userConfFilePath[_MAX_PATH] = {_T('\0')};

	result = YNPathUtil::GetAppDataDirPath(userConfFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_DIR);
	_tcscat_s(userConfFilePath, _MAX_PATH, MT_USER_CONFFILE_VIEW);

	result = m_ConfFile.Initialize(userConfFilePath);
	if (result != 0) goto EXIT;

	result = m_ConfFile.SetCurSection(_T("WindowSize"));
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// EBhETCYIXg{bNX
//******************************************************************************
int MTWindowSizeCfgDlg::_InitSizeList()
{
	int result = 0;
	LRESULT lresult = 0;
	BOOL bresult = FALSE;
	unsigned long index = 0;
	int selectedIndex = -1;
	int curWidth = 0;
	int curHeight = 0;
	DEVMODE devMode;
	TCHAR caption[64];
	MTWindowSizeItem item;
	MTWindowSizeList::iterator itr;
	bool isExist = false;

	//[UIEBhETCY擾
	result = m_ConfFile.GetInt(_T("Width"), &curWidth, 0);
	if (result != 0) goto EXIT;
	result = m_ConfFile.GetInt(_T("Height"), &curHeight, 0);
	if (result != 0) goto EXIT;

	m_SizeList.clear();

	for (index = 0; ; index++) {

		//OtBbNX[h擾
		bresult = EnumDisplaySettings(
						NULL,		//擾ΏۃfBXvCfoCX
						index,		//OtBbN[hCfbNX
						&devMode	//擾OtBbNX[h
					);
		if (!bresult) {
			//[hꗗ擾
			break;
		}

		//rbg[x32bitȊO͖
		if (devMode.dmBitsPerPel != 32) {
			continue;
		}

		//łɃXgo^ς݂mF
		isExist = false;
		for (itr = m_SizeList.begin(); itr != m_SizeList.end(); itr++) {
			if ((itr->width == devMode.dmPelsWidth)
			 && (itr->height == devMode.dmPelsHeight)) {
				isExist = true;
				break;
			}
		}

		//Xgo^
		if (!isExist) {
			item.width = devMode.dmPelsWidth;
			item.height = devMode.dmPelsHeight;
			m_SizeList.push_back(item);
			
			//LvV쐬
			_stprintf_s(caption, 64, _T("%d x %d  32bit"), item.width, item.height);

			//EBhETCYXg{bNXɒǉ
			lresult = SendMessage(m_hSizeList, LB_ADDSTRING, 0, (LPARAM)caption);
			if ((lresult == LB_ERR) || (lresult == LB_ERRSPACE)) {
				result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)m_hSizeList);
				goto EXIT;
			}

			if ((item.width == curWidth) && (item.height == curHeight)) {
				selectedIndex = m_SizeList.size() - 1;
			}
		}
	}

	//ꗗɑOݒlȂꍇ̓Xg̐擪IԂƂ
	if (selectedIndex < 0) {
		selectedIndex = 0;
	}

	//IԐݒ
	lresult = SendMessage(m_hSizeList, LB_SETCURSEL, selectedIndex, 0);
	if (lresult == LB_ERR) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), selectedIndex);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// foCXIۑ
//******************************************************************************
int MTWindowSizeCfgDlg::_Save()
{
	int result = 0;
	LRESULT lresult = 0;
	int selectedIndex = 0;
	MTWindowSizeItem item;
	MTWindowSizeList::iterator itr;

	//Iڂ̃CfbNX擾
	lresult = SendMessage(m_hSizeList, LB_GETCURSEL, 0, 0);
	if ((lresult == LB_ERR) || (lresult < 0)) {
		result = YN_SET_ERR("Windows API error.", GetLastError(), (DWORD)m_hSizeList);
		goto EXIT;
	}
	selectedIndex = lresult;

	itr = m_SizeList.begin();
	advance(itr, selectedIndex);
	item = *itr;

	//ݒۑ
	result = m_ConfFile.SetInt(_T("Width"), item.width);
	if (result != 0) goto EXIT;
	result = m_ConfFile.SetInt(_T("Height"), item.height);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

