//******************************************************************************
//
// MIDITrail / MTNoteRipple
//
// m[gg`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//őg`搔
#define MTNOTERIPPLE_MAX_NOTE_NUM  (100)


//******************************************************************************
// m[gg`NX
//******************************************************************************
class MTNoteRipple
{
public:

	//RXgN^^fXgN^
	MTNoteRipple(void);
	virtual ~MTNoteRipple(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, SMSeqData* pSeqData);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//m[gOFFo^
	void SetNoteOff(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo
		);

	//m[gONo^
	void SetNoteOn(
			unsigned char portNo,
			unsigned char chNo,
			unsigned char noteNo,
			unsigned char velocity
		);

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

private:

	//m[gԍ\
	struct NoteStatus {
		bool isActive;
		unsigned char portNo;
		unsigned char chNo;
		unsigned char noteNo;
		unsigned char velocity;
		unsigned long regTime;
	};

	//_obt@\
	struct MTNOTERIPPLE_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD		c;	//fBt[YF
		D3DXVECTOR2 t;	//eNX`摜ʒu
	};

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1); }

private:

	DXPrimitive m_Primitive;
	LPDIRECT3DTEXTURE9 m_pTexture;
	D3DMATERIAL9 m_Material;
	unsigned long m_CurTickTime;
	D3DXVECTOR3 m_CamVector;
	MTNoteDesign m_NoteDesign;

	NoteStatus* m_pNoteStatus;
	MTNOTERIPPLE_VERTEX* m_pVertex;

	int _CreateTexture(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateNoteStatus();
	int _CreateVertex(LPDIRECT3DDEVICE9 pD3DDevice);
	int _SetVertexPosition(MTNOTERIPPLE_VERTEX* pVertex, NoteStatus* pNoteStatus);
	void _MakeMaterial(D3DMATERIAL9* pMaterial);

};


