//******************************************************************************
//
// MIDITrail / MTNoteRipple
//
// m[gg`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// ̔g̈ʒuƃTCYʂɕω邽߁A
// _obt@̎gp߂B
// g͕`搔݂̏DrawPrimitiveUPŕ`悷B

#include "StdAfx.h"
#include "MTParam.h"
#include "YNBaseLib.h"
#include "MTNoteRipple.h"
#include <new>

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteRipple::MTNoteRipple(void)
{
	m_pTexture = NULL;
	m_pNoteStatus = NULL;
	m_pVertex = NULL;
	m_CurTickTime = 0;
	m_CamVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	ZeroMemory(&m_Material, sizeof(D3DMATERIAL9));
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteRipple::~MTNoteRipple(void)
{
	Release();
}

//******************************************************************************
// m[gg䐶
//******************************************************************************
int MTNoteRipple::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
   )
{
	int result = 0;

	Release();

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSeqData);
	if (result != 0) goto EXIT;

	//eNX`
	result = _CreateTexture(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;

	//_
	result = _CreateVertex(pD3DDevice);
	if (result != 0) goto EXIT;

	//}eA쐬
	_MakeMaterial(&m_Material);

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTNoteRipple::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector
	)
{
	int result = 0;
	D3DXMATRIX worldMatrix;

	m_CamVector = camVector;

	//ړȂ
	D3DXMatrixIdentity(&worldMatrix);
	m_Primitive.Transform(worldMatrix);

	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteRipple::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
   )
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	MTNOTERIPPLE_VERTEX* pVertex = NULL;
	D3DXMATRIX mtxWorld;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	if (m_pVertex == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	unsigned long i = 0;
	unsigned long activeNoteNum = 0;

	//m[g̔gɂĒ_XV
	for (i = 0; i < MTNOTERIPPLE_MAX_NOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			m_pNoteStatus[i].regTime -= 1;
			if (m_pNoteStatus[i].regTime == 0) {
				//Ԑ؂
				m_pNoteStatus[i].isActive = false;
			}
			else {
				//_XVFg̕`ʒuƃTCYς
			 	_SetVertexPosition(&(m_pVertex[activeNoteNum*6]), &(m_pNoteStatus[i]));
			 	activeNoteNum++;
		 	}
		}
	}

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;

	memcpy(pVertex, m_pVertex, sizeof(MTNOTERIPPLE_VERTEX)*6*activeNoteNum);

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;

	//eNX`Xe[Wݒ
	//  J[ZFZ  1FeNX`  2F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_MODULATE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	// At@ZF1gp  1F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	if (activeNoteNum > 0) {
		//v~eBu`
		//obt@ŜłȂg̐ɍ킹ĕ`悷v~eBu炷
		result = m_Primitive.Draw(pD3DDevice, m_pTexture, 2 * activeNoteNum);
		if (result != 0) goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteRipple::Release()
{
	m_Primitive.Release();

	if (m_pTexture != NULL) {
		m_pTexture->Release();
		m_pTexture = NULL;
	}

	delete [] m_pNoteStatus;
	m_pNoteStatus = NULL;

	delete [] m_pVertex;
	m_pVertex = NULL;
}

//******************************************************************************
// eNX`
//******************************************************************************
int MTNoteRipple::_CreateTexture(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	TCHAR imgFilePath[_MAX_PATH] = {_T('\0')};
	TCHAR bmpFileName[_MAX_PATH] = {_T('\0')};
	TCHAR confFilePath[_MAX_PATH] = {_T('\0')};
	YNConfFile confFile;

	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(confFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	//ݒt@CpXo^
	_tcscat_s(confFilePath, _MAX_PATH, MT_CONFFILE_PIANOROLL3D);
	result = confFile.Initialize(confFilePath);
	if (result != 0) goto EXIT;

	//rbg}bvt@C
	result = confFile.SetCurSection(_T("Bitmap"));
	if (result != 0) goto EXIT;
	result = confFile.GetStr(_T("Ripple"), bmpFileName, _MAX_PATH, MT_IMGFILE_RIPPLE);
	if (result != 0) goto EXIT;

	//vZXst@CfBNgpX擾
	result = YNPathUtil::GetModuleDirPath(imgFilePath, _MAX_PATH);
	if (result != 0) goto EXIT;

	//摜t@CpX
	_tcscat_s(imgFilePath, _MAX_PATH, bmpFileName);

	hresult = D3DXCreateTextureFromFileEx(
					pD3DDevice,			//foCX
					imgFilePath,		//t@CpX
					0,					//Ft@C擾
					0,					//Ft@C擾
					0,					//~bvx
					0,					//gp@
					D3DFMT_A8R8G8B8,	//sNZtH[}bg
					D3DPOOL_MANAGED,	//eNX`zu惁NX
					D3DX_FILTER_LINEAR,	//tB^Ow
					D3DX_FILTER_LINEAR,	//tB^Owi~bvj
					0xFF000000,			//F̎wFs
					NULL,				//\[XC[W
					NULL,				//256pbg
					&m_pTexture			//쐬eNX`IuWFNg
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTNoteRipple::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;

	//_
	try {
		m_pNoteStatus = new NoteStatus[MTNOTERIPPLE_MAX_NOTE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	ZeroMemory(m_pNoteStatus, sizeof(NoteStatus) * MTNOTERIPPLE_MAX_NOTE_NUM);

	for (i = 0; i < MTNOTERIPPLE_MAX_NOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
	}

EXIT:;
	return result;
}

//******************************************************************************
// _
//******************************************************************************
int MTNoteRipple::_CreateVertex(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long vertexNum = 0;
	MTNOTERIPPLE_VERTEX* pVertex = NULL;

	//_
	try {
		m_pVertex = new MTNOTERIPPLE_VERTEX[6*MTNOTERIPPLE_MAX_NOTE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	ZeroMemory(m_pVertex, sizeof(MTNOTERIPPLE_VERTEX) * 6 * MTNOTERIPPLE_MAX_NOTE_NUM);

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTNOTERIPPLE_VERTEX),//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 6 * MTNOTERIPPLE_MAX_NOTE_NUM;
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//_f[^o^
	result = m_Primitive.SetAllVertex(pD3DDevice, m_pVertex);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// _̍Wݒ
//******************************************************************************
int MTNoteRipple::_SetVertexPosition(
		MTNOTERIPPLE_VERTEX* pVertex,
		NoteStatus* pNoteStatus
	)
{
	int result = 0;
	unsigned long i = 0;
	float rh, rw = 0.0f;
	float magRate = 0.0f;
	float alpha = 0.0f;
	D3DXVECTOR3 center;
	D3DXCOLOR color;

	//m[g{bNXSW擾
	center = m_NoteDesign.GetNoteBoxCenterPosX(
					m_CurTickTime,
					pNoteStatus->portNo,
					pNoteStatus->chNo,
					pNoteStatus->noteNo
				);

	//g嗦FXɌ
	magRate = (float)(pNoteStatus->regTime) / 100.0f;
	//g嗦FXɊg
	//float magRate = (150.0f - (float)(pNoteStatus->regTime)) / 100.0f;

	//gTCY
	rh = m_NoteDesign.GetRippleHeight() * magRate;
	rw = m_NoteDesign.GetRippleWidth() * magRate;

	//gĐʏォJɏĕ`悷
	//  gĐʏɒڔzuZt@CeBOɂ
	//  ĕ`悳邱Ƃ
	//  OtBbNJ[hɂČۂقȂ
	if (center.x < m_CamVector.x) {
		center.x += +0.01f;
	}
	else {
		center.x += -0.01f;
	}

	//_W
	pVertex[0].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z+(rw/2.0f));
	pVertex[1].p = D3DXVECTOR3(center.x, center.y+(rh/2.0f), center.z-(rw/2.0f));
	pVertex[2].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z+(rw/2.0f));
	pVertex[3].p = pVertex[2].p;
	pVertex[4].p = pVertex[1].p;
	pVertex[5].p = D3DXVECTOR3(center.x, center.y-(rh/2.0f), center.z-(rw/2.0f));

	//@
	for (i = 0; i < 6; i++) {
		pVertex[i].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	}

	//xXɗƂ
	alpha = (float)(pNoteStatus->regTime) / 100.0f;

	//e_̃fBt[YF
	for (i = 0; i < 6; i++) {
		color = m_NoteDesign.GetNoteBoxColor(
								pNoteStatus->portNo,
								pNoteStatus->chNo,
								pNoteStatus->noteNo
							);
		pVertex[i].c = D3DXCOLOR(color.r, color.g, color.b, alpha);
	}

	//eNX`W
	pVertex[0].t = D3DXVECTOR2(0.0f, 0.0f);
	pVertex[1].t = D3DXVECTOR2(1.0f, 0.0f);
	pVertex[2].t = D3DXVECTOR2(0.0f, 1.0f);
	pVertex[3].t = pVertex[2].t;
	pVertex[4].t = pVertex[1].t;
	pVertex[5].t = D3DXVECTOR2(1.0f, 1.0f);

	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteRipple::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	ZeroMemory(pMaterial, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 10.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

//******************************************************************************
// m[gOFFo^
//******************************************************************************
void MTNoteRipple::SetNoteOff(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo
	)
{
	unsigned long i = 0;

	//Ỹm[g𖳌
	for (i = 0; i < MTNOTERIPPLE_MAX_NOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive)
		 && (m_pNoteStatus[i].portNo == portNo)
		 && (m_pNoteStatus[i].chNo == chNo)
		 && (m_pNoteStatus[i].noteNo == noteNo)) {
			m_pNoteStatus[i].isActive = false;
			break;
		}
	}

	return;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTNoteRipple::SetNoteOn(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		unsigned char velocity
	)
{
	unsigned long i = 0;

	//󂫃Xy[XɃm[go^
	//󂫂ȂΔg̕\͂߂
	for (i = 0; i < MTNOTERIPPLE_MAX_NOTE_NUM; i++) {
		if (!(m_pNoteStatus[i].isActive)) {
			m_pNoteStatus[i].isActive = true;
		 	m_pNoteStatus[i].portNo = portNo;
		 	m_pNoteStatus[i].chNo = chNo;
		 	m_pNoteStatus[i].noteNo = noteNo;
		 	m_pNoteStatus[i].velocity = velocity;
		 	m_pNoteStatus[i].regTime = 100;
			break;
		}
	}

	return;
}

//******************************************************************************
// Jg`bN^Cݒ
//******************************************************************************
void MTNoteRipple::SetCurTickTime(
		unsigned long curTickTime
	)
{
	m_CurTickTime = curTickTime;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTNoteRipple::Reset()
{
	unsigned long i = 0;

	m_CurTickTime = 0;

	for (i = 0; i < MTNOTERIPPLE_MAX_NOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
	}

	return;
}

