/* $Id: trac0.9.x-schema.sql 4 2007-06-28 13:26:57Z whitestar $ */

/* dummy trac wiki table */
drop table if exists wiki;
create table wiki(
    name varchar(255) NOT NULL,
    version int NOT NULL,
    time int NOT NULL,
    author varchar(64),
    ipnr varchar(64),
    text text,
    comment text,
    readonly int NOT NULL,
    constraint wiki_pk primary key (
        name,
        version
      )
) engine=InnoDB;

/* dummy trac ticket table */
drop table if exists ticket;
create table ticket(
    id int primary key,
    type varchar(64),
    time int NOT NULL,
    changetime int NOT NULL,
    component varchar(64),
    severity varchar(64),
    priority varchar(64),
    owner varchar(64),
    reporter varchar(64),
    cc varchar(64),
    version varchar(64),
    milestone varchar(64),
    status varchar(64),
    resolution varchar(64),
    summary varchar(255),
    description text,
    keywords varchar(255)
) engine=InnoDB;

/* dummy trac ticket change table */
drop table if exists ticket_change;
create table ticket_change(
    ticket int NOT NULL,
    time int NOT NULL,
    field varchar(64),
    author varchar(64),
    oldvalue text,
    newvalue text,
    constraint ticket_change_pk primary key (
        ticket,
        time,
        field
      )
) engine=InnoDB;

/* dummy trac revision table */
drop table if exists revision;
create table revision(
    rev varchar(64) primary key,
    time int NOT NULL,
    author varchar(64),
    message text
) engine=InnoDB;

/* dummy trac node_change table */
drop table if exists node_change;
create table node_change (
    rev varchar(64) NOT NULL,
    path varchar(255) NOT NULL,
    `change` varchar(255),
    kind varchar(64),
    base_path text,
    base_rev varchar(64),
    constraint node_change_pk primary key (
        rev,
        path,
        `change`
      )
) engine=InnoDB;
