/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.metasearch.ws;

import java.rmi.RemoteException;
import jp.sourceforge.metasearch.compass.IndexSearcher;
import jp.sourceforge.metasearch.compass.SearchFailedException;
import jp.sourceforge.metasearch.compass.SearchResult;
import jp.sourceforge.metasearch.ws.Result;
import jp.sourceforge.metasearch.ws.SearchWebService;
import org.springframework.remoting.jaxrpc.ServletEndpointSupport;

public class SearchServiceEndpoint
extends ServletEndpointSupport
implements SearchWebService {
    private IndexSearcher indexSearcher = null;

    protected void onInit() {
        this.indexSearcher = (IndexSearcher)this.getWebApplicationContext().getBean("indexSearcher");
    }

    public String getVersion() throws RemoteException {
        return "0.9.0";
    }

    public Result find(String query) throws SearchFailedException, RemoteException {
        return this.seek(query, 10, 0);
    }

    public Result seek(String query, int num, int start) throws SearchFailedException, RemoteException {
        return this.refineSearch(query, null, num, start);
    }

    public Result refineSearch(String query, String currentQuery, int num, int start) throws SearchFailedException, RemoteException {
        try {
            SearchResult searchResult = this.indexSearcher.find(query, currentQuery, num, start);
            return new Result(searchResult);
        }
        catch (SearchFailedException sfe) {
            throw sfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }
}

