/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.metasearch.compass.gps.device.fs;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.oro.io.Perl5FilenameFilter;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractGpsDevice;

public abstract class AbstractFileGpsDevice
extends AbstractGpsDevice {
    private String directory;
    private String filenamePattern;

    public AbstractFileGpsDevice() {
    }

    public AbstractFileGpsDevice(String deviceName, String directory, String filenamePattern) {
        this.setName(deviceName);
        this.directory = directory;
        this.filenamePattern = filenamePattern;
    }

    protected void doStart() throws CompassGpsException {
        if (this.directory == null || this.directory.equals("")) {
            throw new IllegalArgumentException(this.buildMessage("Must set directory property"));
        }
        if (this.filenamePattern == null || this.filenamePattern.equals("")) {
            throw new IllegalArgumentException(this.buildMessage("Must set filenamePattern property"));
        }
    }

    protected File[] getFiles() {
        File dir = new File(this.getDirectory());
        Perl5FilenameFilter filenameFilter = new Perl5FilenameFilter(this.getFilenamePattern());
        return dir.listFiles((FilenameFilter)filenameFilter);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }
}

