/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.metasearch.compass.entity;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import jp.sourceforge.metasearch.compass.entity.GenericTextFileEntity;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.oro.text.perl.Perl5Util;

public abstract class PukiWikiBean
extends GenericTextFileEntity {
    private String pageNameEncodingCharset = "EUC-JP";

    public void buildIdentifier() {
        try {
            this.setIdentifier(String.valueOf(this.getResourceContext()) + URLEncoder.encode(this.getTitle(), this.pageNameEncodingCharset));
        }
        catch (UnsupportedEncodingException e) {
            this.setIdentifier(null);
            e.printStackTrace();
        }
    }

    public void loadFile(File file, String encoding, int maxSize) {
        super.loadFile(file, encoding, maxSize);
        try {
            Perl5Util perl = new Perl5Util();
            boolean match = perl.match("/^(.*)(\\.txt)$/", this.getTitle());
            if (match) {
                byte[] title = Hex.decodeHex((char[])perl.group(1).toCharArray());
                this.setTitle(new String(title, this.pageNameEncodingCharset));
            }
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getPageNameEncodingCharset() {
        return this.pageNameEncodingCharset;
    }

    public void setPageNameEncodingCharset(String pageNameEncodingCharset) {
        this.pageNameEncodingCharset = pageNameEncodingCharset;
    }

    public String toString() {
        String str = new ToStringBuilder((Object)this).append("page name encoding charset", (Object)this.pageNameEncodingCharset).toString();
        str = String.valueOf(str) + " < " + super.toString();
        return str;
    }
}

