/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.metasearch.compass;

import jp.sourceforge.metasearch.compass.CompassContext;
import jp.sourceforge.metasearch.compass.IndexReadFailedException;
import jp.sourceforge.metasearch.compass.IndexStatisticsInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.lucene.util.LuceneHelper;

public class IndexReader {
    private CompassContext context = null;

    public CompassContext getContext() {
        return this.context;
    }

    public void setContext(CompassContext context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexStatisticsInfo getStatisticsInfo() throws IndexReadFailedException {
        IndexStatisticsInfo indexStatisticsInfo;
        CompassSession session = null;
        CompassTransaction tx = null;
        IndexStatisticsInfo statisticsInfo = new IndexStatisticsInfo();
        try {
            try {
                session = this.context.getCompass().openSession();
                tx = session.beginTransaction(CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED);
                org.apache.lucene.index.IndexReader luceneIndexReader = LuceneHelper.getLuceneInternalSearch((CompassSession)session).getReader();
                statisticsInfo.setFieldNames(luceneIndexReader.getFieldNames(IndexReader.FieldOption.INDEXED));
                statisticsInfo.setNumDocs(luceneIndexReader.numDocs());
                statisticsInfo.setVersion(org.apache.lucene.index.IndexReader.getCurrentVersion((Directory)luceneIndexReader.directory()));
                tx.commit();
                indexStatisticsInfo = statisticsInfo;
                Object var5_8 = null;
                if (session == null) return indexStatisticsInfo;
            }
            catch (CompassException ce) {
                if (tx != null) {
                    tx.rollback();
                }
                ce.printStackTrace();
                throw new IndexReadFailedException(ce);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IndexReadFailedException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (session == null) throw throwable;
            session.close();
            throw throwable;
        }
        session.close();
        return indexStatisticsInfo;
    }
}

