/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.metasearch.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.metasearch.compass.DistributedIndexSearcher;
import jp.sourceforge.metasearch.compass.SearchFailedException;
import jp.sourceforge.metasearch.compass.SearchResult;
import jp.sourceforge.metasearch.compass.util.ResultListDefaultComparator;
import jp.sourceforge.metasearch.form.SearchActionForm;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.ActionSupport;

public class DistributedSearchAction
extends ActionSupport {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchActionForm form = (SearchActionForm)actionForm;
        String query = form.getQuery();
        int num = form.getNum();
        SearchResult result = null;
        SearchResult[] results = null;
        try {
            try {
                DistributedIndexSearcher searcher = (DistributedIndexSearcher)this.getWebApplicationContext().getBean("distributedIndexSearcher");
                results = searcher.find(query, num, 0);
                result = this.mergeResults(results, query, num);
            }
            catch (SearchFailedException sfe) {
                sfe.printStackTrace();
                request.setAttribute("errorMessage", (Object)sfe.getMessage());
                result = new SearchResult();
                result.setQuery(query);
                result.setNum(num);
                result.setStart(0);
                ActionForward actionForward = mapping.findForward("failure");
                Object var11_13 = null;
                request.setAttribute("results", (Object)results);
                request.setAttribute("result", (Object)result);
                return actionForward;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            request.setAttribute("results", (Object)results);
            request.setAttribute("result", result);
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        request.setAttribute("results", (Object)results);
        request.setAttribute("result", (Object)result);
        return mapping.findForward("distributedSearchResult");
    }

    protected SearchResult mergeResults(SearchResult[] results, String query, int num) {
        int totalNum = 0;
        long searchTime = 0L;
        SearchResult result = new SearchResult();
        List allList = new ArrayList();
        int i = 0;
        while (i < results.length) {
            if (results[i] != null) {
                result.setCurrentQuery(results[i].getCurrentQuery());
                totalNum += results[i].getTotalNum();
                searchTime += results[i].getSearchTime();
                allList.addAll(results[i].getList());
            }
            ++i;
        }
        result.setQuery(query);
        result.setNum(num);
        result.setStart(0);
        result.setTotalNum(totalNum);
        result.setSearchTime(searchTime);
        Collections.sort(allList, new ResultListDefaultComparator());
        Collections.reverse(allList);
        if (allList.size() > num) {
            allList = allList.subList(0, num);
        }
        result.setList(allList);
        return result;
    }
}

