/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CacheFiles;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CallHierarchyExplorer;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TraceableTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.UnderscoreMnemonicDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.util.CachePropertySet;
import jp.sourceforge.mergedoc.pleiades.aspect.util.ValueHashPropertySet;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public class DynamicTranslationDictionary
extends AbstractTranslationDictionary {
    private static final Logger log = Logger.getLogger(DynamicTranslationDictionary.class);
    private static final File transCacheFile = Pleiades.getResourceFile(CacheFiles.TRANS_CACHE_PROP);
    private static final File mnemonicCacheFile = Pleiades.getResourceFile(CacheFiles.MNEMONIC_CACHE_PROP);
    private static DynamicTranslationDictionary instance;
    protected static PleiadesOption pleiadesOption;
    private CachePropertySet transCacheProp;
    private CachePropertySet mnemonicCacheProp;
    private CallHierarchyExplorer callHierarchy = CallHierarchyExplorer.getInstance();

    static {
        pleiadesOption = Pleiades.getPleiadesOption();
    }

    public static DynamicTranslationDictionary getInstance() {
        TraceableTranslationDictionary tracer;
        if (instance != null) {
            return instance;
        }
        if (log.isDebugEnabled() && (tracer = TraceableTranslationDictionary.getInstance()) != null) {
            instance = tracer;
        }
        if (instance == null) {
            instance = DynamicTranslationDictionary.pleiadesOption.isUnderscoreMnemonic ? new UnderscoreMnemonicDictionary() : new DynamicTranslationDictionary();
        }
        return instance;
    }

    protected DynamicTranslationDictionary() {
    }

    protected boolean load() {
        this.transCacheProp = new ValueHashPropertySet("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        this.mnemonicCacheProp = new CachePropertySet("\u30cb\u30fc\u30e2\u30cb\u30c3\u30af\u5909\u63db\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        if (!transCacheFile.exists()) {
            super.load();
            this.transCacheProp.load(DynamicTranslationDictionary.validateExists("translation-multibytes-key.properties"));
        } else {
            try {
                this.transCacheProp.load(transCacheFile);
                this.mnemonicCacheProp.load(mnemonicCacheFile);
            }
            catch (RuntimeException e) {
                log.warn("\u7ffb\u8a33\u30ad\u30e3\u30c3\u30b7\u30e5 %s \u306e\u7834\u640d\u3092\u691c\u51fa\u3002\u5fa9\u5143\u4e2d... - %s", transCacheFile, e.toString());
                transCacheFile.delete();
                this.transCacheProp.clear();
                this.transCacheProp.load(DynamicTranslationDictionary.validateExists("translation-multibytes-key.properties"));
                mnemonicCacheFile.delete();
                this.mnemonicCacheProp.clear();
            }
        }
        return true;
    }

    public void shutdown() {
        this.isLoadedDefault = true;
        this.transCacheProp.store(transCacheFile);
        this.mnemonicCacheProp.store(mnemonicCacheFile);
    }

    public String lookup(String enWithMnemonic, JointPoint jointPoint) {
        if (enWithMnemonic.length() == 0 || Mnemonics.hasJaMnemonic(enWithMnemonic)) {
            return enWithMnemonic;
        }
        String en = Mnemonics.removeEnMnemonic(enWithMnemonic);
        if (this.transCacheProp.containsValue(en.trim())) {
            return enWithMnemonic;
        }
        String ja = this.lookupInternal(en, jointPoint);
        if (!en.equals(ja) && this.callHierarchy.isExcludeTranslation(en, jointPoint)) {
            if (en.equals("Debug")) {
                return enWithMnemonic;
            }
            ja = en;
        }
        ja = this.convertMnemonicEnToJa(enWithMnemonic, en, ja);
        return ja;
    }

    public String lookupIgnoreMnemonic(String en, JointPoint jointPoint) {
        String ja = this.lookupInternal(en, jointPoint);
        if (!en.equals(ja) && this.callHierarchy.isExcludeTranslation(en, jointPoint)) {
            ja = en;
        }
        return ja;
    }

    public String lookupHelp(String en, JointPoint jointPoint) {
        return this.getValueForHelp(en);
    }

    protected String lookupInternal(String en, JointPoint jointPoint) {
        String ja = this.transCacheProp.get(en);
        if (ja != null) {
            if (ja.length() == 0) {
                ja = en;
            }
        } else {
            ja = super.getValueByRegex(new TranslationString(en));
            if (ja != null) {
                this.transCacheProp.put(en, ja);
            } else {
                if (en.length() != en.getBytes().length) {
                    ja = en;
                } else {
                    if (super.load()) {
                        log.debug("\u30ad\u30e3\u30c3\u30b7\u30e5\u306b\u306a\u3044\u305f\u3081\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9: " + Property.escapeKey(en), new Object[0]);
                    }
                    ja = this.getValue(en);
                }
                this.transCacheProp.put(en, en.equals(ja) ? "" : ja);
            }
        }
        return ja;
    }

    protected String getValueByRegex(TranslationString enTs) {
        return null;
    }

    protected String convertMnemonicEnToJa(String enWithMnemonic, String en, String ja) {
        if (DynamicTranslationDictionary.pleiadesOption.isNoMnemonic) {
            return ja;
        }
        if (enWithMnemonic.length() == en.length()) {
            return ja;
        }
        String jaWithMnemonic = this.mnemonicCacheProp.get(enWithMnemonic);
        if (jaWithMnemonic == null) {
            jaWithMnemonic = Mnemonics.convertMnemonicEnToJa(enWithMnemonic, en, ja);
            this.mnemonicCacheProp.put(enWithMnemonic, jaWithMnemonic);
        }
        return jaWithMnemonic;
    }
}

