/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.ExcludeClassNameCache;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TransformedClassCache;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(TranslationTransformer.class);

    protected boolean isClassPathTarget(String fullPath, String jarFileName) {
        return jarFileName.startsWith("org.eclipse.") ? jarFileName.startsWith("org.eclipse.core.resources_") || jarFileName.startsWith("org.eclipse.core.runtime_") || jarFileName.startsWith("org.eclipse.debug.core_") || jarFileName.startsWith("org.eclipse.dltk.core_") || jarFileName.startsWith("org.eclipse.equinox.common_") || jarFileName.startsWith("org.eclipse.jdt.core_") || jarFileName.startsWith("org.eclipse.jdt.ui_") || jarFileName.startsWith("org.eclipse.jface_") || jarFileName.startsWith("org.eclipse.osgi_") || jarFileName.startsWith("org.eclipse.swt.") || jarFileName.startsWith("org.eclipse.ui.workbench_") : jarFileName.startsWith("mergedoc.jstyle.swt") || jarFileName.startsWith("com.android.ide.eclipse.adt_") || jarFileName.equals("sdklib.jar") || jarFileName.equals("assetstudio.jar");
    }

    protected byte[] transform(String classId, String className, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        ExcludeClassNameCache excludeClassCache = ExcludeClassNameCache.getInstance();
        if (excludeClassCache.contains(classId)) {
            return null;
        }
        TransformedClassCache classCache = TransformedClassCache.getInstance();
        byte[] cachedBytecode = classCache.get(classId);
        if (cachedBytecode != null) {
            return cachedBytecode;
        }
        PleiadesConfig config = PleiadesConfig.getInstance();
        if (config.isExcludePackage(className)) {
            excludeClassCache.addNextLaunch(classId);
            return null;
        }
        CtClass ctClass = this.createCtClass(bytecode);
        try {
            byte[] transformedBytecode = this.transformClass(ctClass);
            if (classCache.isActive()) {
                if (transformedBytecode == null) {
                    if (!classCache.contains(classId)) {
                        excludeClassCache.addNextLaunch(classId);
                    }
                } else {
                    classCache.putNextLaunch(classId, transformedBytecode);
                }
            }
            return transformedBytecode;
        }
        catch (CannotCompileException e) {
            excludeClassCache.addNextLaunch(classId);
            throw e;
        }
    }

    protected byte[] transformClass(CtClass ctClass) throws CannotCompileException, NotFoundException, IOException {
        long start = System.nanoTime();
        TranslationEditor editor = new TranslationEditor(ctClass);
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior ctBehavior = ctBehaviorArray[n2];
            ctBehavior.instrument((ExprEditor)editor);
            editor.editBehavior(ctBehavior);
            ++n2;
        }
        CtConstructor ctInitializer = ctClass.getClassInitializer();
        if (ctInitializer != null) {
            ctInitializer.instrument((ExprEditor)editor);
        }
        Analyses.end(TranslationTransformer.class, "transformClass", start);
        return editor.toBytecode();
    }
}

