/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mergedoc.pleiades.aspect.EclipseFiles;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import org.apache.commons.io.FileUtils;

public class Metadata {
    private static Logger log = Logger.getLogger(Metadata.class);
    private static final List<String> EXCLUDES = Collections.unmodifiableList(new LinkedList<String>(){
        {
            this.add(".*~");
            this.add("#.*#");
            this.add(".#.*");
            this.add("%.*%");
            this.add("\\._.*");
            this.add("CVS");
            this.add("\\.cvsignore");
            this.add("SCCS");
            this.add("vssver\\.scc");
            this.add("\\.svn");
            this.add("\\.DS_Store");
            this.add("\\.bzr");
            this.add("\\.cdv");
            this.add("\\.git");
            this.add("\\.hg");
            this.add("\\.pc");
            this.add("RCS");
            this.add("_darcs");
            this.add("_sgbak");
            this.add("vssver2\\.scc");
            this.add("_svn");
        }

        @Override
        public boolean contains(Object name) {
            for (String pattern : this) {
                if (!((String)name).matches(pattern)) continue;
                return true;
            }
            return false;
        }
    });
    private static final Metadata singleton = new Metadata();
    private String eclipseHomeParent;
    private File metadataSrcDir;
    private File metadataDstDir;
    private boolean isNewWorkspace;

    public static Metadata getInstance() {
        return singleton;
    }

    private Metadata() {
    }

    private boolean isExistsMetadataDefault() {
        File eclipseHomeParentDir;
        if (this.metadataSrcDir == null && (eclipseHomeParentDir = EclipseFiles.getHome().getParentFile()) != null) {
            this.eclipseHomeParent = eclipseHomeParentDir.getPath().replace("\\", "/");
            this.metadataSrcDir = new File(this.eclipseHomeParent, ".metadata.default/.plugins");
        }
        return this.metadataSrcDir != null && this.metadataSrcDir.exists();
    }

    public String getDefaultWorkspaceEncoding() {
        if (!this.isNewWorkspace) {
            return null;
        }
        if (!this.isExistsMetadataDefault()) {
            return null;
        }
        File encodingPrefs = new File(this.metadataSrcDir, "org.eclipse.core.runtime/.settings/org.eclipse.core.resources.prefs");
        if (!encodingPrefs.exists()) {
            return null;
        }
        PropertySet p = new PropertySet(encodingPrefs);
        String encoding = (String)p.get("encoding");
        log.debug("\u30c7\u30d5\u30a9\u30eb\u30c8\u81ea\u52d5\u8a2d\u5b9a\u306e\u30ef\u30fc\u30af\u30b9\u30da\u30fc\u30b9\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0: " + encoding, new Object[0]);
        this.isNewWorkspace = false;
        return encoding;
    }

    public void createNewWorkspaceMetadata(URL workspace) throws URISyntaxException, IOException {
        if (!this.isExistsMetadataDefault()) {
            return;
        }
        if (workspace == null) {
            log.error("\u30ef\u30fc\u30af\u30b9\u30da\u30fc\u30b9\u304c null \u3067\u3059\u3002", new Object[0]);
            return;
        }
        File workspaceFolder = new File(workspace.getFile());
        this.metadataDstDir = new File(workspaceFolder, ".metadata/.plugins");
        File copiedFile = new File(this.metadataDstDir.getParentFile(), ".copied.metadata.default");
        if (copiedFile.exists()) {
            return;
        }
        int copyCount = this.copyMetadata(this.metadataSrcDir);
        FileUtils.writeStringToFile((File)copiedFile, (String)"");
        log.info(".metadata.default \u304b\u3089 " + copyCount + " \u500b\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30ef\u30fc\u30af\u30b9\u30da\u30fc\u30b9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f\u3002" + this.metadataDstDir.getParentFile(), new Object[0]);
        this.isNewWorkspace = true;
    }

    private int copyMetadata(File srcDir) throws IOException {
        String HOME_STRING = "%ECLIPSE_HOME_PARENT%";
        int copyCount = 0;
        File[] fileArray = srcDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File srcFile = fileArray[n2];
            if (!EXCLUDES.contains(srcFile.getName())) {
                if (srcFile.isDirectory()) {
                    copyCount += this.copyMetadata(srcFile);
                } else {
                    File dstFile = new File(this.metadataDstDir, Files.relativePath(this.metadataSrcDir, srcFile));
                    if (!dstFile.exists()) {
                        String s = FileUtils.readFileToString((File)srcFile, (String)"UTF-8");
                        if (s.contains("%ECLIPSE_HOME_PARENT%")) {
                            s = s.replace("%ECLIPSE_HOME_PARENT%", this.eclipseHomeParent);
                            FileUtils.writeStringToFile((File)dstFile, (String)s, (String)"UTF-8");
                        } else {
                            FileUtils.copyFile((File)srcFile, (File)dstFile);
                        }
                        ++copyCount;
                    }
                }
            }
            ++n2;
        }
        return copyCount;
    }
}

