/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class Locks {
    private static final Logger log = Logger.getLogger(Locks.class);
    private static final File lockFile = Pleiades.getResourceFile(".lock");
    private static volatile FileChannel fileChannel;

    static {
        try {
            lockFile.createNewFile();
        }
        catch (IOException e) {
            log.error(e, "\u6392\u4ed6\u30ed\u30c3\u30af\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
        }
    }

    public static void lock() {
        if (fileChannel != null) {
            log.debug("\u3059\u3067\u306b\u3053\u306e\u30d7\u30ed\u30bb\u30b9\u5185\u3067\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u307e\u3059\u3002", new Object[0]);
            return;
        }
        log.debug("\u6392\u4ed6\u30ed\u30c3\u30af\u3057\u307e\u3059\u3002", new Object[0]);
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(lockFile.getPath(), "rw");
                fileChannel = raf.getChannel();
                FileLock lock = fileChannel.tryLock();
                int i = 0;
                while (i < 10 && lock == null) {
                    log.debug("\u6392\u4ed6\u30ed\u30c3\u30af\u5f85\u6a5f\u4e2d...", new Object[0]);
                    Thread.sleep(i * 1000);
                    lock = fileChannel.tryLock();
                    ++i;
                }
                if (lock == null) {
                    log.warn("\u30d7\u30ed\u30bb\u30b9\u9593\u306e\u6392\u4ed6\u30ed\u30c3\u30af\u3092\u7121\u8996\u3057\u3066\u51e6\u7406\u3092\u7d9a\u884c\u3057\u307e\u3059\u3002", new Object[0]);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("\u6392\u4ed6\u30ed\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("\u6392\u4ed6\u30ed\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("\u6392\u4ed6\u30ed\u30c3\u30af\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
            }
        }
    }

    public static void release() {
        try {
            if (fileChannel != null) {
                log.debug("\u6392\u4ed6\u30ed\u30c3\u30af\u3092\u89e3\u9664\u3057\u307e\u3059\u3002", new Object[0]);
                fileChannel.close();
                fileChannel = null;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("\u6392\u4ed6\u30ed\u30c3\u30af\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }
}

