/**
 * CommandoJikkyouSennyou - Commando Jikkyou Sennyou Client for twitter for Qt.
 *
 * Author: amayav (vamayav@yahoo.co.jp)
 *
 *
 *  CommandoJikkyouSennyou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  CommandoJikkyouSennyou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with CommandoJikkyouSennyou.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "widget.h"
#include "ui_widget.h"
#include <QTextCodec>
#include <QDir>
#include <QDebug>
#include <QtXml/QDomDocument>
#include <QUrl>
#include <QSettings>
#include <QKeyEvent>
#include "extrapushbutton.h"
#include <cmath>
#include <QLayoutItem>
#include <QDateTime>
#include "picojson.h"

using namespace std;
using namespace picojson;

/*
  publidc functions
  */
Widget::Widget(QWidget *parent) : QWidget(parent), ui(new Ui::Widget){
    //-------------------------
    // Qt特有のUTF-8設定
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("utf-8"));
    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf-8"));
    QTextCodec::setCodecForLocale(QTextCodec::codecForName("utf-8"));
    //-------------------------

    ui->setupUi(this);

    // OAuth Settings
    QString oauthIniName = qApp->applicationDirPath()
            + "/verification.ini";
    _oauthSettings = new QSettings(oauthIniName, QSettings::IniFormat);
    _oauthSettings->setIniCodec("utf-8");
    if (_oauthSettings->childKeys().size() == 3) {
        ui->lineEdit->setText(_oauthSettings->value("number").toString());
    }

    // Initialize kQAOuth
    _oauthRequest = new KQOAuthRequest;
    _oauthManager = new KQOAuthManager(this);
    _oauthManager->setNetworkManager(new QNetworkAccessManager);
    connect(_oauthManager, SIGNAL(authorizedRequestDone()),
            this, SLOT(onAuthorizedRequestDone()));
    _oauthRequest->setEnableDebugOutput(false);

    // Commando Jikkyou Shortcut Key Settings
    QString shortCutKeysIniName = qApp->applicationDirPath()
            + "/key.txt";
    _shortCutKeysSettings = new QSettings(shortCutKeysIniName, QSettings::IniFormat);
    _shortCutKeysSettings->setIniCodec("utf-8");
    QStringList keyKeys = _shortCutKeysSettings->childKeys();
    _keysHash = new QHash<QString,QString>();
    for(int i=0;i<_shortCutKeysSettings->childKeys().size();++i)
    {
        _keysHash->insert(keyKeys.at(i), _shortCutKeysSettings->value(keyKeys.at(i)).toString());
        ExtraPushButton *p = new ExtraPushButton(keyKeys.at(i),
                                                 _shortCutKeysSettings->value(keyKeys.at(i)).toString(),
                                                 this);
        p->setToolTip(_shortCutKeysSettings->value(keyKeys.at(i)).toString());
        ui->buttonsGridLayout->addWidget(p,0,i);
        // Succession of slots can not go well.
        connect(p, SIGNAL(clicked()), p, SLOT(click()));
        connect(p, SIGNAL(clicked(QString)), this, SLOT(sendTweet(QString)));
        connect(p, SIGNAL(showingToolTip(QString)), ui->plainTextEdit, SLOT(setPlainText(QString)));
    }

    // Size Settings
    QString sizeIniName = qApp->applicationDirPath()
            + "/size.ini";
    _sizeSettings = new QSettings(sizeIniName, QSettings::IniFormat);
    if(_sizeSettings->allKeys().count()==2)
    {
        resize(_sizeSettings->value("width").toInt(), _sizeSettings->value("height").toInt());
    }
    else
    {
        resize(200,200);
    }

    // Short Cut Key for Post.
    QShortcut *post1 = new QShortcut(ui->lineEdit_2);
    QShortcut *post2 = new QShortcut(ui->lineEdit_3);
    QShortcut *post3 = new QShortcut(ui->lineEdit_4);
    QShortcut *post4 = new QShortcut(ui->lineEdit_5);
    QShortcut *post5 = new QShortcut(ui->lineEdit_6);
    QList<QShortcut*> postShortCutList;
    postShortCutList << post1 << post2 << post3 << post4 << post5;
    for(int i=0;i<postShortCutList.size();++i)
    {
        this->setShortCutKeyAndContext(postShortCutList.at(i), QKeySequence(Qt::CTRL + Qt::Key_Return), Qt::WidgetShortcut);
    }

    connect(post1, SIGNAL(activated()), ui->pushButton_4, SLOT(click()));
    connect(post2, SIGNAL(activated()), ui->pushButton_4, SLOT(click()));
    connect(post3, SIGNAL(activated()), ui->pushButton_4, SLOT(click()));
    connect(post4, SIGNAL(activated()), ui->pushButton_4, SLOT(click()));
    connect(post5, SIGNAL(activated()), ui->pushButton_4, SLOT(click()));

    // Initialize Own Post Latest130 and Latest10
    initializeOwnPostsWidgets();
}

bool Widget::setShortCutKeyAndContext(QShortcut *sc, QKeySequence s, Qt::ShortcutContext c)
{
    sc->setKey(s);
    sc->setContext(c);
    return true;
}

bool Widget::initializeOwnPostsWidgets()
{
    qDebug("Initializing Own Posts");
    QUrl url("https://api.twitter.com/1/statuses/user_timeline.json");
    _oauthRequest->initRequest(KQOAuthRequest::AuthorizedRequest, url);
    _oauthRequest->setHttpMethod(KQOAuthRequest::GET); // GET
    _oauthRequest->setConsumerKey("nXrjGagSLIQxCC4AmJ1J3g");
    _oauthRequest->setConsumerSecretKey("QkTRr36zT6wAMERWqKUefyshxXIeaGzPKxB5pwMN0tg");
    _oauthRequest->setToken(_oauthSettings->value("oauth_token").toString());
    _oauthRequest->setTokenSecret(
                _oauthSettings->value("oauth_token_secret").toString());

    KQOAuthParameters params;
    params.insert("count", "131");
    _oauthRequest->setAdditionalParameters(params);

    qDebug() << _oauthSettings->value("oauth_token").toString();
    qDebug() << _oauthSettings->value("oauth_token_secret").toString();

    disconnect(_oauthManager, SIGNAL(requestReady(QByteArray)));
    connect(_oauthManager, SIGNAL(requestReady(QByteArray)),
            this, SLOT(onRequestReadyOwnPosts(QByteArray)));

    connect(_oauthManager, SIGNAL(authorizedRequestDone()),
            this, SLOT(onAuthorizedRequestDone()));

    _oauthManager->executeRequest(_oauthRequest);

    return true;
}

Widget::~Widget() {
    delete _oauthRequest;
    delete _oauthManager;
    delete _oauthSettings;

    delete ui;
}

/*
  protected functions
  */
void Widget::keyPressEvent(QKeyEvent *ke)
{
    if(ke->isAutoRepeat())
    {
        return;
    }
    setAttribute(Qt::WA_KeyCompression);
    QString key;
    if( (ke->modifiers()==Qt::ControlModifier) && (ke->key()!=Qt::Key_Control) )
    {
        /*
          0x00:^@
          0x00-0x1a:^A-^Z
          0x1b:^[
          0x1c:^\
          0x1d:^]
          0x1e:^
          0x1f:^_

          0x40:@
          0x41-0x4a:A-Z
          ...
        */
        if(ke->text().toAscii().toHex().toInt(0, 16) <= 31) //31 is 0x1f
        {
            key = QByteArray::fromHex(QByteArray::number(ke->text().toAscii().toHex().toInt(0, 16) + 64, 16));
        }
        else
        {
            key = ke->text();
        }
        _keyString.append(key.toLower());
        qDebug() << ke->text() << _keyString << ke->count();


        for(int i=0;i<ui->buttonsGridLayout->count();++i)
        {
            ExtraPushButton *p = dynamic_cast<ExtraPushButton*>(ui->buttonsGridLayout->itemAt(i)->widget());
            if(p->getShortCutKey().indexOf(_keyString)!=0)
            {
                ui->buttonsGridLayout->itemAt(i)->widget()->setEnabled(false);
            }
        }
    }
}

void Widget::keyReleaseEvent(QKeyEvent *ke)
{
    if(ke->isAutoRepeat())
    {
        return;
    }
    if( ( ke->key()==Qt::Key_Control) && (_keyString.size()>0) )
    {
        // Search String
        qDebug() << "ctrl!" << _keyString;
        QString tweet;
        int matchedKeysNumber = 0;
        QList<QString> list = _keysHash->keys();
        for(int i=0;i<list.size();++i)
        {
            if(list.at(i).indexOf(_keyString)==0)
            {
                // Match
                if(list.at(i).length() == _keyString.length())
                {
                    tweet = _keysHash->value(list.at(i));
                    matchedKeysNumber = -1;
                    break;
                }
                ++matchedKeysNumber;
                tweet = _keysHash->value(list.at(i));
            }
        }

        if(matchedKeysNumber>1)
        {
            tweet.clear();
        }
        _keyString.clear();

        // Exception of Exchanging Strings
        if(tweet.contains(QRegExp("\\(\\d.*\\)")))
        {
            ui->plainTextEdit->setPlainText(tweet);
            for(int i=0;i<ui->buttonsGridLayout->count();++i)
            {
                if(ui->buttonsGridLayout->itemAt(i)->widget()->isEnabled()==true)
                {
                    ui->buttonsGridLayout->itemAt(i)->widget()->setEnabled(false);
                }
            }
            ui->lineEdit_2->setFocus();
        }
        else
        {
            // Enable All Buttons
            for(int i=0;i<ui->buttonsGridLayout->count();++i)
            {
                if(ui->buttonsGridLayout->itemAt(i)->widget()->isEnabled()==false)
                {
                    ui->buttonsGridLayout->itemAt(i)->widget()->setEnabled(true);
                }
            }
            if(tweet.size()==0)
            {
                qDebug() << "There is not such a short cut key.";
                return;
            }
            sendTweet(tweet);
        }
        tweet.clear();
    }
}

void Widget::resizeEvent(QResizeEvent *)
{
    _sizeSettings->setValue("width", width());
    _sizeSettings->setValue("height", height());
    //replace buttons.
    int beforeColumnsNumber =0;
    for(int i=ui->buttonsGridLayout->columnCount()-1;i>=0;--i)
    {
        if(ui->buttonsGridLayout->itemAtPosition(0,i)!=NULL)
        {
            beforeColumnsNumber = i+1;
            break;
        }
    }
    if(beforeColumnsNumber==0)
    {
        return;
    }

    QRect r;
    for(int i=beforeColumnsNumber-1;i>=0;--i)
    {
        if(ui->buttonsGridLayout->itemAtPosition(0, i)!=NULL)
        {
            r = ui->buttonsGridLayout->itemAtPosition(0, i)->widget()->frameGeometry();
            break;
        }
    }

    // When widget size becomes too small.
    if(r.x()+r.width() > ui->groupBox->frameGeometry().x()+ui->groupBox->frameGeometry().width())
    {
        int afterColumnsNumber = 0;
        for(int i=beforeColumnsNumber-1;i>=0;--i)
        {
            r = ui->buttonsGridLayout->itemAtPosition(0,i)->widget()->frameGeometry();
            if(r.x()+r.width()
                    < ui->groupBox->frameGeometry().x()+ui->groupBox->frameGeometry().width())
            {
                afterColumnsNumber = i+1;
                break;
            }
        }
        if(afterColumnsNumber==0)
        {
            return;
        }
        QList<QLayoutItem*> *list = new QList<QLayoutItem*>();
        while(ui->buttonsGridLayout->itemAt(0)!=NULL)
        {
            list->append(ui->buttonsGridLayout->itemAt(0)); // There are only extraPushButtons.
            ui->buttonsGridLayout->removeItem(ui->buttonsGridLayout->itemAt(0));
        }
        for(int i=0;i<list->size();++i)
        {
            ui->buttonsGridLayout->addItem(list->at(i),
                                           floor((double)i/(double)afterColumnsNumber),
                                           i%afterColumnsNumber);
        }
    }
    // When widget size becomes too big
    else if(r.x() + r.width() + ui->buttonsGridLayout->horizontalSpacing() + r.width()
            < ui->groupBox->x() + ui->groupBox->frameGeometry().width())
    {
        int afterColumnsNumber = 0;
        for(int i=1;i<200;++i)
        {
            if(r.x()+r.width() + i*(ui->buttonsGridLayout->horizontalSpacing() + ui->buttonsGridLayout->itemAt(0)->widget()->width())
                    > ui->groupBox->frameGeometry().x()+ui->groupBox->frameGeometry().width())
            {
                afterColumnsNumber = beforeColumnsNumber+i;
                break;
            }
        }
        if(afterColumnsNumber > ui->buttonsGridLayout->count() || afterColumnsNumber==0)
        {
            return;
        }
        QList<QLayoutItem*> *list = new QList<QLayoutItem*>();
        while(ui->buttonsGridLayout->itemAt(0)!=NULL)
        {
            list->append(ui->buttonsGridLayout->itemAt(0)); // There are only extraPushButtons.
            ui->buttonsGridLayout->removeItem(ui->buttonsGridLayout->itemAt(0));
        }
        for(int i=0;i<list->size();++i)
        {
            ui->buttonsGridLayout->addItem(list->at(i),
                                           floor((double)i/(double)afterColumnsNumber),
                                           i%afterColumnsNumber);
        }
    }
    else
    {
    }
}

void Widget::showEvent(QShowEvent *)
{
    // Here is for use of resizeEvent() when program is going to start.
    resize(size()-QSize(1,0));
    resize(size()+QSize(1,0));
}

/*
  private slots
  */
void Widget::onTemporaryTokenReceived(QString token, QString tokenSecret)
{
    QUrl userAuthURL("https://api.twitter.com/oauth/authorize");

    if( _oauthManager->lastError() == KQOAuthManager::NoError) {
        qDebug() << "Opening authorization web site: " << userAuthURL;
        _oauthManager->getUserAuthorization(userAuthURL);
    }
}

void Widget::onAuthorizationReceived(QString token, QString verifier)
{
    qDebug() << "User authorization received: " << token << verifier;

    _oauthManager->getUserAccessTokens(
                QUrl(tr("https://api.twitter.com/oauth/access_token")));
    if (_oauthManager->lastError() != KQOAuthManager::NoError) {
        QCoreApplication::exit();
    }
}

void Widget::onAccessTokenReceived(QString token, QString tokenSecret)
{
    qDebug() << "Access token received: " << token << tokenSecret;

    _oauthSettings->setValue(tr("oauth_token"), token);
    _oauthSettings->setValue(tr("oauth_token_secret"), tokenSecret);

    qDebug() << "Access tokens now stored. "
                "You are ready to send Tweets from user's account!";

    //QCoreApplication::exit();
}

void Widget::onAuthorizedRequestDone() {
    qDebug() << "Request sent to Twitter!";
    //QCoreApplication::exit(0);
}

void Widget::onRequestReady(QByteArray response)
{
    qDebug() << "Response from the service: " << response;
}

void Widget::on_pushButton_clicked() {
    ui->lineEdit->setEnabled(true);
    ui->pushButton_3->setEnabled(true);

    // kQOAuth Slots
    connect(_oauthManager, SIGNAL(temporaryTokenReceived(QString,QString)),
            this, SLOT(onTemporaryTokenReceived(QString, QString)));

    connect(_oauthManager, SIGNAL(authorizationReceived(QString,QString)),
            this, SLOT( onAuthorizationReceived(QString, QString)));

    connect(_oauthManager, SIGNAL(accessTokenReceived(QString,QString)),
            this, SLOT(onAccessTokenReceived(QString,QString)));

    connect(_oauthManager, SIGNAL(requestReady(QByteArray)),
            this, SLOT(onRequestReady(QByteArray)));

    // OAuth Verification Starts

    _oauthRequest->initRequest(KQOAuthRequest::TemporaryCredentials,
                               QUrl("https://api.twitter.com/oauth/request_token"));

    _oauthRequest->setConsumerKey("nXrjGagSLIQxCC4AmJ1J3g");
    _oauthRequest->setConsumerSecretKey("QkTRr36zT6wAMERWqKUefyshxXIeaGzPKxB5pwMN0tg");

    _oauthManager->setHandleUserAuthorization(true);
    //  _oauthManager->setHandleUserAuthorization(false);

    _oauthManager->executeRequest(_oauthRequest);

    // Checking Error
    int e = _oauthManager->lastError();
    if (e != KQOAuthManager::NoError) {
        showOAuthError(e);
    }
}

void Widget::on_pushButton_2_clicked() {
    ui->listWidget->clear();

    QUrl url("https://api.twitter.com/1/statuses/home_timeline.json");
    _oauthRequest->initRequest(KQOAuthRequest::AuthorizedRequest, url);
    _oauthRequest->setHttpMethod(KQOAuthRequest::GET); // GET
    _oauthRequest->setConsumerKey("nXrjGagSLIQxCC4AmJ1J3g");
    _oauthRequest->setConsumerSecretKey("QkTRr36zT6wAMERWqKUefyshxXIeaGzPKxB5pwMN0tg");
    _oauthRequest->setToken(_oauthSettings->value("oauth_token").toString());
    _oauthRequest->setTokenSecret(
                _oauthSettings->value("oauth_token_secret").toString());

    qDebug() << _oauthSettings->value("oauth_token").toString();
    qDebug() << _oauthSettings->value("oauth_token_secret").toString();

    disconnect(_oauthManager, SIGNAL(requestReady(QByteArray)),0,0);
    connect(_oauthManager, SIGNAL(requestReady(QByteArray)),
            this, SLOT(onRequestReadyTimeline(QByteArray)));

    //    connect(_oauthManager, SIGNAL(authorizedRequestDone()),
    //            this, SLOT(onAuthorizedRequestDone()));

    _oauthManager->executeRequest(_oauthRequest);
}

void Widget::onRequestReadyTimeline(QByteArray response) {
    qDebug("Reading TimeLine");
    QDomDocument dom;
    // For JSON
    if(dom.setContent(response)==false)
    {
        value v;
        string err;
        parse(v, response.data(), response.data() + response.size(), &err);
        if (err.empty())
        {
            ui->listWidget->clear();
            array arr = v.get<array>();
            array::iterator it;
            for (it = arr.begin(); it != arr.end(); ++it)
            {
                object obj = it->get<object>();
                if(QString::fromStdString(obj["text"].to_str()).contains("#commando"))
                {
                    ui->listWidget->addItem(QString::fromStdString(obj["text"].to_str()));
                }
            }
        }
        else
        {
            cerr << err << endl;
        }
            /*
            qDebug() <<
                        ["contributors"] <<
                        "\n" <<
                        ["coordinates"] <<
                        "\n" <<
                        ["created_at"].toString() <<
                        "\n" <<
                        ["geo"]<<
                        "\n" <<
                        ["id"].toLongLong() <<
                        "\n" <<
                        ["id_str"].toString() <<
                        "\n" <<
                        ["in_reply_to_screen_name"] <<
                        "\n" <<
                        ["in_reply_to_status_id"]<<
                        "\n" <<
                        ["in_reply_to_status_id"] <<
                        "\n" <<
                        ["in_reply_to_user_id"] <<
                        "\n" <<
                        ["in_reply_to_user_id_str"] <<
                        "\n" <<
                        ["place"] <<
                        "\n" <<
                        ["possibly_sensitive"].toBool() <<
                        "\n" <<
                        ["retweet_count"].toULongLong() <<
                        "\n" <<
                        ["retweeted"].toBool() <<
                        "\n" <<
                        ["text"].toString() <<
                        "\n" <<
                        ["truncated"].toBool() <<
                        "\n" <<
                        ["user"]["contributors_enabled"].toBool() <<
                        "\n" <<
                        ["user"]["created_at"].toString() <<
                        "\n" <<
                        ["user"]["default_profile"].toBool() <<
                        "\n" <<
                        ["user"]["default_profile_image"].toBool() <<
                        "\n" <<
                        ["user"]["description"].toString() <<
                        "\n" <<
                        ["user"]["favourites_count"].toULongLong() <<
                        "\n" <<
                        ["user"]["followers_count"].toULongLong() <<
                        "\n" <<
                        ["user"]["following"].toBool() <<
                        "\n" <<
                        ["user"]["friends_count"].toULongLong() <<
                        "\n" <<
                        ["user"]["geo_enabled"].toBool() <<
                        "\n" <<
                        ["user"]["id"].toULongLong() <<
                        "\n" <<
                        ["user"]["id_str"].toString() <<
                        "\n" <<
                        ["user"]["is_translator"].toBool() <<
                        "\n" <<
                        ["user"]["lang"].toString() <<
                        "\n" <<
                        ["user"]["listed_count"].toULongLong() <<
                        "\n" <<
                        ["user"]["location"].toString() <<
                        "\n" <<
                        ["user"]["profile_background_color"].toString() <<
                        "\n" <<
                        ["user"]["profile_background_image_url"].toString() <<
                        "\n" <<
                        ["user"]["profile_background_image_url_https"].toString() <<
                        "\n" <<
                        ["user"]["profile_background_tile"].toBool() <<
                        "\n" <<
                        ["user"]["profile_image_url_https"].toString() <<
                        "\n" <<
                        ["user"]["profile_sidebar_border_color"].toString() <<
                        "\n" <<
                        ["user"]["profile_sidebar_fill_color"].toString() <<
                        "\n" <<
                        ["user"]["profile_text_color"].toString() <<
                        "\n" <<
                        ["user"]["profile_use_background_image"].toString() <<
                        "\n" <<
                        ["user"]["protected"].toBool() <<
                        "\n" <<
                        ["user"]["screen_name"].toBool() <<
                        "\n" <<
                        ["user"]["show_all_inline_media"].toString() <<
                        "\n" <<
                        ["user"]["statuses_count"].toULongLong() <<
                        "\n" <<
                        ["user"]["time_zone"].toString() <<
                        "\n" <<
                        ["user"]["url"].toString() <<
                        "\n" <<
                        ["user"]["utc_offset"].toULongLong() <<
                        "\n" <<
                        ["user"]["verified"].toBool() <<
                        "\n\n";
*/
        return;
    }
    // for XML
    else
    {
        QDomElement root = dom.documentElement();
        QDomNode node;
        node = root.firstChild();
        while ( !node.isNull() )
        {
            if ( node.isElement() && (node.nodeName() == "status" ) )
            {
                QDomElement header = node.toElement();

                QDomNode node = header.firstChild();
                while ( !node.isNull() )
                {
                    if ( node.isElement() )
                    {
                        // いろいろなヘッダエントリの場合
                        if ( node.nodeName() == "text" )
                        {
                            QDomText textChild = node.firstChild().toText();
                            if ( !textChild.isNull() )
                            {
                                ui->listWidget->addItem(textChild.nodeValue());
                            }
                        }
                    }
                    node = node.nextSibling();
                }
            }
            node = node.nextSibling();
        }
    }
}

void Widget::onRequestReadyOwnPosts(QByteArray response) {
    qDebug() << "requestReady-OwnPosts";
    // for JSON
    QDomDocument dom;
    if(dom.setContent(response)==false)
    {
        value v;
        string err;
        parse(v, response.data(), response.data() + response.size(), &err);
        if (err.empty())
        {
            array arr = v.get<array>();
            array::iterator it;
            int i=0;
            for (it = arr.begin(); it != arr.end(); ++it)
            {
                object obj = it->get<object>();
                ui->tableWidget_2->setItem(130-i-1, 0, new QTableWidgetItem(QString::fromStdString(obj["created_at"].to_str()).mid(8,11)));
                if(i<10)
                {
                    ui->tableWidget->setItem(10-i-1, 0, new QTableWidgetItem(QString::fromStdString(obj["text"].to_str())));
                }
                ++i;
            }
        }
        else
        {
            cerr << err << endl;
        }
        return;
    }
}

void Widget::sendTweet(QString tweet) {

    if( _oauthSettings->value("oauth_token").toString().isEmpty() ||
            _oauthSettings->value("oauth_token_secret").toString().isEmpty()) {
        qDebug() << "No access tokens. Aborting.";

        return;
    }
    if(tweet.size()==0)
    {
        return;
    }

    tweet.replace(QRegExp("\\(\\d+:([^()]+)\\)"), "\\1");
    tweet.append(" #commando");

    _oauthRequest->initRequest(KQOAuthRequest::AuthorizedRequest,
                               QUrl("http://api.twitter.com/1/statuses/update.xml")
                               );
    _oauthRequest->setConsumerKey("nXrjGagSLIQxCC4AmJ1J3g");
    _oauthRequest->setConsumerSecretKey("QkTRr36zT6wAMERWqKUefyshxXIeaGzPKxB5pwMN0tg");
    _oauthRequest->setToken(_oauthSettings->value("oauth_token").toString());
    _oauthRequest->setTokenSecret(_oauthSettings->value("oauth_token_secret").toString());

    KQOAuthParameters params;
    params.insert("status", tweet);
    _oauthRequest->setAdditionalParameters(params);

    qDebug() << "Attempting send tweet such as " << tweet;
    qDebug() << _oauthRequest->requestBody();
    _oauthManager->executeRequest(_oauthRequest);

    ui->tableWidget->removeRow(0);
    ui->tableWidget->setRowCount(ui->tableWidget->rowCount()+1);
    ui->tableWidget->setItem(9,0,new QTableWidgetItem(tweet));

    ui->tableWidget_2->removeRow(0);
    ui->tableWidget_2->setRowCount(ui->tableWidget_2->rowCount()+1);
    ui->tableWidget_2->setItem(129,0, new QTableWidgetItem( (QDateTime::currentDateTime().toString("dd hh:mm:ss"))));
    //    connect(_oauthManager, SIGNAL(authorizedRequestReady()),
    //         this, SLOT(onAuthorizedRequestReady()));

    // LineEdits must cleare content.
    ui->lineEdit_2->clear();
    ui->lineEdit_3->clear();
    ui->lineEdit_4->clear();
    ui->lineEdit_5->clear();
    ui->lineEdit_6->clear();
}

void Widget::showOAuthError(const int nErrNum)
{
    qDebug() << "error is " << nErrNum;
}

void Widget::on_pushButton_3_clicked()
{
    ui->lineEdit->setEnabled(false);
    ui->pushButton_3->setEnabled(false);
    _oauthSettings->setValue("number", ui->lineEdit->text());
    _oauthManager->onVerificationReceived1(ui->lineEdit->text());
}

void Widget::on_pushButton_4_clicked()
{
    QString tweet = ui->plainTextEdit->toPlainText();
    sendTweet(tweet);
}

void Widget::on_lineEdit_2_textChanged(const QString &arg1)
{
    replacePlainTextEditContent(1, arg1);
}

void Widget::on_lineEdit_3_textChanged(const QString &arg1)
{
    replacePlainTextEditContent(1, arg1);
}

void Widget::on_lineEdit_4_textChanged(const QString &arg1)
{
    replacePlainTextEditContent(1, arg1);
}

void Widget::on_lineEdit_5_textChanged(const QString &arg1)
{
    replacePlainTextEditContent(1, arg1);
}

void Widget::on_lineEdit_6_textChanged(const QString &arg1)
{
    replacePlainTextEditContent(1, arg1);
}

bool Widget::replacePlainTextEditContent(int i, QString str)
{
    if(str.length()>0)
    {
        QString text = ui->plainTextEdit->toPlainText();
        text.replace(QRegExp("(\\(" + QString::number(i) + ":)[^()]+(\\))"), "\\1" + str + "\\2");
        ui->plainTextEdit->setPlainText(text);
    }
    return true;
}
