/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class MessageDialogUI
extends JFrame {
    static final int ERROR_MODE = 0;
    static final int WARNING_MODE = 1;
    static final int INFORMATION_MODE = 2;
    static final String MSG_DETAIL_OPEN = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("MessageDialogUI.jButtonDetail.text.open");
    static final String MSG_DETAIL_CLOSE = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("MessageDialogUI.jButtonDetail.text");
    private static boolean detailOpen = true;
    private JButton jButtonDetail;
    private JButton jButtonOK;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneStack;
    private JTextArea jTextAreaMessage;
    private JTextArea jTextAreaStack;

    public boolean setDetailOpen(boolean flg) {
        boolean old = detailOpen;
        detailOpen = flg;
        return old;
    }

    public MessageDialogUI(String message, Throwable ex, int mode) {
        this.initComponents();
        this.jTextAreaMessage.setText(message);
        if (ex == null) {
            this.jButtonDetail.setEnabled(false);
            this.jButtonDetail.setText(MSG_DETAIL_OPEN);
            this.jScrollPaneStack.setVisible(false);
            this.pack();
        } else {
            StringWriter stackTraceMessageWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(stackTraceMessageWriter));
            stackTraceMessageWriter.flush();
            this.jTextAreaStack.setText(stackTraceMessageWriter.toString());
            if (!detailOpen) {
                this.jButtonDetail.setText(MSG_DETAIL_OPEN);
                this.jScrollPaneStack.setVisible(false);
                this.pack();
            }
        }
        switch (mode) {
            case 0: {
                this.setTitle(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("MessageDialogUI.title.Error_mdc"));
                break;
            }
            case 1: {
                this.setTitle(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("MessageDialogUI.title.Warning_mdc"));
                break;
            }
            case 2: {
                this.setTitle(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("MessageDialogUI.title.Information_mdc"));
            }
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setBounds((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2, frameSize.width, frameSize.height);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaMessage = new JTextArea();
        this.jButtonOK = new JButton();
        this.jButtonDetail = new JButton();
        this.jScrollPaneStack = new JScrollPane();
        this.jTextAreaStack = new JTextArea();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jent/checksmtp/Bundle");
        this.setTitle(bundle.getString("MessageDialogUI.title"));
        this.jTextAreaMessage.setColumns(20);
        this.jTextAreaMessage.setEditable(false);
        this.jTextAreaMessage.setLineWrap(true);
        this.jTextAreaMessage.setRows(3);
        this.jTextAreaMessage.setText(bundle.getString("MessageDialogUI.jTextAreaMessage.text"));
        this.jTextAreaMessage.setFocusable(false);
        this.jTextAreaMessage.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextAreaMessage);
        this.jButtonOK.setText(bundle.getString("MessageDialogUI.jButtonOK.text"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageDialogUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonDetail.setText(bundle.getString("MessageDialogUI.jButtonDetail.text"));
        this.jButtonDetail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageDialogUI.this.jButtonDetailActionPerformed(evt);
            }
        });
        this.jTextAreaStack.setColumns(20);
        this.jTextAreaStack.setEditable(false);
        this.jTextAreaStack.setRows(5);
        this.jTextAreaStack.setText(bundle.getString("MessageDialogUI.jTextAreaStack.text"));
        this.jScrollPaneStack.setViewportView(this.jTextAreaStack);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add(1, (Component)this.jScrollPaneStack, -1, 398, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonDetail).addPreferredGap(0, 238, Short.MAX_VALUE).add((Component)this.jButtonOK)).add(1, (Component)this.jScrollPane1, -1, 398, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonDetail)).add(18, 18, 18).add((Component)this.jScrollPaneStack, -1, 176, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonDetailActionPerformed(ActionEvent evt) {
        if (detailOpen) {
            this.jScrollPaneStack.setVisible(false);
            this.jButtonDetail.setText(MSG_DETAIL_OPEN);
            detailOpen = false;
        } else {
            this.jScrollPaneStack.setVisible(true);
            this.jButtonDetail.setText(MSG_DETAIL_CLOSE);
            detailOpen = true;
        }
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

