/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.MessageDialogUI;
import org.jent.checksmtp.ResultNotify;

public class ToListUI
extends JFrame {
    private List toList = null;
    private ResultNotify resultNotify = null;
    private static Timer confirmTimer = new Timer();
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public ToListUI(ResultNotify processer, List toList) {
        this.initComponents();
        this.jButtonCancel.requestFocusInWindow();
        this.toList = toList;
        this.resultNotify = processer;
        if (toList != null) {
            this.jList1.setListData(toList.toArray());
            this.jList1.setVisible(true);
        }
        this.setVisible(true);
        this.toFront();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (ApplicationProperties.isFileLoaded()) {
            int x = ApplicationProperties.getConfirmDialogPosX();
            int y = ApplicationProperties.getConfirmDialogPosY();
            int w = ApplicationProperties.getConfirmDialogPosW();
            int h = ApplicationProperties.getConfirmDialogPosH();
            if (x > screenSize.width && (x = screenSize.width - w) < 0) {
                x = 0;
            }
            if (y > screenSize.height && (y = screenSize.height - h) < 0) {
                y = 0;
            }
            this.setBounds(x, y, w, h);
        } else {
            Dimension frameSize = ApplicationProperties.getConfirmDialogSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setBounds((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2, frameSize.width, frameSize.height);
        }
        int timeOut = ApplicationProperties.getConfirmTimeout();
        if (timeOut > 0) {
            TimerTask task = new TimerTask(){

                public void run() {
                    ToListUI.this.jButtonOKActionPerformed(null);
                }
            };
            confirmTimer.schedule(task, (long)timeOut * 1000L);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jent/checksmtp/Bundle");
        this.setTitle(bundle.getString("ToListUI.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ToListUI.this.formWindowClosing(evt);
            }
        });
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButtonOK.setText(bundle.getString("ToListUI.jButtonOK.text"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToListUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(bundle.getString("ToListUI.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToListUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap(200, Short.MAX_VALUE).add(this.jButtonOK).add(14, 14, 14).add(this.jButtonCancel).addContainerGap()).add(this.jScrollPane1, -1, 376, Short.MAX_VALUE));
        jPanel1Layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().add(this.jScrollPane1, -1, 90, Short.MAX_VALUE).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jButtonOK).add(this.jButtonCancel))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.restorePosition();
        this.resultNotify.sayNG();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.restorePosition();
        this.resultNotify.sayNG();
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.restorePosition();
        this.resultNotify.sayOK();
        this.dispose();
    }

    private boolean restorePosition() {
        Point locationPoint = this.getLocationOnScreen();
        int x = locationPoint.x;
        int y = locationPoint.y;
        int h = this.getHeight();
        int w = this.getWidth();
        boolean modified = false;
        if (x != ApplicationProperties.getConfirmDialogPosX() || y != ApplicationProperties.getConfirmDialogPosY() || h != ApplicationProperties.getConfirmDialogPosH() || w != ApplicationProperties.getConfirmDialogPosW()) {
            modified = true;
            ApplicationProperties.setConfirmDialogPosX(x);
            ApplicationProperties.setConfirmDialogPosY(y);
            ApplicationProperties.setConfirmDialogPosH(h);
            ApplicationProperties.setConfirmDialogPosW(w);
            if (!ApplicationProperties.save()) {
                new MessageDialogUI(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ToListUI.error.Fail_the_properties_file_of_dialog_potition_save."), null, 0);
            }
        }
        return modified;
    }
}

