/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.MessageDialogUI;

public class LDAPSearch {
    private static InitialDirContext ctx = null;
    private static String lastProviderUrl = null;
    private static MessageDialogUI initErrorDialog = null;

    private LDAPSearch() {
    }

    private static synchronized void init() {
        if (ApplicationProperties.getLdap() && (ctx == null || !lastProviderUrl.equals(ApplicationProperties.getLdapProviderURL()))) {
            try {
                if (ctx != null) {
                    LDAPSearch.close();
                }
                System.out.println("init  LDAP connection.");
                lastProviderUrl = ApplicationProperties.getLdapProviderURL();
                Properties env = new Properties();
                env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", lastProviderUrl);
                ctx = new InitialDirContext(env);
            }
            catch (NamingException e) {
                String errorMessage = "LDAPSearch init error.";
                System.err.println(errorMessage);
                lastProviderUrl = null;
                e.printStackTrace();
                LDAPSearch.displayErrorDialog(errorMessage, e);
            }
        }
    }

    private static void displayErrorDialog(String errorMessage, Exception e) {
        if (initErrorDialog == null || !initErrorDialog.isVisible()) {
            initErrorDialog = new MessageDialogUI(errorMessage, e, 0);
        }
    }

    public static synchronized void close() {
        try {
            if (ctx != null) {
                System.out.println("close LDAP connection.");
                ctx.close();
                ctx = null;
            }
        }
        catch (NamingException e) {
            System.err.println("Ignore LDAPSearch close error.");
        }
    }

    public static String search(String mail) {
        String ans = "";
        if (!ApplicationProperties.getLdap()) {
            return ans;
        }
        if (ctx == null || lastProviderUrl != null && !lastProviderUrl.equals(ApplicationProperties.getLdapProviderURL())) {
            LDAPSearch.init();
        }
        Pattern pattern = Pattern.compile("[ \t]+");
        String[] attrNames = pattern.split(ApplicationProperties.getLdapAttributes());
        System.err.println("LDAP Serarch= " + mail + " " + attrNames[0]);
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        ctrl.setTimeLimit(5000);
        ctrl.setCountLimit(3L);
        ctrl.setReturningAttributes(attrNames);
        try {
            NamingEnumeration<SearchResult> mailList = ctx.search(ApplicationProperties.getLdapRoot(), "(mail=" + mail + ")", ctrl);
            while (mailList.hasMore()) {
                SearchResult sr = mailList.next();
                for (int i = 0; i < attrNames.length; ++i) {
                    Attribute attr = sr.getAttributes().get(attrNames[i]);
                    String str = attr == null ? "" : (String)attr.get();
                    if (str == null) {
                        str = "";
                    }
                    if (ApplicationProperties.getLdapIsSjis()) {
                        str = new String(str.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    if (i != 0) {
                        ans = ans + " ";
                    }
                    ans = ans + str;
                }
                System.err.println("ANS=" + ans);
            }
            mailList.close();
        }
        catch (TimeLimitExceededException tlEx) {
            System.out.println("LDAP Search Time Limit.");
        }
        catch (NameNotFoundException nnfEx) {
            System.out.println("LDAP Search Name Not Found.");
        }
        catch (NamingException e) {
            String errorMessage = "LDAP Search Error.";
            System.err.println(errorMessage);
            e.printStackTrace();
            LDAPSearch.close();
            LDAPSearch.displayErrorDialog(errorMessage, e);
        }
        catch (UnsupportedEncodingException ueEx) {
            UnsupportedEncodingException e = ueEx;
            System.err.println("LDAP SJIS Error.");
            e.printStackTrace();
        }
        catch (NullPointerException npEx) {
            String errorMessage = "LDAP Unexpected Error.";
            NullPointerException e = npEx;
            System.err.println(errorMessage);
            e.printStackTrace();
            LDAPSearch.displayErrorDialog(errorMessage, e);
        }
        return ans;
    }
}

