/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ApplicationProperties {
    private static final String PREFIX = "org.jent.checksmtp";
    private static final String SMTP_PORT = "org.jent.checksmtp.port";
    private static final String SMTP_ENEBLE_REMOTE_CONNECT = "org.jent.checksmtp.enableRemoteConnect";
    private static final String SMTP_SERVER_HOST = "org.jent.checksmtp.serverHost";
    private static final String SMTP_SERVER_PORT = "org.jent.checksmtp.serverPort";
    private static final String LDAP_PREFIX = "org.jent.checksmtp.ldap";
    private static final String LDAP_PROVIDER_URL = "org.jent.checksmtp.ldap.providerUrl";
    private static final String LDAP_ROOT = "org.jent.checksmtp.ldap.baseDn";
    private static final String LDAP_IS_SJIS = "org.jent.checksmtp.ldap.isSjis";
    private static final String LDAP_IS_ATTRIBUTES = "org.jent.checksmtp.ldap.attributes";
    private static final String CONFIG_DIALOG_PREFIX = "org.jent.checksmtp.configDialog";
    private static final String CONFIG_DIALOG_POS_X = "org.jent.checksmtp.configDialog.pos.x";
    private static final String CONFIG_DIALOG_POS_Y = "org.jent.checksmtp.configDialog.pos.y";
    private static final String CONFIG_DIALOG_POS_W = "org.jent.checksmtp.configDialog.pos.w";
    private static final String CONFIG_DIALOG_POS_H = "org.jent.checksmtp.configDialog.pos.h";
    private static final String CONFIRM_DIALOG_PREFIX = "org.jent.checksmtp.confirmDialog";
    private static final String CONFIRM_DIALOG_POS_X = "org.jent.checksmtp.confirmDialog.pos.x";
    private static final String CONFIRM_DIALOG_POS_Y = "org.jent.checksmtp.confirmDialog.pos.y";
    private static final String CONFIRM_DIALOG_POS_W = "org.jent.checksmtp.confirmDialog.pos.w";
    private static final String CONFIRM_DIALOG_POS_H = "org.jent.checksmtp.confirmDialog.pos.h";
    private static final String PROPERTIES_FILENAME = ".checksmtp.properties";
    private static Properties applicationProperties = new Properties();
    private static String fileName = ".checksmtp.properties";
    private static boolean isFileLoaded = false;

    public static boolean isFileLoaded() {
        return isFileLoaded;
    }

    private ApplicationProperties() {
    }

    public static boolean save() {
        boolean resultOK = true;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            applicationProperties.store(fos, "Appliction Properties");
            fos.close();
        }
        catch (IOException e) {
            resultOK = false;
            System.err.println(fileName + "was occrred save error.");
            e.printStackTrace();
        }
        return resultOK;
    }

    public static String getSmtpServerHost() {
        return applicationProperties.getProperty(SMTP_SERVER_HOST, "mail");
    }

    public static void setSmtpServerHost(String obj) {
        applicationProperties.setProperty(SMTP_SERVER_HOST, obj);
    }

    public static int getSmtpServerPort() {
        return Integer.parseInt(applicationProperties.getProperty(SMTP_SERVER_PORT, "25"));
    }

    public static void setSmtpServerPort(int port) {
        applicationProperties.setProperty(SMTP_SERVER_PORT, new Integer(port).toString());
    }

    public static int getSmtpPort() {
        return Integer.parseInt(applicationProperties.getProperty(SMTP_PORT, "8725"));
    }

    public static void setSmtpPort(int port) {
        applicationProperties.setProperty(SMTP_PORT, new Integer(port).toString());
    }

    public static boolean getSmtpEnebleRemoteConnect() {
        String str = applicationProperties.getProperty(SMTP_ENEBLE_REMOTE_CONNECT);
        return new Boolean(str);
    }

    public static void setSmtpEnableRemoteConnect(boolean obj) {
        applicationProperties.setProperty(SMTP_ENEBLE_REMOTE_CONNECT, Boolean.toString(obj));
    }

    public static String getLdapProviderURL() {
        return applicationProperties.getProperty(LDAP_PROVIDER_URL, "ldap://localhost:389");
    }

    public static void setLdapProviderURL(String obj) {
        applicationProperties.setProperty(LDAP_PROVIDER_URL, obj);
    }

    public static String getLdapRoot() {
        return applicationProperties.getProperty(LDAP_ROOT, "C=JP");
    }

    public static void setLdapRoot(String obj) {
        applicationProperties.setProperty(LDAP_ROOT, obj);
    }

    public static boolean getLdapIsSjis() {
        return new Boolean(applicationProperties.getProperty(LDAP_IS_SJIS));
    }

    public static void setLdapIsSjis(boolean obj) {
        applicationProperties.setProperty(LDAP_IS_SJIS, Boolean.toString(obj));
    }

    public static boolean getLdap() {
        String str = applicationProperties.getProperty(LDAP_PREFIX);
        Boolean flg = new Boolean(str);
        return flg;
    }

    public static void setLdap(boolean obj) {
        applicationProperties.setProperty(LDAP_PREFIX, Boolean.toString(obj));
    }

    public static String getLdapAttributes() {
        return applicationProperties.getProperty(LDAP_IS_ATTRIBUTES, "cn");
    }

    public static void setLdapAttributes(String obj) {
        applicationProperties.setProperty(LDAP_IS_ATTRIBUTES, obj);
    }

    public static Dimension getConfigurationDialogSize() {
        Dimension resultDimension = new Dimension(ApplicationProperties.getConfigDialogPosW(), ApplicationProperties.getConfigDialogPosH());
        return resultDimension;
    }

    public static int getConfigDialogPosX() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_X, "0"));
    }

    public static void setConfigDialogPosX(int x) {
        applicationProperties.setProperty(CONFIG_DIALOG_POS_X, new Integer(x).toString());
    }

    public static int getConfigDialogPosY() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_Y, "0"));
    }

    public static void setConfigDialogPosY(int y) {
        applicationProperties.setProperty(CONFIG_DIALOG_POS_Y, new Integer(y).toString());
    }

    public static int getConfigDialogPosW() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_W, "400"));
    }

    public static void setConfigDialogPosW(int w) {
        applicationProperties.setProperty(CONFIG_DIALOG_POS_W, new Integer(w).toString());
    }

    public static int getConfigDialogPosH() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_H, "232"));
    }

    public static void setConfigDialogPosH(int h) {
        applicationProperties.setProperty(CONFIG_DIALOG_POS_H, new Integer(h).toString());
    }

    static Dimension getConfirmDialogSize() {
        Dimension resultDimension = new Dimension(ApplicationProperties.getConfirmDialogPosW(), ApplicationProperties.getConfirmDialogPosH());
        return resultDimension;
    }

    public static int getConfirmDialogPosX() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIG_DIALOG_POS_X, "0"));
    }

    public static void setConfirmDialogPosX(int x) {
        applicationProperties.setProperty(CONFIRM_DIALOG_POS_X, new Integer(x).toString());
    }

    public static int getConfirmDialogPosY() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_Y, "0"));
    }

    public static void setConfirmDialogPosY(int y) {
        applicationProperties.setProperty(CONFIRM_DIALOG_POS_Y, new Integer(y).toString());
    }

    public static int getConfirmDialogPosW() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_W, "400"));
    }

    public static void setConfirmDialogPosW(int w) {
        applicationProperties.setProperty(CONFIRM_DIALOG_POS_W, new Integer(w).toString());
    }

    public static int getConfirmDialogPosH() {
        return Integer.parseInt(applicationProperties.getProperty(CONFIRM_DIALOG_POS_H, "177"));
    }

    public static void setConfirmDialogPosH(int h) {
        applicationProperties.setProperty(CONFIRM_DIALOG_POS_H, new Integer(h).toString());
    }

    static {
        try {
            fileName = System.getProperty("user.home") + File.separator + PROPERTIES_FILENAME;
            FileInputStream is = new FileInputStream(fileName);
            applicationProperties.load(is);
            isFileLoaded = true;
            is.close();
        }
        catch (IOException e) {
            System.err.println("No checksmtp.properties in " + fileName);
        }
    }
}

