// DialogTree.h cc[r[_CAO
#ifndef __WXC_DIALOGTREE__
#define __WXC_DIALOGTREE__

#include "wxc.h"
#include "../Dialog.h"
#include "../TreeCtrl.h"


_WXC_BEGIN                              // namespace wxc {

// 1JeS̍őRg[
#define DIALOG_TREE_MAX_CONTROLS    16


class DialogTree : public wgc::Dialog
{
public:
	typedef struct tagCATEGORY
	{
		UINT uID;                                     // ID
		UINT uIDParent;                               // eIDiȂꍇ0j
		UINT uIDControlArray[DIALOG_TREE_MAX_CONTROLS];   // Rg[ID̔z
	} CATEGORY;

	DialogTree(
		const UINT uIDTree, const UINT uIDGroup,
		const CATEGORY arCategory[], const UINT uCategoryCount,
		HINSTANCE hResource, LPCTSTR lpTemplate, HWND hWndParent = NULL);
	~DialogTree(void);

protected:
	BOOL OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam);
	BOOL OnNotify(const int nIdCtrl, LPNMHDR lpNmHeader);

private:
	const UINT      m_uIDTree;
	const UINT      m_uIDGroup;
	const CATEGORY *m_pCategory;
	const UINT      m_uCategoryCount;

	wgc::TreeCtrl m_treeCategory;

	void ShowCategoryControls(const LONG_PTR nCategoryIndex, const BOOL bShow /* = TRUE */);

	// ʒmbZ[W
	BOOL OnSelchangedTreeCategory(NMHDR* pNMHDR);

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(DialogTree)
};

_WXC_END                                // }

#endif // __WXC_DIALOGTREE__
