// DialogPropertySheet.h cvpeBV[g
#ifndef __WGC_DIALOGPROPERTYSHEET__
#define __WGC_DIALOGPROPERTYSHEET__

#include "./DialogPropertyPage.h"
#include <vector>


#define IDAPPLY (12321)                 // Kp{^ID

_WGC_BEGIN                              // namespace wgc {


class DialogPropertySheet : public Dialog
{
public:
	DialogPropertySheet(const UINT uCaptionID, HINSTANCE hResource, HWND hWndParent = NULL, const UINT nStartPage = 0, const DWORD dwPshFlags = PSH_DEFAULT);
	~DialogPropertySheet(void);

	INT_PTR DoModal   (const LPARAM dwInitParam = 0);   // [_\
	BOOL    DoModeless(const LPARAM dwInitParam = 0);   // [hX\

protected:
	typedef DialogPropertyPage *LPPROPPAGE_OBJ;

	void SetSheets(LPPROPPAGE_OBJ pPageArray[], const int nSheetCount);
	void SetPSH(PROPSHEETHEADER &psh) const;

	// Iy[V
	HWND GetTabControl(void) const;
	int  GetCurSel(void) const;
/*
	PropSheet_SetCurSel(hDlg, hpage, index)
	PropSheet_RemovePage(hDlg, index, hpage)
	PropSheet_AddPage(hDlg, hpage)
	PropSheet_Changed(hDlg, hwnd)
	PropSheet_RestartWindows(hDlg)
	PropSheet_RebootSystem(hDlg)
	PropSheet_CancelToClose(hDlg)
	PropSheet_QuerySiblings(hDlg, wParam, lParam)
	PropSheet_UnChanged(hDlg, hwnd)
	PropSheet_Apply(hDlg)
	PropSheet_SetTitle(hDlg, wStyle, lpszText)
	PropSheet_SetWizButtons(hDlg, dwFlags)
*/

	// TuNX
	void Subclass(HWND hWnd);
	void Unsubclass(void);

	// z֐
	void AssociateDialogControls(void) {}
	void UpdateData(const BOOL /* bUpdate */ = TRUE) {}

	// _CAOvV[W
	LRESULT _Default(void);
	BOOL OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl);

	void OnOK(void);                        // OK{^
	void OnCancel(void);                    // LZ{^
	virtual void OnApply(void);             // Kp{^
	virtual void OnHelp(void);              // wv{^

private:
	UINT      m_uCaptionID;	                // _CAOLvṼ\[XID
	UINT      m_nStartPage;                 // PROPSHEETHEADER::nStartPage ̒l
	DWORD     m_dwPshFlags;	                // PROPSHEETHEADER::dwFlags ̒l

	tstring_t m_caption;
	std::vector<PROPSHEETPAGE> m_vPropSheetPage;

	// Rs[RXgN^AZq͎gps
	DISABLE_COPY(DialogPropertySheet)
};

_WGC_END                                // }

#endif // __WGC_DIALOGPROPERTYSHEET__
