// Station.h c풓EChE
#ifndef __STATION__
#define __STATION__

#include "WinMain.h"
#include "MainFrame.h"
#include "FrameThread.h"


////////////////////////////////////////////////////////////////////////////////
// \

// Lf[^
typedef struct tagSHARED_DATA
{
	TCHAR szCommandLine[MAX_PATH];
} SHARED_DATA, *LPSHARED_DATA;

// obNAbvf[^
typedef struct tagBACKUP
{
	TCHAR szFileName[MAX_PATH];
	DWORD dwCodePage;
} BACKUP;
typedef std::list<BACKUP> BACKUP_LIST_T;


// 풓EChE
class Station : public wgc::Window
{
public:
	// EChENX̓o^
	static void Register(void);
	static Station *CreateStation(const int nCmdShow, LPCTSTR lpCmdLine = NULL);

	static HWND FindStation(void);
	static void PostCommandLine(HWND hWnd, LPCTSTR lpCmdLine);

	static void CreateFrameThread(CREATEFRAME_PARAMETER *lpCreateFrameParameter = NULL);

	void NotifyExitFrameThread(FrameThread *pFrameThread);
	void SendHelpMessage      (const UINT uCommand);

protected:
	static LONG m_lThreadCount;
	static wgc::SharedMemory<SHARED_DATA> m_cSharedMemory;

	Station(void);

	UINT CheckBackup(void);

	////////////////////////////////////////////////////////////
	// EChEvV[W
	LRESULT WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam);

	////////////////////////////////////////////////////////////
	// bZ[Wnh
	void OnClose(void);
	void OnDestroy(void);

	void OnPostCommandLine      (void);
	void OnNotifyExitFrameThread(FrameThread *pFrameThread);
	void OnHelpMessage          (const UINT uCommand);

	////////////////////////////////////////////////////////////
	// R}hC̉

	typedef struct tagARGUMENT_INFO
	{
		int begin;                              // ̐擪̃ItZbg
		int length;                             // ̒
		int next;                               // ̈̃ItZbg
	} ARGUMENT_INFO;

	void ParseCommandLine(const int nCmdShow, LPCTSTR lpCmdLine, const BOOL bNeedNewFrame = TRUE);
	BOOL ExtractArgument (LPCTSTR lpCmdLine, ARGUMENT_INFO &rInfo);
};

#endif // __STATION__
