// EditDoc.cpp cCve[Vt@C
#include "EditDoc.h"
#include "EditView.h"
#include "component/wgc/wgfunc.h"       // wgc::wgfMultiByteToWideChar()
#include <algorithm>                    // std::swap()
#include <assert.h>                     // assert()


////////////////////////////////////////////////////////////
// RXgNV

// RXgN^
EditDoc::EditDoc(
	wgc::Window       *pMainFrame,
	const EDITVIEW_PROPERTY &rProperty,
	HCURSOR            hCursorMargin /* = NULL */)
	: m_pMainFrame(pMainFrame), m_property(rProperty),
	  m_pActiveView(NULL),
	  m_hCursorMargin(hCursorMargin),
	  m_hFont(NULL),
	  m_bDropSource(FALSE)
{
	m_hFont = CreateInfoFont(m_property.infoText.font);
}

// fXgN^
EditDoc::~EditDoc(void)
{
	// r[͔jƂɎgdeletêŁAdeletesKv͂Ȃ
	m_pActiveView = NULL;

	::DeleteObject(m_hFont);
	m_hFont = NULL;
}

BOOL EditDoc::CreateView(
	const BOOL bSetFocus,
	const DWORD dwStyle, const DWORD dwExStyle,
	const UINT nID,
	wgc::Window *pParent /* = NULL */,
	HINSTANCE hInstance /* = NULL */,
	const int x /* = CW_USEDEFAULT */,
	const int y /* = CW_USEDEFAULT */,
	const int nWidth  /* = CW_USEDEFAULT */,
	const int nHeight /* = CW_USEDEFAULT */)
{
	EditView *pView = new EditView(*this, m_property, m_hCursorMargin, m_hFont);
	const BOOL bResult = pView->Create(
		dwStyle, dwExStyle,
		(pParent != NULL) ? pParent : m_pMainFrame,
		nID,
		hInstance,
		x, y,
		nWidth, nHeight);

	if(!bResult) { return FALSE; }

	m_listView.push_back(pView);
	if(bSetFocus || m_pActiveView == NULL)
	{
		SetFocusTo(nID);
	}
	return TRUE;
}

void EditDoc::DestroyView(const UINT nID)
{
	EditView *pView = GetViewFromID(nID);
	if(pView == NULL)
	{
		return;
	}

	pView->DestroyWindow();
	if(m_pActiveView == pView)
	{
		// ANeBuȃr[AXg̐擪̃r[ANeBuƂ
		m_pActiveView = m_listView.front();
		SetFocusTo();
	}
}


// TCY
void EditDoc::ResizeWindow(const int nID, const RECT &rRect)
{
	EditView *pView = GetViewFromID(nID);
	if(pView == NULL)
	{
		return;
	}

	pView->MoveWindow(
		rRect.left, rRect.top,
		rRect.right - rRect.left, rRect.bottom - rRect.top);
}

// tH[JXړ
void EditDoc::SetFocusTo(const int nID /* = -1 */)
{
	EditView *pView = NULL;
	if(nID != -1)
	{
		pView = GetViewFromID(nID);
	}

	if(pView == NULL)
	{
		pView = m_pActiveView;
	}

	assert(pView != NULL);
	m_pActiveView = pView;
	pView->SetFocus();
}

// r[̃vpeBύX
void EditDoc::SetViewProperty(const EDITVIEW_PROPERTY &rProperty, const KEYWORD_INFO &rKeyword)
{
	m_property = rProperty;
	m_keyword  = rKeyword;

	// {block}
	// tHgύX
	{
		::DeleteObject(m_hFont);
		m_hFont = CreateInfoFont(m_property.infoText.font);
	}

	for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		pView->SetProperty(m_property, m_keyword, m_hFont);
	}
}

void EditDoc::InvalidateAllViews(void)
{
	// ׂẴr[𖳌
	for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		pView->Invalidate();
	}

	// Jbg̈ʒuĐݒ
	m_pActiveView->ResetCaretPos();
}


////////////////////////////////////////////////////////////////////////////////
// 

// ݍsi1 originj擾
INT_PTR EditDoc::GetNowLine(void) const
{
	return GetY() + 1;
}

// wsi1 originjփWv
void EditDoc::JumpToLine(const INT_PTR nLineNumber)
{
	// sԍC
	INT_PTR nCorrectedLineNumber = nLineNumber;
	if(nCorrectedLineNumber < 1) { nCorrectedLineNumber = 1; }

	// Wv
	const position_t position = {0, nCorrectedLineNumber - 1};
	SetXY(position);

	PostModify(0);
}

// hbOhbvJn
void EditDoc::DragBegin(void)
{
	m_bDropSource = TRUE;
}

// hbOhbvI
void EditDoc::DragEnd(void)
{
	m_bDropSource = FALSE;
}

// ݃hbv\[XH
BOOL EditDoc::IsDropSource(void) const
{
	return m_bDropSource;
}


////////////////////////////////////////////////////////////////////////////////
// edit_manager ̃bp{

////////////////////////////////////////////////////////////
// 

// s擾
SIZE_T EditDoc::GetLineCount(void) const
{
	return m_manager.get_line_count();
}

// ݈ʒu擪H
BOOL EditDoc::IsBegin(void) const
{
	return m_manager.is_begin();
}

// ݈ʒuH
BOOL EditDoc::IsEnd(void) const
{
	return m_manager.is_end();
}


////////////////////////////////////////////////////////////
// ͈ʒu̎擾/ݒ

EditDoc::position_t EditDoc::SetCaretPosition(void) const
{
	return GetXY();
}

void EditDoc::SetCaretPosition(const position_t &position)
{
	SetXY(position);
	m_pActiveView->OnSyncCaret();
}


////////////////////////////////////////////////////////////
// Ce[^̎擾

EditDoc::const_iterator_t EditDoc::GetIterator(const linenumber_t linenumber) const
{
	return m_manager.get_iterator(linenumber);
}

EditDoc::const_iterator_t EditDoc::GetIteratorBegin(void) const
{
	return m_manager.get_iterator_begin();
}

EditDoc::const_iterator_t EditDoc::GetIteratorEnd(void) const
{
	return m_manager.get_iterator_end();
}

EditDoc::const_iterator_t EditDoc::GetIteratorNow(void) const
{
	return m_manager.get_iterator_now();
}


////////////////////////////////////////////////////////////
// ̐ݒ/擾

// ֎~̐ݒ
BOOL EditDoc::SetReadOnly(const BOOL bReadOnly /* = TRUE */)
{
	m_manager.set_readonly(bReadOnly != FALSE);

	// {block}
	// ׂẴr[ ES_READONLY X^Cǉ/폜
	{
		DWORD dwRemove = 0;
		DWORD dwAdd    = ES_READONLY;
		if(!bReadOnly)
		{
			std::swap(dwRemove, dwAdd);
		}

		for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
		{
			EditView *pView = *p;
			assert(pView != NULL);

			pView->ModifyStyle(dwRemove, dwAdd, 0, 0);
		}
	}
	SendNotifyCommandToMainFrame(XEN_READONLYCHANGED);

	return TRUE;
}

// ֎~Ԃ𔽓]
BOOL EditDoc::ToggleReadOnly(void)
{
	const BOOL bReadOnly = IsReadOnly();
	return SetReadOnly(!bReadOnly);
}

// ֎~H
BOOL EditDoc::IsReadOnly(void) const
{
	return m_manager.is_readonly();
}

// ㏑̐ݒ
BOOL EditDoc::SetOverwrite(const BOOL bOverwrite /* = TRUE */)
{
	m_manager.set_overwrite(bOverwrite != FALSE);
	SendNotifyCommandToMainFrame(XEN_OVERWRITECHANGED);
	return TRUE;
}

// ㏑Ԃ𔽓]
BOOL EditDoc::ToggleOverwrite(void)
{
	const BOOL bOverwrite = IsOverwrite();
	return SetOverwrite(!bOverwrite);
}

// ㏑H
BOOL EditDoc::IsOverwrite(void) const
{
	return m_manager.is_overwrite();
}

// _[eB[tO̐ݒ
BOOL EditDoc::SetModify(const BOOL bModify /* = TRUE */)
{
	// obt@̓ǂݎpݒ
	m_manager.set_modify(bModify != FALSE);
	SendNotifyCommandToMainFrame(XEN_MODIFYCHANGED);
	return TRUE;
}

// obt@ύXĂ邩H
BOOL EditDoc::IsModified(void) const
{
	return m_manager.is_modified();
}


////////////////////////////////////////////////////////////////////////////////
// Nbv{[h֘A

// ؂
void EditDoc::Cut(void)
{
	// I͈͂؂ANbv{[hɃRs[
	Copy();
	Clear();
}

// Rs[
void EditDoc::Copy(void)
{
	if(!m_pMainFrame->OpenClipboard()) { return; }

	::EmptyClipboard();
	{
		// Unicode`őIꂽf[^擾
		wgc::wstring_t wstr;
		GetSelectedTextW(wstr);

		// {block}
		// Unicode`̃f[^Nbv{[hɊi[
		{
			const SIZE_T nSize = (wstr.length() + 1) * sizeof(wchar_t);
			SetClipboard(CF_UNICODETEXT, wstr.c_str(), nSize);
		}

#ifndef UNICODE
		// {block}
		// ANSI`łi[
		{
			wgc::string_t str;
			wgc::wgfWideCharToMultiByte(wstr, str);

			const SIZE_T nSize = str.length() + 1;
			SetClipboard(CF_TEXT, str.c_str(), nSize);
		}
#endif
	}
	::CloseClipboard();
}

// 
void EditDoc::Clear(void)
{
}

// \t
void EditDoc::Paste(void)
{
	if(IsReadOnly()) { return; }
	if(!m_pMainFrame->OpenClipboard()) { return; }

	// {block}
	// Unicode`Ńf[^擾
	{
		HANDLE hData = ::GetClipboardData(CF_UNICODETEXT);
		if(hData != NULL)
		{
			// f[^擾
			LPCVOID lpData = ::GlobalLock(hData);
			LPCWSTR lpText = reinterpret_cast<LPCWSTR>(lpData);
			{
				const wgc::wstring_t wtext = lpText;
				InsertText(wtext.c_str(), wtext.length());
			}
			::GlobalUnlock(hData);
			goto end;
		}
	}

#ifndef UNICODE
	// {block}
	// ANSI`Ńf[^擾
	{
		HANDLE hData = ::GetClipboardData(CF_TEXT);
		if(hData != NULL)
		{
			// f[^擾
			LPCVOID lpData = ::GlobalLock(hData);
			LPCSTR  lpText = reinterpret_cast<LPCSTR>(lpData);
			{
				wgc::wstring_t wtext;
				wgc::wgfMultiByteToWideChar(lpText, wtext);

				InsertText(wtext.c_str(), wtext.length());
			}
			::GlobalUnlock(hData);
			goto end;
		}
	}
#endif

end:
	::CloseClipboard();
}

// \tł邩H
BOOL EditDoc::CanPaste(const UINT uFormat /* = 0 */) const
{
	// uFormat 0ȊÔƂ́AuFormat 𒲂ׂ
	if(uFormat != 0)
	{
		// CF_TEXT ` CF_UNICODETEXT `Ȃy[Xg\
		return (uFormat == CF_TEXT) || (uFormat == CF_UNICODETEXT);
	}
	// uFormat 0̂Ƃ́ANbv{[h̃f[^𒲂ׂ
	else
	{
		// NTnOSł́AO CF_TEXT Ŕ\B
		// 9xnOSłʏ CF_TEXT ł悢A
		// CF_UNICODETEXT `Ŋi[Av邩Ȃ̂
		// ̏ꍇ͌㔼Ŕ肵ĂB
		return ::IsClipboardFormatAvailable(CF_TEXT) || ::IsClipboardFormatAvailable(CF_UNICODETEXT);
	}
}


////////////////////////////////////////////////////////////////////////////////
// ҏW

////////////////////////////////////////////////////////////
// AhDEhD

// AhD
BOOL EditDoc::Undo(void)
{
	sgc::edit_manager::modify_info mi;
	if(!m_manager.undo(mi)) { return FALSE; }

	PostModify(mi.modified_line + 1, mi.is_modified_linecount);
	return TRUE;
}

// hD
BOOL EditDoc::Redo(void)
{
	sgc::edit_manager::modify_info mi;
	if(!m_manager.redo(mi)) { return FALSE; }

	PostModify(mi.modified_line + 1, mi.is_modified_linecount);
	return TRUE;
}

// AhDł邩H
BOOL EditDoc::CanUndo(void) const
{
	return m_manager.can_undo();
}

// hDł邩H
BOOL EditDoc::CanRedo(void) const
{
	return m_manager.can_redo();
}

// őAhD񐔂ݒ
INT_PTR EditDoc::SetUndoLimit(const INT_PTR nLimit /* = -1 */)
{
	return m_manager.set_undo_limit(nLimit);
}

void EditDoc::EmptyUndoBuffer(void)
{
	m_manager.empty_undo_buffer();
}


////////////////////////////////////////////////////////////
// obt@

// steLXgobt@ɃZbgAhDobt@NA
BOOL EditDoc::SetText(LPCWSTR lpText, const SIZE_T lSize)
{
	if(m_manager.set_text(lpText, lSize))
	{
		for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
		{
			EditView *pView = *p;
			assert(pView != NULL);

			pView->m_ptLogicalPrev.x = 0;
			pView->m_ptLogicalPrev.y = 0;
			pView->m_nLineNumberTop  = 1;
			pView->m_nColumnLeft     = 0;
		}

		// Ԃ
		SetReadOnly(FALSE);

		PostModify(1, TRUE);
		return TRUE;
	}
	return FALSE;
}

// eLXgis܂ށj݈ʒuɑ}
BOOL EditDoc::InsertText(LPCWSTR lpText, const SIZE_T lSize)
{
	sgc::edit_manager::modify_info mi;
	if(m_manager.insert_text(lpText, lSize, mi))
	{
		PostModify(mi.modified_line + 1, mi.is_modified_linecount);
		return TRUE;
	}
	return FALSE;
}

// s݈ʒuɑ}
BOOL EditDoc::InsertLinefeed(void)
{
	sgc::edit_manager::modify_info mi;
	if(m_manager.insert_linefeed(mi))
	{
		PostModify(mi.modified_line + 1, mi.is_modified_linecount);
		return TRUE;
	}
	return FALSE;
}

// isȂj𑗐Mi}㏑̓GWŎfj
BOOL EditDoc::SendString(const wgc::wstring_t &wstr)
{
	sgc::edit_manager::modify_info mi;
	if(m_manager.send_string(wstr.c_str(), wstr.length(), mi))
	{
		PostModify(mi.modified_line + 1, mi.is_modified_linecount);
		return TRUE;
	}
	return FALSE;
}

// ݈ʒủEɂ镶폜
BOOL EditDoc::DeleteChar(const BOOL bLeft /* = TRUE */)
{
	sgc::edit_manager::modify_info mi;
	if(m_manager.delete_char(bLeft != FALSE, mi))
	{
		PostModify(mi.modified_line + 1, mi.is_modified_linecount);
		return TRUE;
	}
	return FALSE;
}


// IĂ邩H
BOOL EditDoc::IsSelected(void) const
{
	return m_manager.is_selected();
}

// I𕶎擾
void EditDoc::GetSelectedText(wgc::tstring_t &tstr) const
{
#ifndef UNICODE
	GetSelectedTextA(tstr);
#else
	GetSelectedTextW(tstr);
#endif
}

// I𕶎擾iANSIj
void EditDoc::GetSelectedTextA(wgc::string_t &str) const
{
	wgc::wstring_t wstr;
	GetSelectedTextW(wstr);

	wgc::wgfWideCharToMultiByte(wstr, str);
}

// I𕶎擾iUnicodej
void EditDoc::GetSelectedTextW(wgc::wstring_t &wstr) const
{
	m_manager.select_get_string(wstr);
}


////////////////////////////////////////////////////////////
// ̑

// ĕϊ
void EditDoc::Reconvert(void)
{
	EditView *pActiveView = m_pActiveView;
	assert(pActiveView != NULL);

	pActiveView->Reconversion();
}


////////////////////////////////////////////////////////////////////////////////
// Jbgʒuir[Ƃ̘AgȂj

EditDoc::position_t EditDoc::GetXY(void) const
{
	return m_manager.get_xy();
}

void EditDoc::SetXY(const position_t &position)
{
	m_manager.set_xy(position);
}

INT_PTR EditDoc::GetX(void) const
{
	return m_manager.get_x();
}

INT_PTR EditDoc::GetY(void) const
{
	return m_manager.get_y();
}

INT_PTR EditDoc::SetX(const INT_PTR x)
{
	return m_manager.set_x(x);
}

INT_PTR EditDoc::SetY(const INT_PTR y)
{
	return m_manager.set_y(y);
}

INT_PTR EditDoc::SetXRelative(const INT_PTR dx)
{
	INT_PTR x = GetX() + dx;
	if(x < 0) { x = 0; }

	return SetX(x);
}

INT_PTR EditDoc::SetYRelative(const INT_PTR dy)
{
	INT_PTR y = GetY() + dy;
	if(y < 0) { y = 0; }

	return SetY(y);
}


////////////////////////////////////////////////////////////////////////////////
// r[Ƃ̘Ag

// IDr[擾
EditView *EditDoc::GetViewFromID(const int nID) const
{
	for(viewlist_const_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		if(pView->GetDlgCtrlID() == nID)
		{
			return pView;
		}
	}
	// ȂNULLԂ
	return NULL;
}

void EditDoc::PostModify(const linenumber_t lineModify, const BOOL bUpdateLineNumber /* = FALSE */)
{
	for(viewlist_iterator_t p = m_listView.begin(); p != m_listView.end(); p++)
	{
		EditView *pView = *p;
		assert(pView != NULL);

		pView->OnSyncBuffer(lineModify, bUpdateLineNumber);
	}

	// eEChEɒʒm
	SendNotifyCommandToMainFrame(XEN_MODIFYCHANGED);
}


// Ct[ɒʒmbZ[W𑗐M
LRESULT EditDoc::SendNotifyCommandToMainFrame(const WORD wNotify)
{
	const NMHDR nmHeader = {NULL, 0, wNotify};
	return m_pMainFrame->SendMessage(
		WM_NOTIFY,
		0, reinterpret_cast<LPARAM>(&nmHeader));
}


// tHgƃTCYtHg쐬
HFONT EditDoc::CreateInfoFont(const FONT_INFO &info)
{
	LOGFONT lf = {0};
	lf.lfEscapement     = 0;
	lf.lfOrientation    = 0;
	lf.lfWeight         = info.flags.elements.bBold ? FW_BOLD : FW_DONTCARE;
	lf.lfItalic         = info.flags.elements.bItalic;
	lf.lfUnderline      = info.flags.elements.bUnderline;
	lf.lfStrikeOut      = info.flags.elements.bStrikeOut;
	lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
	lf.lfQuality        = DEFAULT_QUALITY;
	lf.lfPitchAndFamily = VARIABLE_PITCH | FF_DONTCARE;
	lf.lfCharSet        = DEFAULT_CHARSET;

	::lstrcpyn(lf.lfFaceName, info.szFaceName, countof(lf.lfFaceName));

	// {block}
	// ƍvZ
	{
		wgc::DeviceContext_Client dc(NULL);
		lf.lfWidth  = 0;
		lf.lfHeight = -static_cast<LONG>(info.fPointSize * dc.GetDeviceCaps(LOGPIXELSY) / 72 + 0.5);
	}

	return ::CreateFontIndirect(&lf);
}

// Nbv{[hɃf[^u
BOOL EditDoc::SetClipboard(const CLIPFORMAT cfFormat, LPCVOID lpData, const SIZE_T nSize)
{
	HANDLE hData     = ::GlobalAlloc(GMEM_MOVEABLE, nSize);
	LPVOID lpDataDst = ::GlobalLock(hData);
	{
		::CopyMemory(lpDataDst, lpData, nSize);
	}
	::GlobalUnlock(hData);

	HANDLE hResult = ::SetClipboardData(cfFormat, hData);
	if(hResult == NULL)
	{
		return FALSE;
	}
	return TRUE;
}
