// Edit.h cGfBbgR|[lg
#ifndef __EDIT__
#define __EDIT__

#include "Common.h"
#include "./component/sgc/charcode.h"
#include "./component/sgc/keyword_manager.h"

#include <vector>                       // std::vector<>

// OQ
class EditDoc;
class EditView;


// tHg
typedef struct tagFONT_INFO
{
	// tO
	union
	{
		DWORD dwAll;
		struct
		{
			BOOL bUnderline : 1;                    // A_[C
			BOOL bBold      : 1;                    // 
			BOOL bItalic    : 1;                    // Α
			BOOL bStrikeOut : 1;                    // ł
		} elements;
	} flags;

	TCHAR  szFaceName[32];
	DOUBLE fPointSize;
} FONT_INFO;

// tHgF
typedef struct tagFONT_COLOR
{
	COLORREF colorText;
	COLORREF colorBack;
} FONT_COLOR;

// eLXgGÃvpeB
typedef struct tagTEXT_PROPERTY
{
	// tO
	union
	{
		DWORD dwAll;
		struct
		{
			BOOL bOpenIME           : 1;            // IMEN
			BOOL bDrawMarkLF        : 1;            // s}[N`
			BOOL bDrawMarkSpace     : 1;            // 󔒃}[N`
			BOOL bDrawMarkWideSpace : 1;            // Sp󔒃}[N`
			BOOL bDrawMarkTab       : 1;            // ^u}[N`
			BOOL bDrawMarkEOF       : 1;            // EOF}[N`
		} elements;
	} flags;

	UINT nTabSize;                          // ^u
	UINT nLineSpace;                        // sԊu
	UINT nCharSpace;                        // Ԋu

	UINT nLeftMargin;                       // ]
	UINT nRightMargin;                      // E]

	FONT_INFO font;                         // tHg

	// F
	COLORREF colorLine;                     // r̐F
} TEXT_PROPERTY;

// sԍGÃvpeB
typedef struct tagLINENUMBER_PROPERTY
{
	UINT nMargin;                           // E]
} LINENUMBER_PROPERTY;

// [[GÃvpeB
typedef struct tagRULER_PROPERTY
{
	UINT nHeight;                           // 
	UINT nStride;                           // Ԋu
} RULER_PROPERTY;


// GfBbgr[̃vpeBiu݂̐ݒ̃vpeBvɎgpj
typedef struct tagEDITVIEW_PROPERTY
{
	// ݒ薼
	TCHAR szSettingName[MAX_PATH];
	TCHAR szFilter     [MAX_PATH];
	TCHAR szDefaultExt [MAX_PATH];

	// tO
	union
	{
		DWORD dwAll;
		struct
		{
			unsigned bDisplayRuler      : 1;        // [[\
			unsigned bDisplayLineNumber : 1;        // sԍ\
			unsigned bDisplayUnderline  : 1;        // ݍsɉ\

			unsigned bAlwaysUseDefaultLFCode : 1;   // ɋK̉sR[hgp
		} elements;
	} flags;

	// ftHg
	sgc::charcode_linefeed_t lfDefault;     // ftHg̉sR[h
	int                      csDefault;     // ftHg̕Zbg

	// ë̃vpeB
	TEXT_PROPERTY       infoText;
	LINENUMBER_PROPERTY infoLineNumber;
	RULER_PROPERTY      infoRuler;

	// tHg̐F
	FONT_COLOR fcDefault;
	FONT_COLOR fcSelect;
	FONT_COLOR fcMark;
	FONT_COLOR fcLineNumber;
	FONT_COLOR fcRuler;
} EDITVIEW_PROPERTY;


typedef struct tagKEYWORD_INFO
{
	// L[[h}l[W
	sgc::keyword_manager cKeyMan;

	std::vector<FONT_COLOR> foComment;
	std::vector<FONT_COLOR> foLineComment;
} KEYWORD_INFO;

typedef std::vector<EDITVIEW_PROPERTY> EDITVIEW_PROPERTY_vector;
typedef std::vector<KEYWORD_INFO     > KEYWORD_INFO_vector;

// ʒmbZ[W
#define XEN_READONLYCHANGED     0x0001  // ύXꂽiEM_SETREADONLYj
#define XEN_OVERWRITECHANGED    0x0002  // ㏑ύXꂽ
#define XEN_MODIFYCHANGED       0x0003  // _[eBtOύXꂽ

#endif // __WXC_EDIT__
