#include "head.h"
#include <string.h>
#include <stdio.h>
extern struct wcontrol *window_control;
extern struct TASKCTL *task_control;
extern int *fat;
extern struct biosinfo *basic;
void console(void)
{
  int i,j;
  char s[30];
  struct TASK *task=task_now();
  struct CONSOLE cons;
  struct window *window;
  window=task->cons->window;
  task->cons=&cons;
  cons.window=window;
  task->cons->cur_x=0;
  task->cons->cur_y=0;
  task->cons->shift=5;
  task->cons->timer=make_timer();
  setfifo(task->cons->timer,&task->fifo);
  setdata_timer(task->cons->timer,0);
  timer_settime(task->cons->timer,50);
  task->cons->cmdline_count=0;
  for(i=0;i<CONS_FILE_HANDLES;i++){
    task->cons->fhandle[i].flag=0;
  }
  task->fhandle=task->cons->fhandle;
  print(task->cons->window,"console",0,0,SIRO);
  box(task->cons->window,0+task->cons->shift,WINDOW_TITLESIZE+task->cons->shift,((console_xsize)&~8)-task->cons->shift,((console_ysize)&~16),KURO);
  print_cons(task->cons,">>",SIRO);
  
  for(;;){
    io_cli();
    if(fifo_status(&task->fifo)==0){
      task_sleep(task);
      io_sti();
    }else{
      i=fifo_out(&task->fifo);
      io_sti();
      if(i==0){
	box(task->cons->window,
	    task->cons->cur_x+font_xsize,
	    task->cons->cur_y+WINDOW_TITLESIZE+task->cons->shift,
	    task->cons->cur_x+font_xsize+font_xsize,
	    task->cons->cur_y+font_ysize+WINDOW_TITLESIZE+task->cons->shift,
	    KURO);
	setdata_timer(task->cons->timer,1);
	timer_settime(task->cons->timer,50);
      }else if(i==1){
	box(task->cons->window,
	    task->cons->cur_x+font_xsize,
	    task->cons->cur_y+WINDOW_TITLESIZE+task->cons->shift,
	    task->cons->cur_x+font_xsize+font_xsize,
	    task->cons->cur_y+font_ysize+WINDOW_TITLESIZE+task->cons->shift,
	    SIRO);
	setdata_timer(task->cons->timer,0);
	timer_settime(task->cons->timer,50);
      }else if(i==4){
    	cmd_exit(task->cons,fat);
      }
      if(i>=256 && i<=511){
	if(i==(8+256)){
	  if(task->cons->cur_x>task->cons->shift+font_xsize*2){
	    box(task->cons->window,
		task->cons->cur_x+font_xsize,
		task->cons->cur_y+WINDOW_TITLESIZE+task->cons->shift,
		task->cons->cur_x+font_xsize+font_xsize,
		task->cons->cur_y+font_ysize+WINDOW_TITLESIZE+task->cons->shift,
		KURO);
	    task->cons->cmdline_count--;
	    task->cons->cur_x-=font_xsize;
	  }
	}else if(i==(10+256)){
	  task->cons->cmdline[task->cons->cmdline_count]=0;
	  task->cons->cmdline_count=0;
	  cons_newline(task->cons);
	  cons_runcmd(task->cons->cmdline,task->cons,fat);
	  box(task->cons->window,
	      task->cons->cur_x+font_xsize,
	      task->cons->cur_y+WINDOW_TITLESIZE+task->cons->shift,
	      task->cons->cur_x+font_xsize+font_xsize,
	      task->cons->cur_y+font_ysize+WINDOW_TITLESIZE+task->cons->shift,
	      KURO);
	  print_cons(task->cons,">>",SIRO);
	}else{
	  if(task->cons->cur_x<(console_xsize-task->cons->shift*2-font_xsize)){
	    s[0]=i-256;
	    s[1]=0;
	    box(task->cons->window,
		task->cons->cur_x+font_xsize,
		task->cons->cur_y+WINDOW_TITLESIZE+task->cons->shift,
		task->cons->cur_x+font_xsize+font_xsize,
		task->cons->cur_y+font_ysize+WINDOW_TITLESIZE+task->cons->shift,
		KURO);
	    task->cons->cmdline[task->cons->cmdline_count]=i-256;
	    task->cons->cmdline_count++;
	    print_cons(task->cons,s,SIRO);
	  }
	}
      }
    }
  }
}

void open_console(void)
{
  struct TASK *task;
  struct window *window;
  task=task_alloc();
  task->stack=alloc4((struct manager *)(MANAGER_ADDR),64*1024);
  task->tss.esp=task->stack+64*1024;
  task->tss.eip=(int) &console;
  task->tss.es=1*8;
  task->tss.cs=2*8;
  task->tss.ss=1*8;
  task->tss.ds=1*8;
  task->tss.fs=1*8;
  task->tss.gs=1*8;
  fifo_init(&task->fifo,CONS_BUFFER_LENGTH,task);
  window=make_window(DEFAULT_WINDOW_START_POS,(console_xsize)&~8,(console_ysize)&~16,"CONSOLE");
  task->cons->window=window;
  window->task=task;
  window->use|=0x20;
  task_run(task,2,4);
  set_window_to_keywin(window);
  return;
}
void keywin_off(struct window *key_win)
{
  if(key_win!=0){
    write_title(key_win,1);
  }
  return;
}
void keywin_on(struct window *key_win)
{
  if(key_win!=0){
    write_title(key_win,0);
  }
  return;
}
void close_consoletask(struct TASK *task)
{
  free4((struct manager *)(MANAGER_ADDR),task->stack,64*1024);
  free4((struct manager *)(MANAGER_ADDR),(int)task->fifo.buffer,CONS_BUFFER_LENGTH*4);
  io_cli();
  task->flag=TASK_NOT_USING;
  if(task_control->task_fpu==task){
    task_control->task_fpu=0;
  }
  io_sti();
  task_sleep(task);
  return;
}
void close_console(struct window *window)
{
  struct TASK *task=window->task;
  switch_window(window,-1);
  free4((struct manager *)(MANAGER_ADDR),(int)window->buffer,console_xsize*console_ysize*2);
  close_window(window);
  close_consoletask(task);
  return;
}
