/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.commands.AddBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.editpart.TreeNodeEditPart;

import org.apache.commons.beanutils.DynaClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;


public class TreeViewEditPolicy extends ComponentXYLayoutEditPolicy {
	
	public TreeViewEditPolicy() {}
	
	public TreeViewEditPolicy(int style) {
		setFeedBackStyle(style);
	}
	
	protected Command createAddCommand(EditPart child, Object constraint) {
		Object childModel = child.getModel();
		if (!(child instanceof TreeNodeEditPart)) {
			return null;
		}

		MaskatElement host = (MaskatElement) getHost().getModel();
		DynaComponent rootNode = (DynaComponent) ((DynaComponent) host).getChildByTypeIdx(
				Component.class, 0);

		if (rootNode != null) {
			// ルートノードのある場合、ルートノードに追加
			return new AddBasicDefCommand(rootNode, (MaskatElement) childModel);
		}

		return new AddBasicDefCommand(host, (MaskatElement) childModel);
	}

	protected Command getCreateCommand(CreateRequest request) {
		MaskatElement host = (MaskatElement) getHost().getModel();
		Object newObj = request.getNewObject();

		DynaClass dynaClass = ((DynaComponent) newObj).getDynaClass();
		if (!"treeNode".equals(dynaClass.getName())) {
			return null;
		}
		DynaComponent rootNode = (DynaComponent) ((DynaComponent) host).getChildByTypeIdx(
				Component.class, 0);

		if (rootNode != null) {
			// ルートノードのある場合、ルートノードに追加
			return new AddBasicDefCommand(rootNode, (MaskatElement) newObj);
		}

		return new AddBasicDefCommand(host, (MaskatElement) newObj);
	}

	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		return null;
	}
}
