/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.editors.layout.commands.DelBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;


public class TreeNodeComponentEditPolicy extends MaskatComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		MaskatElement model = (MaskatElement) getHost().getModel();
		return new DelBasicDefCommand(model.getParent(), model);
	}

	protected boolean canFeedbackToRequest(Request request) {
		return true;
	}
}
