/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.AddComponentCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;

public class TabItemComponentLayoutEditPolicy extends
		ComponentXYLayoutEditPolicy {

	public TabItemComponentLayoutEditPolicy(int style) {
		super(style);
	}
	
	protected Command getCreateCommand(CreateRequest request) {
		Object model = getHost().getModel();
		Command cmd = null;
		if (model instanceof Component) {
			MaskatElement host = (MaskatElement) model;
			Object node = request.getNewObject();

			EditPart editPart = getHost();
			if (editPart instanceof LayoutElementEditPart) {
				LayoutElementEditPart part = (LayoutElementEditPart) editPart;
				if (!(part.canAddChild((LayoutElement) node))) {
					return null;
				}
			}
			LayoutElementEditPart child = (LayoutElementEditPart)
				getHost().getViewer().getEditPartFactory().createEditPart(null, node);
			
			if (!child.canAddParent(editPart.getModel())) {
				return null;
			}
			cmd = getCreateCommand(host, node);
			
			if (cmd != null && cmd instanceof AddComponentCommand) {
				((AddComponentCommand) cmd).setConstraint((Rectangle) getConstraintFor(request));
			}
		}
		return cmd;
	}

	public Command createAddCommand(EditPart child, Object constraint) {
		Object childModel = child.getModel();
		if (childModel instanceof DynaComponent) {
			String name = ((DynaComponent) childModel).getDynaClass().getName();
			if ("tabItem".equals(name)) {
				return null;
			}
		}
		return super.createAddCommand(child, constraint);
	}

	public Command getCreateCommand(Object parent, Object node) {
		DynaComponent component = (DynaComponent) parent;
		ComponentEditPart editPart = (ComponentEditPart) getHost();
		boolean isTabItem = false;
		if (node instanceof DynaComponent) {
			String name = ((DynaComponent) node).getDynaClass().getName();
			isTabItem = "tabItem".equals(name);
		}
		/* TabItem上にTabItemを配置した場合は親のTabFolderに追加します。 */
		if ("tabItem".equals(component.getDynaClass().getName()) && isTabItem) {
			return editPart.getCreateCommand(component.getParent(), node);
		}
		return editPart.getCreateCommand(parent, node);
	}
}
