/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpart.SplitterEditPart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SplitLineFeedBackEditPolicy extends FeedBackComponentEditPolicy {

	public SplitLineFeedBackEditPolicy() {
		super(0, false);
	}
	
	public void showSourceFeedback(Request request) {
		super.showSourceFeedback(request);
	}

	protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
		IFigure feedback = getDragSourceFeedbackFigure();
		
		PrecisionRectangle rect = new PrecisionRectangle(getInitialFeedbackBounds().getCopy());
		getHostFigure().translateToAbsolute(rect);
		rect.translate(request.getMoveDelta());
		rect.resize(request.getSizeDelta());
		feedback.translateToRelative(rect);
		
		SplitterEditPart parent = (SplitterEditPart) getHost().getParent();
		Component splitter = (Component) parent.getModel();
		Rectangle rect2 = parent.getFigure().getBounds().getCopy();
		
		/* HORIZONTAL */
		if ("h".equals(parent.getOrientation())) {
			int width = splitter.getWidth();
			rect.y = rect2.y;
			rect.x = (rect.x < rect2.x) ? rect2.x : rect.x;
			rect.x = (rect.x > rect2.x + width - rect.width) ?
					rect2.x + width - rect.width : rect.x;
			
			/* VERTICAL */
		} else {
			rect.x = rect2.x;
			rect.y = (rect.y < rect2.y) ? rect2.y : rect.y;
			rect.y = (rect.y > rect2.y + rect2.height - rect.height) ?
					rect2.y + rect2.height - rect.height : rect.y;
		}
		feedback.setBounds(rect);
	}	
}
