/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.widget.rialto.commands.DelRadioCommand;

public class RadioComponentEditPolicy extends MaskatComponentEditPolicy {
	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		MaskatElement model = (MaskatElement) getHost().getModel();
		return new DelRadioCommand(model.getParent(), model);
	}

	public EditPolicy cloneEditPolicy() {
		EditPolicy editPart =  new RadioComponentEditPolicy();
		editPart.setHost(getHost());
		return editPart;
	}
}
