/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.widget.rialto.commands.DelComboItemCommand;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;


public class ComboItemEditPolicy extends MaskatComponentEditPolicy {

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		Component model = (Component) getHost().getModel();

		return new DelComboItemCommand((Component) model.getParent(), model);
	}
}
