/*
 * Copyright (c) 2006-2011 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editpolicies.FeedBackComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.TabItemComponentLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.figure.TabItemFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;


public class TabItemEditPart extends ComponentEditPart {
	
	protected IFigure createFigure() {
		return new TabItemFigure();
	}
	
	protected void createEditPolicies() {
		super.createEditPolicies();
		int style = FeedBackComponentEditPolicy.getStyle(this);
		installEditPolicy(EditPolicy.LAYOUT_ROLE,
			new TabItemComponentLayoutEditPolicy(style));
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}

	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Component parent = (Component) comp.getParent();
		
		Rectangle constraint = new Rectangle(0, 21, parent.getWidth() - 2,
				parent.getHeight() - 21);
		
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
		}
		super.propertyChange(evt);
	}
	
	public String getTitle() {
		return (String) ((DynaComponent) getModel()).get("title");
	}

	public void setTitle(String text) {
		((DynaComponent) getModel()).set("title", text);
	}

	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();

			if (dynaClass.getLibrary() == child.getLibrary() &&
					"tabItem".equals(child.getName())) {
				return true;
			}			
			return !child.isItem();
		}
		return true;
	}
	
	public String getOutlineLabel() {
		StringBuffer sb = new StringBuffer(super.getOutlineLabel());
		sb.append(" - ("); //$NON-NLS-1$
		sb.append(getTitle() == null ? "" : getTitle()); //$NON-NLS-1$
		sb.append(")"); //$NON-NLS-1$
		return sb.toString();
	}
}
